
.include "fb32x32.inc"

.include "globals.inc"

bits     = tmp8
.define  COLBASE  $90
.define  COLXOR   $30
linestab = localram+$00
tabstart = linestab+$10
tabvalue = tabstart+1
imgheight= tabvalue+1

.segment "GFXDATA"

title:
   .byte $e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1
   .byte $e1,$01,$e1,$e1,$01,$e1,$e1,$e1,$e1,$01,$e1,$e1,$e1,$01,$01,$01,$e1,$01,$01,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$01,$e1,$e1,$e1,$e1
   .byte $01,$01,$e1,$e1,$01,$e1,$e1,$e1,$e1,$01,$e1,$e1,$e1,$01,$e1,$e1,$e1,$01,$e1,$01,$e1,$01,$01,$01,$e1,$e1,$e1,$e1,$e1,$01,$01,$01
   .byte $e1,$01,$e1,$e1,$01,$e1,$01,$e1,$e1,$01,$e1,$e1,$e1,$01,$01,$e1,$e1,$01,$e1,$01,$e1,$01,$e1,$e1,$e1,$e1,$e1,$01,$e1,$01,$e1,$e1
   .byte $e1,$01,$e1,$e1,$01,$01,$e1,$e1,$e1,$01,$e1,$e1,$e1,$01,$e1,$e1,$e1,$01,$e1,$01,$e1,$01,$01,$01,$e1,$e1,$e1,$01,$e1,$01,$01,$01
   .byte $e1,$01,$e1,$e1,$01,$e1,$01,$e1,$e1,$01,$e1,$e1,$e1,$01,$e1,$e1,$e1,$01,$e1,$01,$e1,$e1,$e1,$01,$e1,$e1,$e1,$01,$e1,$e1,$e1,$01
   .byte $01,$01,$01,$e1,$01,$e1,$01,$e1,$e1,$01,$01,$01,$e1,$01,$01,$01,$e1,$01,$01,$e1,$e1,$01,$01,$01,$e1,$e1,$e1,$01,$e1,$01,$01,$01
   .byte $e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1
   .byte $e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1
   .byte $e1,$e1,$01,$e1,$e1,$01,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$01,$e1,$e1,$e1,$01,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$01,$e1,$e1,$01,$e1,$e1,$e1
   .byte $e1,$e1,$01,$01,$e1,$01,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$01,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$01,$01,$01,$e1,$e1
   .byte $e1,$e1,$01,$e1,$01,$01,$e1,$01,$01,$01,$e1,$e1,$e1,$01,$e1,$e1,$e1,$01,$e1,$01,$01,$01,$01,$e1,$e1,$01,$e1,$e1,$01,$e1,$e1,$e1
   .byte $e1,$e1,$01,$e1,$e1,$01,$e1,$01,$e1,$01,$e1,$e1,$e1,$01,$e1,$e1,$e1,$01,$e1,$01,$e1,$01,$e1,$01,$e1,$01,$e1,$e1,$01,$e1,$e1,$e1
   .byte $e1,$e1,$01,$e1,$e1,$01,$e1,$01,$e1,$01,$e1,$e1,$e1,$01,$e1,$e1,$e1,$01,$e1,$01,$e1,$01,$e1,$01,$e1,$01,$e1,$e1,$01,$e1,$e1,$e1
   .byte $e1,$e1,$01,$e1,$e1,$01,$e1,$01,$01,$01,$e1,$e1,$e1,$01,$01,$01,$e1,$01,$e1,$01,$e1,$01,$e1,$01,$e1,$01,$e1,$e1,$01,$01,$e1,$e1
   .byte $e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1,$e1

.segment "DATA"

flipdata:
   .byte $30,$30,$30,$00,$00,$30,$00,$00,$00,$30,$00,$00,$00,$30,$00,$00
   .byte $30,$30,$00,$30,$00,$00,$30,$00,$00,$30,$00,$00,$00,$30,$00,$00
   .byte $30,$30,$00,$30,$00,$00,$30,$00,$00,$00,$30,$00,$00,$30,$00,$00
   .byte $30,$30,$00,$30,$00,$00,$30,$00,$00,$00,$30,$00,$00,$00,$30,$00
   .byte $30,$30,$00,$30,$00,$00,$00,$30,$00,$00,$30,$00,$00,$00,$30,$00
   .byte $30,$30,$00,$00,$30,$00,$00,$30,$00,$00,$00,$30,$00,$00,$30,$00
   .byte $30,$30,$00,$00,$30,$00,$00,$30,$00,$00,$00,$30,$00,$00,$30,$00
   .byte $30,$30,$00,$00,$30,$00,$00,$00,$30,$00,$00,$30,$00,$00,$00,$30
   .byte $30,$00,$30,$00,$30,$00,$00,$00,$30,$00,$00,$00,$30,$00,$00,$30
   .byte $30,$00,$30,$00,$00,$30,$00,$00,$30,$00,$00,$00,$30,$00,$00,$30
   .byte $30,$00,$30,$00,$00,$30,$00,$00,$00,$30,$00,$00,$30,$00,$00,$30

outside:
   .byte %00011110
   .byte %00011110
   .byte %00111100
   .byte %00111100
   .byte %01111000
   .byte %01111000
   .byte %11110000
   .byte %11110000
   .byte %11100000
   .byte %11100000
   .byte %11000000
   .byte %11000000
   .byte %10000000
   .byte %10000000
   .byte %00000000
   .byte %00000000
inside:
   .byte %00011111
   .byte %00011111
   .byte %00011111
   .byte %00011111
   .byte %00111111
   .byte %00111111
   .byte %00111111
   .byte %00111111
   .byte %01111111
   .byte %01111111
   .byte %01111111
   .byte %01111111
   .byte %11111111
   .byte %11111111
   .byte %11111111
   .byte %11111111

.segment "CODE"

incval:
   lda   tabvalue
   ldx   tabstart
   inx
   cpx   #$0b
   bcc   :+
   ldx   #$00
   eor   #COLXOR
   sta   tabvalue
:
   stx   tabstart
   rts

gentab:
   jsr   incval
   jsr   incval
   txa
   asl
   asl
   asl
   asl
   tay
   lda   tabvalue
   ldx   #$00
:
   eor   flipdata,y
   sta   linestab,x
   iny
   inx
   cpx   #$10
   bcc   :-

   rts


ballblazer:
   lda   #>(FRAMEBUFFER+$200)
   stz   vector+0
   sta   vector+1

   jsr   gentab

   lda   frmcnt+0
   ora   frmcnt+1
   bne   @initdone

   ; clear upper half
   ldx   #$00
:
   stz   FRAMEBUFFER+$000,x
   stz   FRAMEBUFFER+$100,x
   inx
   bne   :-

   lda   #>FRAMEBUFFER
   stz   FB32X32_SRC+0
   sta   FB32X32_SRC+1

   stz   FB32X32_DEST_X
   stz   FB32X32_DEST_Y

   lda   #$0f
   sta   FB32X32_HEIGHT
   lda   #$1f
   sta   FB32X32_WIDTH
   sta   FB32X32_STEP
   stz   FB32X32_COPYN

   lda   #$09
   sta   FB32X32_COLMAP
   bra   @lineloop

@initdone:
   ldx   imgheight
   lda   frmcnt
   cmp   #$30
   bcc   @notitledraw
   and   #$07
   bne   @notitledraw
   inx
   cpx   #$11
   bcc   :+
   dex
:
   stx   imgheight
   txa
   beq   @lineloop

   lda   #<title
   sta   FB32X32_SRC+0
   lda   #>title
   sta   FB32X32_SRC+1

   txa
   dec
   sta   FB32X32_HEIGHT

   eor   #$0f
   stz   FB32X32_DEST_X
   sta   FB32X32_DEST_Y

   lda   #$1f
   sta   FB32X32_WIDTH
   sta   FB32X32_STEP
   stz   FB32X32_COPYN
@notitledraw:

   ldx   #$00

@lineloop:
   ldy   #$00

   lda   outside,x
   sta   bits
@loopol:
   txa
   ora   #COLBASE
   asl   bits
   bcc   :+
   eor   #COLXOR
:
   eor   linestab,x
   sta   (vector),y
   iny
   cpy   #$08
   bne   @loopol

   lda   inside,x
   sta   bits
@loopil:
   txa
   ora   #COLBASE
   asl   bits
   bcc   :+
   eor   #COLXOR
:
   eor   linestab,x
   sta   (vector),y
   iny
   cpy   #$10
   bne   @loopil

   lda   inside,x
   sta   bits
@loopir:
   txa
   ora   #COLBASE
   lsr   bits
   bcs   :+
   eor   #COLXOR
:
   eor   linestab,x
   sta   (vector),y
   iny
   cpy   #$18
   bne   @loopir

   lda   outside,x
   sta   bits
@loopor:
   txa
   ora   #COLBASE
   lsr   bits
   bcs   :+
   eor   #COLXOR
:
   eor   linestab,x
   sta   (vector),y
   iny
   cpy   #$20
   bne   @loopor

   clc
   lda   vector+0
   adc   #$20
   sta   vector+0
   bcc   :+
   inc   vector+1
:
   inx
   cpx   #$10
   bne   @lineloop

   ldx   #$1f
:
   lda   FRAMEBUFFER+$200,x
   ora   #$01
   sta   FRAMEBUFFER+$200,x
   dex
   bpl   :-

   lda   #>(FRAMEBUFFER+$200)
   stz   FB32X32_SRC+0
   sta   FB32X32_SRC+1

   stz   FB32X32_DEST_X
   lda   #$10
   sta   FB32X32_DEST_Y

   lda   #$1f
   sta   FB32X32_HEIGHT
   sta   FB32X32_WIDTH
   sta   FB32X32_STEP
   stz   FB32X32_COPY

   lda   frmcnt+0
   cmp   #$ff
   bne   :+
   jmp   schedulenext
:
   rts
