
; 117 bytes in binary

* = $c000	; don't change this without updating the 'lda #$c0' in the init code

; zero page work areas

ZP_SAVE_SRC_Y = $92
ZP_SAVE_DST_Y = $93

ZP_SAVE_X = $94

.virtual $95
	ZP_SRC_PTR .block
		lo .byte ?
		hi .byte ?
	.bend
.endv

.virtual $97
	ZP_DST_PTR .block
		lo .byte ?
		hi .byte ?
	.bend
.endv

; -----------------------------------------------------------------------------

		; init
		
		lda #$00
		sta ZP_DST_PTR.lo
		lda #$04
		sta ZP_DST_PTR.hi
		lda #$c0
		sta ZP_SRC_PTR.hi
		
		; draw the shapes
		
		ldx #<shape_01
		jsr draw_shape
		
		ldx #<shape_02
		jsr draw_shape

		jsr draw_shape3_8_times
		
		ldx #<shape_02
		jsr draw_shape

		jsr draw_shape3_8_times

		ldx #<shape_02
		jsr draw_shape

		rts

; -----------------------------------------------------------------------------
; extracted so it could be called twice without duplicating the code

draw_shape3_8_times .proc

		ldx #8
-		
		stx ZP_SAVE_X
		ldx #<shape_03
		jsr draw_shape
		ldx ZP_SAVE_X
		dex
		bne -
		
		rts
.pend

; -----------------------------------------------------------------------------

draw_shape .proc

		stx ZP_SRC_PTR.lo
		
		ldy #0
		sty ZP_SAVE_DST_Y
-
		; load the next character
		;
		; characters are stored as screen codes. optionally, the high
		; bit can also be set which indicates a repeating character.
		;
		; %0xxxxxxx - 1 copy
		; %1xxxxxxx - 8 copies
		
		lda (ZP_SRC_PTR),y
		beq exit

		iny
		sty ZP_SAVE_SRC_Y

		; compute how many times this character needs to be repeated
		
		ldx #1
		
		; shift A to the left, dropping the high bit into the carry flag
		
		asl
		
		; if the high bit was clear, skip ahead.
		; otherwise set the repeat count to 8.
		
		bcc +
		ldx #8
+
		; shift A to the right, zeroing out the high bit. A now contains
		; the character code we need to store in screen memory.
		 
		lsr
		
		ldy ZP_SAVE_DST_Y
-
		; store char value to screen until X is depleted
		sta (ZP_DST_PTR),y
		iny
		dex
		bne -
		
		sty ZP_SAVE_DST_Y
		ldy ZP_SAVE_SRC_Y
		
		bne --
		
exit

	lda ZP_DST_PTR.lo
	; clc - commenting this out seems to work. it may be a bad idea but it saves a byte...
	adc #40
	sta ZP_DST_PTR.lo
	bcc +
		inc ZP_DST_PTR.hi
	+

	rts

.pend

; screen codes. setting the high bit indicates
; a repeat count of 8 (defaults to 1)

CHAR_CORNER		= %00101011
CHAR_H_8		= %00101101	| %10000000
CHAR_V			= %00100001
CHAR_BOW_L		= %01001101
CHAR_BOW_M		= %00001111
CHAR_BOW_R		= %00101111
CHAR_SPACE_8	= %00100000	| %10000000

shape_01 .byte CHAR_SPACE_8, CHAR_BOW_L, CHAR_BOW_M, CHAR_BOW_R, 0
shape_02 .byte CHAR_CORNER, CHAR_H_8, CHAR_CORNER, CHAR_H_8, CHAR_CORNER, 0
shape_03 .byte CHAR_V, CHAR_SPACE_8, CHAR_V, CHAR_SPACE_8, CHAR_V, 0
