
*       = $2d1-26	; position the script at $2d1
	msg_ptr = $75	; points at $2d0, where the script is
	cnt_ptr = $b2	; points at tape buffer filled with 0's
	CHROUT = $ffd2	; print character in A

print
	jsr CHROUT	; output character
no_print		; relatively harmless to fall through
	lda (cnt_ptr),y	; check loop counter against token
	cmp (msg_ptr),y	; has loop finished? (or is not a loop)
	bmi reset	; then reset counter and move on
	adc #$10	; otherwise increment loop counter by $10
	sta (cnt_ptr),y	; store for next loop iteration
	ane #$f		; A = X & $f, extract target index
	tay		; update read pointer
reset			; relatively harmless to fall through
	sha (cnt_ptr),y	; "zero" out counter
start
	iny		; increment read pointer
	lax (msg_ptr),y	; keep a copy of token in X for later
	bmi no_print	; >=$80 is a loop token, so don't print it
	bne print	; print literals, except 0 token = done
	rts

	; The script contains either literal characters or loop 
	; tokens. A loop token is indicated by the high bit being
	; set. The top nibble holds the loop count and the bottom
	; nibble which index to loop back to that number of times

loop	.sfunction _count, _target, (7+_count)<<4|_target
jump	.sfunction _target, $f<<4|_target

	; PETSCII
	.tdef "\", $6d
	.edef "\n", 13
script
.logical 0
space_1
	.text " ", loop( 8, space_1 ), "\o/", jump( plusline )
bangline
	.text "\n"
bang	.text "!"
space_2	.text " ", loop( 7, space_2 )
	.text loop( 2, bang )
	.text loop( 7, bangline )
plusline
	.text "\n"
plus	.text "+"
dash	.text "-",loop( 7, dash )
	.text loop( 1, plus ), "+"
	.text loop( 2, bangline )
.endlogical
