;==============================================================================
; VINTAGE COMPUTING CHRISTMAS CHALLENGE 2024 (VC3 2024)
; platform    - Amstrad CPC 6128
; language    - Z80 assembly
; contributor - PRODATRON
; date        - December 2024
;------------------------------------------------------------------------------
; size        - 54 bytes
;==============================================================================

;from Basic start with...
;MEMORY &5C1F
;LOAD"XC24PDT
;CALL &5C20

;This approach divides the figure into many smaller and smaller building blocks
;that all build on each other. This is even used to draw the bow.
;It's not the shortest solution, but I still like the reduced building block
;idea. It's full of CALLs, and the Z80 doesn't support relative ones, otherwise
;it could be shorter.
;HL is completely unused, no idea, if it could be used for decreasing the size.

txtout  equ #bb5a

de_org  equ "\"*256+" "         ;start/call address sets DE to "\ " (#5c20)

org     de_org

        call gift_linesub       ;plot first bow part
        ld de,"/"*256+"o"
        ld b,1
        call gift_chars         ;plot second bow part
        call gift_linesep       ;plot first of the three gift lines
        call gift_block         ;plot upper gift part
gift_block                      ;plot lower gift part
        ld c,8
gift_blockloop
        ld de,"!"*256+" "
        call gift_linefull
        dec c
        jr nz,gift_blockloop
gift_linesep   
        ld de,"+"*256+"-"
gift_linefull
        rst #18                 ;plots one full line (L=line, H=separator)
        dw rom_crlf             ;cr/lf
        call gift_charsingle    ;first char
        call gift_linesub       ;first subline
gift_linesub
        ld b,8                  ;plots one subline (E=line, D=separator)
gift_chars
        ld a,e
gift_charloop
        call txtout
        djnz gift_charloop
gift_charsingle
        ld a,d                  ;plots one char (D)
        jp txtout

rom_crlf
        dw #c3e2                ;prints crlf (expects 0 behind it)

totlen equ $-de_org
