# Vintage Computing Christmas Challenge 2024 (VC3-2024)

(https://logiker.com/Vintage-Computing-Christmas-Challenge-2024)

| System | Matra-Hachette Alice 32 |
|:---|:---|
| **Language** | **BASIC** |
| Author | ivan@paspeur.com |
| Length of source code | 106 bytes |
| Length of tokenized BASIC code | 87 bytes |
| Video (once challenge closes) | https://pasp.eu/a9f0 |

![Code](image_1-code.png)

![Result](image_2-result.png)

## The Matra-Hachette Alice 32 Computer

The Matra-Hachette Alice 32 is a French microcomputer introduced in 1983 as an upgrade to the original [Alice](https://en.wikipedia.org/wiki/Matra_Alice), a clone of the [TRS-80 MC-10](https://en.wikipedia.org/wiki/TRS-80_MC-10) produced through a collaboration between Matra and Hachette in France and Tandy Corporation/Radio Shack in the United States.

While it retains the original Alice's case design, the Alice 32 features a different video chip, the [Thomson EF9345](https://en.wikipedia.org/wiki/Thomson_EF9345), which offers a new text mode supporting 40 columns and 25 lines. It is this specific text mode that we use here so we can display the entire Christmas present.

## The DCALICE Emulator

You can run the code on the real hardware or with [DCALICE](http://alice32.free.fr), an emulator under Windows, for the MC-10 and Alice computers.

## Running the code

Under BASIC:

```
MICROCOLOR BASIC 1.0
COPYRIGHT 1982 MICROSOFT
OK
█
```

- Enter the 40x25 text mode:

```
CLS 40
```

- Type or copy-paste the code:

```
1?TAB(8)"\O/":GOSUB3:GOSUB2:GOSUB2:END
2FORI=1TO8:?"!        !","  !":NEXT
3?"+--------+--------+":RETURN
```

- Run the program:

```
RUN
```

- Merry Christmas!

```
        \O/
+--------+--------+
!        !        !
!        !        !
!        !        !
!        !        !
!        !        !
!        !        !
!        !        !
!        !        !
+--------+--------+
!        !        !
!        !        !
!        !        !
!        !        !
!        !        !
!        !        !
!        !        !
!        !        !
+--------+--------+
```
