;
;	XL-Mas Present 2024 by JAC! of WUDSN.
;
;	Done for "https://logiker.com/Vintage-Computing-Christmas-Challenge-2024".
;	Binary size 89 bytes, code size 83 bytes.
;
;	Load from SpartaDos with Atari XL 800 OS REV C.
;	The program clears the screen and works with BASIC enabled or disabled.
;	Thanks to Logiker for this challenge.

put_char	= $f2b0	; E: PUT BYTE ($E406)+1
bar_cnt		= $7f

	org $80

	ldx #[.len header]-1
loop	lda header,x
	jsr char
	bpl loop

start	jsr dash_line
	jsr bar_lines_dashLine

	.proc bar_lines_dashLine
	jsr bar_lines
	.endp
	
	.proc dash_line
	ldy #0
	.endp

	.proc line_newline	;IN: <y>=char_offset
	jsr dash_plus.plus
	jsr dash_plus
	jsr dash_plus
newline	lda #$9b
	bne char
	
	.proc dash_plus
	ldx #7
loop	lda second_char,y
	jsr char
	bpl loop

plus	lda first_char,y
	.endp
	
	.endp
	
	.proc char
	stx savex+1 
	sty savey+1
	jsr put_char
savex	ldx #0
savey	ldy #0
	dex
	rts
	.endp

	.proc bar_lines
	stx bar_cnt	;$ff..$fx
	iny		;$00 => $01
loop	jsr line_newline
	lsr bar_cnt
	bne loop	;8 times
	rts
	.endp

first_char
	.byte '+','!'
second_char
	.byte '-',' '

	.local header
	.byte $9b,$2f,$4f,$5c,$20,$20,$20,$7f,$7d
	.endl
