; Commodore C128 entry for VCCC2024 by GeirS, 2024-12-23.
; Size: 41 bytes excl. load address. Assemble using 64tass.
; Requires loading at specific address (e.g. LOAD "PRESENT",8,1) and SYS 11552 to start.

PrImm           = $fa15             ; Print inline null-terminated string (actually $fa17)
NewLine         = $a2ce             ; Print new line char
EorValues       = $88fd             ; Contains values 1 and 6
Crsw            = $d6               ; Input flag
Pnt             = $e0               ; Pointer to current screen line
Every9thRow     = $84               ; Variable for determining every 9th row (1 at startup)
Every9thCol     = $13               ; Variable for determining every 9th column (0 at startup)
BoxChars        = $16               ; Contains values 32 and 45 after SYS command

                * = $2d20           ; Load address

; Code and data (41 bytes)
Start           jsr PrImm           ; Print inline null-terminated string
                .byte 9,205,79,47,0 ; Tab, '\', 'O', '/', 0
RowLoop         cpx #1              ; Set carry flag to 9th bit of Every9thRow
                ror Every9thRow
                rla Crsw            ; Set acc. to 1 if carry is set, else 0
                tax                 ; Index to 'BoxChars'
                jsr NewLine         ; Print new line char (also sets 'Crsw' to zero)
                inc Every9thCol     ; Set initial value for current row
                ldy #19-1           ; 19 columns per row
ColLoop         lda BoxChars,x      ; Get space or '-'
                ror Every9thCol
                bcc PutChar         ; Branch if not 0th, 9th or 18th column
                eor EorValues,x     ; Change space to '!' or '-' to '+'
PutChar         sta (Pnt),y         ; Put char on screen
                dey
                bpl ColLoop         ; Loop for all columns
                asl $43,x           ; Contains word $1c00 at startup
                bpl RowLoop         ; Loop for all rows
                rts
