--   name: qrint - the quilled print-function
-- author: Decca / RiFT
-- script: lua
--   info: adds centering (x or y or both), outline and shadows (left or right) to the build-in print-function of the TIC-80
-- syntax: qrint(text, [x=0 to 240/false], [y=0 to 136/false], [color=0 to 15], [fixed=true/false], [scale=1 to x], [smallfont=true/false], [outline=0 to 15], [shadow=0 to 15], [shadowdirection=true/false])
return function(R)
    R.qrint=function(txt,x,y,col,fix,scl,sml,otl,sdw,sdr)
        local width=0
        ht=7 -- height (default: 6)
        wd=6 -- width (default: 6)
        rows = select(2,txt:gsub("\n","\n"))+1
        if not y then ypos = 60-(rows/2*((ht+2)*scl)) else ypos = y end
        if not scl then scl=1 end
        if not fix then mgx=2.25 else mgx=2.075 end
        if sml then mgx=(mgx*1.55) end
        if scl > 1 then mgx=(mgx/scl) end
        for row in string.gmatch(txt,"([^".."\n".."]+)") do
            if not x then xpos=119-(#row*6)/mgx else xpos=x end
            if sdw then -- shadow
                if sdr then -- left
                    print(row,xpos-1,ypos+1,sdw,fix,scl,sml)
                    print(row,xpos-2,ypos+1,sdw,fix,scl,sml)
                    print(row,xpos-1,ypos+2,sdw,fix,scl,sml)
                    print(row,xpos-2,ypos+2,sdw,fix,scl,sml) 
                else --right
                    print(row,xpos+1,ypos+1,sdw,fix,scl,sml)
                    print(row,xpos+2,ypos+1,sdw,fix,scl,sml)
                    print(row,xpos+1,ypos+2,sdw,fix,scl,sml)
                    print(row,xpos+2,ypos+2,sdw,fix,scl,sml)  
                end
            end
            if otl then -- outline
                print(row,xpos-1,ypos,otl,fix,scl,sml)
                print(row,xpos+1,ypos,otl,fix,scl,sml)
                print(row,xpos,ypos-1,otl,fix,scl,sml)
                print(row,xpos,ypos+1,otl,fix,scl,sml)
            end
            width=print(row,xpos,ypos,col,fix,scl,sml)
            ypos=ypos+(ht+1)*scl
            if otl then ypos=ypos+2 end
            if sdw then ypos=ypos+1 end
        end
        return width
    end
end