# System level functions

## sys

### tryBreak(keycode=51)

Sometimes Esc doesn't escape.  
This allows the user to break out of a running program by pressing backspace.  

You can optionally supply a [https://github-wiki-see.page/m/nesbox/TIC-80/wiki/key](keycode), i.e. `.TryBreak(48)` will break on spacebar.

```
local R={}
require("./sys/sys")(R)

function TIC()
    R.tryBreak()
    ...
end
```

### hideMouse()

Needs to be called every TIC `¯\_(ツ)_/¯`

## palette

### palette.setRGBU(i,r,g,b)

Set the palette entry at index i to the r,g,b values, which are unit scale (i.e. 0-1)

## math

### clamp(v,min,max)

Clamp v between min and max

### lerp(t,v0,v1)

Linear interpolation between v0 and v1 - t is the interpolation factor (0-1)

### qbezier(t,v0,v1,v2)

Quadratic Bézier function

### cbezier(t,v0,v1,v2,v3)

Cubic Bézier function
