return function(R)
    require("./sys/rgb")(R)

    R.Palette={}

    function R.Palette:new()
		local o={rgbs={}}
		setmetatable(o,self)
		self.__index=self
		return o
	end

    function R.Palette:setRGB(i,rgb)
        self.rgbs[i]=rgb
    end

    -- can return rgb or nil
    function R.Palette:getRGB(i)
        -- #TODO: Check this returns nil if it doesn't exist
        return self.rgbs[i]
    end

    function R.Palette:setAllRGB(rgb,fromI,toI)
        fromI=fromI or 0
        toI=toI or 15
        for i=fromI,toI do
            self:setRGB(i,rgb)
        end
    end

    function R.Palette:blendC(toPalette,t)
        local newPal=R.Palette:new()
        for i,rgb in pairs(self.rgbs) do
            local toRGB=toPalette:getRGB(i)
            local rgbBlend=toRGB and rgb:getBlendTo(toRGB,t) or rgb
            newPal:setRGB(i,rgbBlend)
        end
        return newPal
    end

    function R.Palette:apply()
        for i,rgb in pairs(self.rgbs) do
            R.setRGB(i,rgb)
        end
    end

    -- unitT: 0..1
    function R.Palette:applyBlend(toPalette,t)
        for i,rgb in pairs(self.rgbs) do
            local toRGB=toPalette:getRGB(i)
            local rgbBlend=toRGB and rgb:getBlendTo(toRGB,t) or rgb
            R.setRGB(i,rgbBlend)
        end
    end

    function R.Palette:readSys()
        for i=0,15 do
            self:setRGB(i,R.getRGB(i))
        end
    end
end