return function(R)
    -- http://lua-users.org/wiki/CopyTable
    R.shallowCopy=function(src)
        local dst
        if type(src)=='table' then
            dst = {}
            for k,v in pairs(src) do
                dst[k]=v
            end
        else -- number, string, boolean, etc
            dst=src
        end
        return dst
    end

    -- http://lua-users.org/wiki/CopyTable
    -- Not sure if this works- seems to recursive loop on my test
    R.deepCopy=function(src)
        local dst
        if type(src)=='table' then
            dst={}
            for k,v in next,src,nil do
                trace(k)
                dst[R.deepCopy(k)]=R.deepCopy(v)
            end
            setmetatable(dst,R.deepCopy(getmetatable(src)))
        else -- number, string, boolean, etc
            dst=src
        end
        return dst
    end
end
