# TIC Packages

## Packages

Suggested deployment into TIC-80 App data directory under folder `~/rift/`  
[jtruk: for me, this is `C:/Users/(mysystemusername)/AppData/Roaming/com.nesbox.tic/TIC-80/rift`, similar for Mantratronic. Mac/Linux folks, how about you..?]

## Orientation

Each package sits under a top level folder, and includes one or more `test-??.lua` files. These are a good place to get an idea about loading the package and the code interfaces.

In the top level code file, before requiring any of this code, add your path to the `package.path` string. There's maybe a nicer way do this for cross-programmer development?

## NB

Readmes are imcomplete/inaccurate and function interfaces are likely to change in signature / capitalisation etc., but this shouldn't be too dramatic when we're just playing around to start with!

### Sys

- sys: System level helpers.
- math: Math helpers.
- palette: Palette helpers.

### 3D

- geom: Basic geometry helpers: V4 (vector 4) and M44 (matrix 4x4) implementations.
- poly: Triangle transformation and readying for draw.
- cam: Camera matrix maker.
- proj: Projection matrix maker.
- world: Container for the 3D world.

### Sound

- music: Music helpers.
- noise: Noise makers/getters.

### UI

- (TODO) dmenu: Debug style menu
- qrint: A fluffy version of print!

### Data

3D models.
Fonts.

## Have Problems?

Things that are hard to spot, but cause big problems!

- Calling obj.fn(args) when you should be calling obj:fn(args) [or class.fn(obj, args) if you must!]
- Calling mat=mat:mulM44(mat2), when it should be mat:mulM44(mat2) [i.e. in place] or mat:mulM44C(mat2) [i.e. clone]
- Missing () from function generators, e.g. Draw1Colour instead of Draw1Colour(2)

## Code style

Desire is to keep code short, and light, but avoiding opportunities for confusion.

Global functions can be added to R if there's no reasonable expectation of conflict. Otherwise, they can be 'namespaced', e.g. `R.noise.makeWave()` where makeWave might otherwise be ambiguous.

Functions and variables are camelCase. Retain multiple capitals in a row, e.g. setRGB.
Functions that are expected to be internal (i.e. not intended to be exposed to the user are prefaced with an underscore)
Classes are PascalCase and attached to global scope.


## References

The following look good:

- [codinglabs.net - World, View and Projection Transformation Matrices](http://www.codinglabs.net/article_world_view_projection_matrix.aspx)
