-- title:  Font Routines
-- author: Mantratronic / RiFT
-- desc:   font writer@demo framework
-- script: lua

package.path=package.path..";C:\\Users\\micro\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jtruk
package.path=package.path..";C:\\Users\\Ronan\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- Mantratronic
package.path=package.path..";C:\\Users\\Matt\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jynx

local R={}
require("./sys/sys")(R)
require("./font/font")(R)
require("./font/sysfont")(R)

local PART=0
local FONT=nil

function BOOT()
    local font=require("./data/sysfont/informics-7x7/informics-7x7-raw")
    R.sysfontLoad(font)

    local fontdata=require("./data/font/nucampi-8x16/nucampi-8x16-raw")
    FONT=R.Font:new()
    FONT:load(fontdata)

    parts()
end

function parts()
    PART=PART%6

    cls(0)
    if PART == 0 then
        drawText({"This is some", "TIC-80 Stuff", "at Nova..."},50)
    elseif PART == 1 then
        print("WE SEND SOME GREETINGS TO:",49,30,6)
        print("* FIELD-FX CREW",68,48,9)
        print("* NOVA ORGAS",68,60,10)
        print("* BRITISH LIFE GUARD",68,72,12)
        print("* BEER SUPPLIERS",68,84,13)
        print("* ALL PARTICIPANTS",68,96,14)
    elseif PART == 2 then
        print("CODING BY:",69,20,12)
        drawText({"Mantratronic", "T=Bach", "Jtruk", "Jynx"},50)
    elseif PART == 3 then
        print("PIXELS BY:",81,40,12)
        drawText({"Bossmann", "Decca"},50)
    elseif PART == 4 then
        print("MUSIC BY:",92,50,12)
        drawText({"T=Bach"},50)
    elseif PART == 5 then
        drawText({"RiFT IN 2023"},40)
        print("MAY THE DEMOLITION",70,72,13)
        print("BE WITH YOU.",70,80,14)	
    end
end

function TIC()
    R.tryBreak()

    if keyp(48,60,6) then PART=PART+1 parts() end
	if keyp(51,60,6) then PART=PART-1 parts() end
end

function drawText(text,ypos)
    local tl = text
    local tlg
    for i=1,#tl do
	    tlg = FONT:width(tl[i])
	    FONT:print(tl[i],120-(tlg/2),ypos+(20*(i-#tl/2)))
    end
end

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

