return function(R)
    function R.sysfontLoad(font)
        if font.rle then
            R.sysfontLoadRLE(font)
        else
            R.sysfontLoadRAW(font)
        end
    end

    function R.sysfontLoadRLE(font)
        local str=font.rle
        local o=tonumber(str:sub(1,5),16) -- get (o)ffset
        local w=tonumber(str:sub(6,7),16)*8-1 -- get (w)idth
        local e=str:sub(8,str:len()) -- remove header to get (e)ncoded data
        local d = "" -- (d)ecoded data
        for m, c in e:gmatch("(%u+)([^%u]+)") do -- decode rle, (m)atch & (c)ounter
            d = d .. m .. (m:sub(-1):rep(c))  
        end
        local y=0
        for x = 1,#d,1 do -- write to mem
            local c=string.byte(d:sub(x,x))-65 -- get (c)olor value
            poke4(o+y,c) y=y+1
            if y>w then y=0 o=o+1024 end
        end
    end

    function R.sysfontLoadRAW(font)
        local str=font.raw
        local tnb=tonumber
        local o=tnb(str:sub(1,5),16) -- get (o)ffset
        local w=tnb(str:sub(6,7),16)*8-1 -- get (w)idth
        local d=str:sub(8,str:len()) -- remove header to get (d)ata
        local y=0
        for x = 1,#d,1 do -- write to mem
        local c=tnb(d:sub(x,x),16) -- get (c)olor value
        poke4(o+y,c) y=y+1
            if y>w then y=0 o=o+1024 end
        end
    end
end
  