# 3D Model spec

To have a compact format while retaining a good resolution, the `vertices` are specified within whatever space is preferred, and then scaled to a common space.

An appropriate example would be x,y,z values that sit 0-255 in relation to each other (which we can then compress). This is divided by `divide_by` (the maximum extent, i.e. 256 in this case). This is then multiplied by `scale` to bring the models into the correct relationship with each other - it's suggested that a scale of 1 maps the model to 1m^3. So, for a human, we might rescale to ~1.6, so that the model is 1.6m tall.

The `origin` is the handle for the model. This is the location that will sit at 0 if we render the model with no other transformations. Any local model rotation will happen around this point.

- vertices: A list of x,y,z values.
    {p1x,p1y,p1z,p2x,p2y,p2z...}
    [Expectation is that these are integer- but that's currently not enforced]
- vertices_ex: A list of [ex] values for the vertices
- triangles: A table of integer triplets specifying the indices of points in the `vertices` table (1-indexed) to make the object tris.
    {t1a,t1b,t1c,t2a,t2b,t2c...}
- triangles_ex: A list of [ex] values for the vertices
- scale: To scale from the stored model data into model space. Suggest this is metres to keep everything together.
- origin: The handle for the model in unit space.
    {ox,oy,oz}
- vanim: Vertex animation definitions:
    {["walk"]={{f1v1x,f1v1y,f1v1z,f1v2x,v1v2y,v1v2z,...},{f2v1x,f2v1y,f2v1z,f2v2x,v2v2y,v2v2z,...}...}
- drawpasses: For multi texture pass
    ```
    one={priority=1,triangles={5,6,8,8,7,5,1,4,2,4,1,3,5,1,2,2,6,5,8,4,3,3,7,8,2,4,8,8,6,2,1,5,7,7,3,1,}},
    two={priority=2,triangles={5,6,8,1,4,2,5,1,2,8,4,3,2,4,8,1,5,7,}},
    ```
    These need to be matched with "one" and "two" drawing functions in the Actor
- bone:
    bones:{{p1=b1p1,p2=b1p2,v={1,2,3}},{p1=b2p1,p2=b2p2,v={4,5,6}}
- flags: (Currently unused- remove if that continues to be the case)