-- Make a subdivided,textured rect
-- model goes from w/2 to h/2
-- wSegs -> number of segments across
-- hSegs -> number of segments down
return function(w,h,xSegs,ySegs)
    local m={vertices={},triangles={},triangles_ex={},origin={0,0,0}}

    for pYi=0,ySegs do
        for pXi=0,xSegs do
            local vxu=pXi/xSegs
            local vyu=pYi/ySegs

            local x=-w/2+vxu*w
            local y=-h/2+vyu*h
            
            m.vertices[#m.vertices+1]=x
            m.vertices[#m.vertices+1]=y
            m.vertices[#m.vertices+1]=0

            -- Add triangles
            if pXi>0 and pYi>0 then
                local triX0Y0=(pYi-1)*(xSegs+1)+(pXi-1)+1
                local triX1Y0=(pYi-1)*(xSegs+1)+(pXi)+1
                local triX1Y1=(pYi)*(xSegs+1)+(pXi)+1
                local triX0Y1=(pYi)*(xSegs+1)+(pXi-1)+1
                m.triangles[#m.triangles+1]=triX0Y0
                m.triangles[#m.triangles+1]=triX1Y0
                m.triangles[#m.triangles+1]=triX1Y1
    
                m.triangles[#m.triangles+1]=triX1Y1
                m.triangles[#m.triangles+1]=triX0Y1
                m.triangles[#m.triangles+1]=triX0Y0

                local unitX0=(pXi-1)/xSegs
                local unitY0=(pYi-1)/ySegs
                local unitX1=(pXi)/xSegs
                local unitY1=(pYi)/ySegs
                m.triangles_ex[#m.triangles_ex+1]={
                    u1=unitX0,v1=unitY0,
                    u2=unitX1,v2=unitY0,
                    u3=unitX1,v3=unitY1,
                }

                m.triangles_ex[#m.triangles_ex+1]={
                    u1=unitX1,v1=unitY1,
                    u2=unitX0,v2=unitY1,
                    u3=unitX0,v3=unitY0,
                }    
            end
        end
    end

    return m
end