local m={vertices={},triangles={}}

local poleH=1.5
local poleR=.05
local lampboxW=.3
local lampboxH=.5
local lampboxD=.1
local buttonboxW=.2
local buttonboxH=.2
local buttonboxD=.05
local buttonboxYU=.5

function getPrimCylinder(xo,yo,zo,segs,r,h)
    local p={v={},t={}}
    local pTop,pBot=1,2
    p.v[pTop]={0,-h/2,0}
    p.v[pBot]={0,h/2,0}
    local pRimTop=nil
    local pRimBot=nil
    local pRimTopFirst=nil
    local pRimBotFirst=nil
    local pRimTopLast=nil
    local pRimBotLast=nil
    for iSeg=0,segs+1 do
        if iSeg<segs+1 then
            local a=(iSeg/segs)*math.pi*2
            local x,z=math.sin(a)*r,math.cos(a)*r
            pRimTop=#p.v+1
            pRimBot=#p.v+2
            p.v[pRimTop]={x,-h/2,z}
            p.v[pRimBot]={x,h/2,z}
            if iSeg==0 then
                pRimTopFirst=pRimTop
                pRimBotFirst=pRimBot
            end
        end

        if iSeg>0 then
            if iSeg==segs+1 then
                pRimTop=pRimTopFirst
                pRimBot=pRimBotFirst
            end
            p.t[#p.t+1]={pTop,pRimTopPrev,pRimTop}
            p.t[#p.t+2]={pBot,pRimBotPrev,pRimBot}

            p.t[#p.t+1]={pTop,pRimTopLast,pRimTop}
            p.t[#p.t+2]={pBot,pRimBotPrev,pRimBot}
        end
        pRimTopPrev=pRimTop
        pRimBotPrev=pRimBot
   end

    return p
end

function getPrimBox(xo,yo,zo,xd,yd,zd)
--    5 ---- 6
-- 1 ---- 2  |
---|      |  |
-- |  7 ---- 8
-- 3 ---- 4
    local xdh,ydh,zdh=xd/2,yd/2,zd/2
    return {
        v={
            {xo-xdh,yo-ydh,zo+zdh},
            {xo+xdh,yo-ydh,zo+zdh},
            {xo-xdh,yo+ydh,zo+zdh},
            {xo+xdh,yo+ydh,zo+zdh},
            {xo-xdh,yo-ydh,zo-zdh},
            {xo+xdh,yo-ydh,zo-zdh},
            {xo-xdh,yo+ydh,zo-zdh},
            {xo+xdh,yo+ydh,zo-zdh},
        },
        t={
            {1,2,4},
            {4,3,1},
            {2,6,8},
            {8,4,2},
            {6,5,7},
            {7,8,6},
            {5,1,3},
            {3,7,5},
            {5,6,2},
            {2,1,5},
            {3,4,8},
            {8,7,3},
        },
    }
end

function addPrim(m,prim)
    local vOffset=#m.vertices/3
    trace(vOffset)
    for i=1,#prim.v do
        local v=prim.v[i]
        m.vertices[#m.vertices+1]=v[1]
        m.vertices[#m.vertices+1]=v[2]
        m.vertices[#m.vertices+1]=v[3]
    end

    for i=1,#prim.t do
        local t=prim.t[i]
        m.triangles[#m.triangles+1]=vOffset+t[1]
        m.triangles[#m.triangles+1]=vOffset+t[2]
        m.triangles[#m.triangles+1]=vOffset+t[3]
    end
end

-- pole
-- #TODO: Fix this if there's time
--mPole=getPrimCylinder(0,0,0,3,1,1)
mPole=getPrimBox(0,poleH/2,0,.1,poleH,poleR)
addPrim(m,mPole)

-- lamp box
mLampbox=getPrimBox(0,poleH+lampboxH/2,0,lampboxW,lampboxH,lampboxD)
addPrim(m,mLampbox)

-- button box
mButtonBox=getPrimBox(0,poleH*buttonboxYU,-(poleR/2+buttonboxD/2),buttonboxW,buttonboxH,buttonboxD)
addPrim(m,mButtonBox)

m.scale=2

return m
