-- Just sketching stuff out
-- Liable to end up quite different!

package.path=package.path..";C:\\Users\\micro\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jtruk
package.path=package.path..";C:\\Users\\Ronan\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- Mantratronic
package.path=package.path..";C:\\Users\\matt\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jynx

local R={}
require("./sys/sys")(R)
require("./3d/geom")(R)
require("./3d/model")(R)
require("./3d/actor")(R)
require("./3d/scene")(R)
--MODELDATA=require("./data/model/streetlight")
--MODELDATA=require("./data/model/cube")
--MODELDATA=require("./data/model/cone")(3)
MODELDATA=require("./data/model/chicken")
MODELDATA.scale=2
require("./debug/menu")(R)

MODEL=nil
SCENE=nil
ACTOR=nil
MENU=nil

function BOOT()
	MODEL=R.Model:new()
	MODEL:load(MODELDATA)

	ACTOR=R.Actor:new(MODEL)
	ACTOR:setDrawFn(R.poly.DrawLit,R.Model.Z_SORT|R.Model.CALC_NORMAL)

	SCENE=R.Scene:new()
	SCENE:registerActor(ACTOR)
	
	MENU=R.Menu:new(nil)
	MENU:addItem('camera-movement',"Camera Movement",R.MenuItemSelect:new()
		:add('fixed','Fixed')
		:add('actor','Actor')
		:add('pos-and-aim','CamPos and CamAim')
		:add('pos','Cam Pos')
		:add('aim','CamAim')
		:add('actor-rot-move', 'Actor Rot & Xlate')
	)
end

function TIC()
	R.tryBreak()
	
	cls(0)

	local actorX,actorY,actorZ=0,-1,4
	local actorRotY=0

	local t=time()*.001
	local moveAmount=math.sin(t)*3
	local movement=MENU:getValue('camera-movement')
	local posX,posY,posZ=0,0,0
	local aimX,aimY,aimZ=0,0,2
	if movement=='fixed' then
	elseif movement=='actor' then
		actorX=moveAmount
	elseif movement=='pos' then
		posX=moveAmount
		posZ=0
		aimZ=actorZ
	elseif movement=='aim' then
		aimX=moveAmount
		aimZ=actorZ
	elseif movement=='pos-and-aim' then
		posX=moveAmount
		aimX=moveAmount
	elseif movement=='actor-rot-move' then
		actorRotY=moveAmount*2
		actorX=moveAmount
	end

	local mat=R.M44:new(R.M44.ID)
	mat:mulM44(R.M44:newTrans(actorX,actorY,actorZ))
	mat:mulM44(R.M44:newRotY(actorRotY))
	ACTOR:setMat(mat)

	SCENE:getCam():setPos(R.V4:new({posX,posY,posZ,1}))
	SCENE:getCam():setAim(R.V4:new({aimX,aimY,aimZ,1}))

	print(string.format("  Pos: %.2f %.2f %.2f", posX,posY,posZ),0,100,12)
	print(string.format("  Aim: %.2f %.2f %.2f", aimX,aimY,aimZ),0,110,12)
	print(string.format("Actor: %.2f %.2f %.2f", actorX,actorY,actorZ),0,120,12)

	SCENE:draw()

    MENU:update()
    MENU:draw(10,10,12)
end

-- <PALETTE>
-- 000:000000111111222222333333444444555555666666777777888888999999aaaaaabbbbbbccccccddddddeeeeeeffffff
-- </PALETTE>