-- If require fails, try adding the
-- path to your TIC code directory
package.path=package.path..";C:\\Users\\micro\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jtruk
package.path=package.path..";C:\\Users\\Ronan\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- Mantratronic
package.path=package.path..";C:\\Users\\matt\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jynx

local R={}
require("./sys/sys")(R)
require("./3d/geom")(R)
require("./3d/model")(R)

-- Palette
for i=0,47 do
	poke(0x3fc0+i,i*5)
end

local T=0
function TIC()
	R.tryBreak()

	vbank(1)
	for y=0,64 do
		for x=0,64 do
			pix(x,y,(x+y)>>3)
		end
	end

	vbank(0)
	cls()
	local m=R.Model:new()
	local matView=R.M44:new(R.M44.ID)
	local matProj=R.M44:new(R.M44.ID)

	local vertices={
		{-1,-1,-1,1},
		{-1,-1,1,1},
		{-1,1,-1,1},
		{-1,1,1,1},
		{1,-1,-1,1},
		{1,-1,1,1},
		{1,1,-1,1},
		{1,1,1,1},
	}
	for i=1,#vertices do
		local v=R.V4:new(vertices[i])
		local p=m:addVtx(v)
	end
	m:addTri(R.Tri:new(1,2,3,{c=4}))
	m:addTri(R.Tri:new(2,4,3,{c=15}))
	m:addTri(R.Tri:new(1,5,2,{c=15}))
	m:addTri(R.Tri:new(2,5,6,{c=7}))
	m:addTri(R.Tri:new(2,8,4,{c=8}))
	m:addTri(R.Tri:new(2,6,8,{c=4}))

	-- We've got a normal to send in...
	-- (maybe this should also accept a
	--  face intensity 0-1 and scale the
	--  output colour by that?)
	m:addTri(R.Tri:new(5,6,7,{},R.V4:new({0,0,-1,1})))

-- Render example: Flat colour
-- Spin the model round
	local mat=R.M44:newTrans(0,0,1)
	local matX=R.M44:newRotX(T*.03)
	local matY=R.M44:newRotY(T*.021)
	local matZ=R.M44:newRotZ(T*.012)
	mat:mulM44(matX)
	mat:mulM44(matY)
	mat:mulM44(matZ)
	m:setDrawFn(R.poly.DrawFlat,R.Model.Z_SORT)
	m:draw(mat,matView,matProj)

	m:setDrawFn(R.poly.DrawLit,R.Model.Z_SORT|R.Model.CALC_NORMAL)
	local mat=R.M44:newTrans(4,4,10)		
	local matX=R.M44:newRotX(T*.03)
	local matY=R.M44:newRotY(T*.011)
	mat:mulM44(matX)
	mat:mulM44(matY)
	m:draw(mat,matView,matProj)

-- Example: Textured Triangles
-- For test, add a single
-- tri with texture uvs and we'll pick
-- that one up in the render function...
	m:addTri()
	m:addTri(R.Tri:new(5,6,7,{u1=0,v1=0,u2=64,v2=0,u3=0,v2=64}))
	m:setDrawFn(R.poly.DrawTex,0)

	local mat=R.M44:newTrans(-4,4,1)		
	local matX=R.M44:newRotY(T*.03)
	mat:mulM44(matX)
	m:draw(mat,matView,matProj)

	T=T+1
	vbank(1)
	cls()
end

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

