package.path=package.path..";C:\\Users\\micro\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jtruk
package.path=package.path..";C:\\Users\\Ronan\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- Mantratronic
package.path=package.path..";C:\\Users\\matt\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jynx

local R={}
require("./sys/sys")(R)
require("./3d/geom")(R)

local PS={
	{-1,-1, 1,1},
	{ 1,-1, 1,1},
	{-1, 1, 1,1},
	{ 1, 1, 1,1},
	{-1,-1,-1,1},
	{ 1,-1,-1,1},
	{-1, 1,-1,1},
	{ 1, 1,-1,1},
	{ 0, 0, 0,1},
}

local EDGES={
	{1, 2},
	{1, 3},
	{1, 5},
	{2, 4},
	{2, 6},
	{3, 4},
	{3, 7},
	{4, 8},
	{5, 6},
	{5, 7},
	{6, 8},
	{7, 8}
}

local AXES={
	{0,0,0,1},
	{1,0,0,1},
	{0,1,0,1},
	{0,0,1,1},
}

local camPos=R.V4:new({1.5,2,4,1})
local camTarget=R.V4:new({0,0,3,1})
local camUp=R.V4:new({0,1,0,1})
local COS,SIN=math.cos,math.sin

function TIC()
	cls()
	R.tryBreak()

	local t = time()*.001;

	camPos.e[1] = 8*COS(t)
	camPos.e[2] = COS(t*3)
	camPos.e[3] = 8*SIN(t)

	local ps={}
	for i=1,#PS do
		local p=R.V4:new(PS[i])
		ps[i]=p
	end

	local scale=1
	local matModel=R.M44:new(R.M44.ID)

	-- translation can be done through direct manipulation too
	-- might want a method for this as it'd be faster than a 4x4 multiplication
	-- matModel.e[3][4]=5

	matModel:mulM44(R.M44:newTrans(0,0,4))
	matModel:mulM44(R.M44:newScale(scale,scale,scale))

	--matModel:mulM44(R.M44:newRotX(0.5))
	--matModel:mulM44(R.M44:newRotY(time()*.002))
	--matModel:mulM44(R.M44:newRotZ(time()*.002))

	local matView=R.NewM44LookAt(camPos,camTarget,camUp)

	local viewAngle=90
	local near=0.01
	local far=100

--	local matProj=R.M44:new(R.geom.M44.ID)
--	local matProj=R.M44NewOrthProj(1,1,near,far)
	local matProj=R.NewM44PersProj(viewAngle,near,far)

	local matGlobal=matProj:mulM44C(matView)
	local matAll=matGlobal:mulM44C(matModel)

	-- matModel:trace("model")
	-- matProj:trace("proj")

	print(time(),0,120,12)

	local pt={}

	-- transform all points and store in pt so we can render the edge list
	for i=1,#ps do
		local p=ps[i]:mulM44C(matAll,true)
		pt[i]={p.e[1],p.e[2]}

		-- swap this for a simple dot product to not draw stuff behind the cam
		--if true or p.e[3]>0 then
			local sx,sy=toScreen(p.e)
			pix(sx,sy,i)
			--print(i,sx,sy,i)
		--end
	end

	for e=1,#EDGES do
		local sx,sy=toScreen(pt[EDGES[e][1]])
		local sx2,sy2=toScreen(pt[EDGES[e][2]])
		line(sx,sy,sx2,sy2,5)
	end

	-- render our world axes on top for now
	local at={}

	for i=1,#AXES do
		local p=R.V4:new(AXES[i])
		p=p:mulM44C(matGlobal,true)
		at[i]={p.e[1],p.e[2]}
	end
	
	local ox,oy=toScreen(at[1])
	local asx,asy=toScreen(at[2])
	line(ox,oy,asx,asy,9)
	print("X",asx,asy,12)

	asx,asy=toScreen(at[3])
	line(ox,oy,asx,asy,6)
	print("Y",asx,asy,12)

	asx,asy=toScreen(at[4])
	line(ox,oy,asx,asy,2)
	print("Z",asx,asy,12)
end

function toScreen(p)
	return 120+p[1],68+p[2]
end

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

