-- Just sketching stuff out
-- Liable to end up quite different!

package.path=package.path..";C:\\Users\\micro\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jtruk
package.path=package.path..";C:\\Users\\Ronan\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- Mantratronic
package.path=package.path..";C:\\Users\\matt\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jynx

local R={}
require("./sys/sys")(R)
require("./3d/geom")(R)
require("./3d/model")(R)
require("./3d/scene")(R)
require("./debug/menu")(R)

local MODELDATA=require("./data/model/chicken")

local MODEL=nil
local SCENE=nil
local ACTOR=nil
local MENU=nil

function geomPrePass(i,v)
	local a=math.atan2(v.e[1],v.e[3])
	local twist=a+math.cos(time()*0.001+v.e[2]*15)*1.5
	local d=(v.e[1]^2+v.e[3]^2)^.5
	v.e[1]=d*math.sin(twist)
	v.e[3]=-d*math.cos(twist)
	return v
end

function geomPostPass(i,v)
	if v.e[1]<0 then
		v.e[1]=-(v.e[1]/5)^4
	end
	return v
end

function BOOT()
	MODEL=R.Model:new()
	MODEL:load(MODELDATA)
	MODEL:setDrawFn(R.poly.DrawDebug,R.Model.Z_SORT)

	SCENE=R.Scene:new()

	local scale=1
	local matModel=R.M44:new(R.M44.ID)
	matModel:mulM44(R.M44:newTrans(0,.1,.25))
	matModel:mulM44(R.M44:newScale(scale,-scale,scale))

	ACTOR=R.Actor:new(MODEL,matModel)

    SCENE:addActor(ACTOR)
	
	MENU=R.Menu:new(function(key,value)
		if key=='deform' then
			local setPrePass=nil
			local setPostPass=nil
			if value=='pre' then
				setPrePass=geomPrePass
			elseif value=='post' then
				setPostPass=geomPostPass
			end
			ACTOR:setGeomPrePassFn(setPrePass)
			ACTOR:setGeomPostPassFn(setPostPass)
		end
	end)		

	MENU:addItem('deform',"Deformation",R.MenuItemSelect:new()
		:add('none','(none)')
		:add('pre','Pre')
		:add('post','Post')
	)
end

function TIC()
	R.tryBreak()
	
	cls(0)

	MENU:update()
    MENU:draw(10,10,12)

	local x=0
	ACTOR.mat:mulM44(R.M44:newRotY(.01))
	if MENU:getValue('deform')=='post' then
		ACTOR.mat:mulM44(R.M44:newRotY(.01))
		x=math.sin(time()*0.001)*.08
	end
	ACTOR.mat.e[1][4]=x

	SCENE:draw()
end

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

