--[[
A visual test for the camera object
Cursor keys move up/down/left/right, A and Z move in/out
Spacebar switches between moving camera pos and camera aim
The projection is basic, and there's no z-sorting
]]--
package.path=package.path..";C:\\Users\\micro\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jtruk
package.path=package.path..";C:\\Users\\Ronan\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- Mantratronic

local R={}
require("./sys/sys")(R)
require("./3d/geom")(R)
require("./3d/cam")(R)

local MOVE_MODE=0 -- toggle between POS (0) and AIM (1)

-- Camera POS and AIM
local POS=R.V4:new({0,0,0,1})
local AIM=R.V4:new({0,0,1,1})

T=0
function TIC()
	R.tryBreak()
	cls()

	local points={
		{-1,-1,-1},
		{-1,-1,1},
		{-1,1,-1},
		{-1,1,1},
		{1,-1,-1},
		{1,-1,1},
		{1,1,-1},
		{1,1,1},
		{0,0,0},	-- Hijacked for AIM marker
	}
	
	local up=R.V4:new({0,-1,0,0})
	local cam=R.Cam:new(POS,AIM,up)
	local mat=cam:getM44()

	-- Set magic point 9 to be the camera aim pos
	points[9]={AIM.e[1],AIM.e[2],AIM.e[3]}

	for i=1,#points do
		local p=points[i]
		local transP=R.V4:new({p[1],p[2],p[3],1}):mulM44C(mat,true)
		
		projP=proj(transP)
 		if projP.z>0 then
			local c=(i==9) and 12 or i+1
			circ(projP.x,projP.y,projP.z*2,c)
		end
	end

	line(120,63,120,73,13)
	line(115,68,125,68,13)

	print(string.format("Moving: %s", getMoveType(MOVE_MODE)),0,0,12)
	print(string.format("CamPos: %.2f %.2f %.2f", POS.e[1], POS.e[2], POS.e[3]),0,10,12)
	print(string.format("CamAim: %.2f %.2f %.2f", AIM.e[1], AIM.e[2], AIM.e[3]),0,20,12)
	
	toMove=POS
	if MOVE_MODE==1 then
		toMove=AIM
	end

	if btn(0) then toMove.e[2]=toMove.e[2]-.1 end
	if btn(1) then toMove.e[2]=toMove.e[2]+.1 end
	if btn(2) then toMove.e[1]=toMove.e[1]-.1 end
	if btn(3) then toMove.e[1]=toMove.e[1]+.1 end
	if key(26) then toMove.e[3]=toMove.e[3]-.1 end
	if key(1) then toMove.e[3]=toMove.e[3]+.1 end

	if keyp(48) then MOVE_MODE=1-MOVE_MODE end

	T=T+1
end

function getMoveType(type)
	return (type == 0) and "CamPos" or "CamAim"
end

function proj(v)
	local zEye=10
	local zf=(zEye-v.e[3])/200
	return {
		x=120+v.e[1]/zf,
		y=68+v.e[2]/zf,
		z=(.1/zf),
	}
end

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

