return function(R)
	require("./3d/geom")(R)
    
    R.Proj={
		ORTHOGRAPHIC='o',
		PERSPECTIVE='p',
	}

	function R.Proj:new(type)
		local o={
			type=type,
		}
		setmetatable(o,self)
		self.__index=self
		return o
	end
    
    -- type is ORTHOGRAPHIC or PERSPECTIVE
    function R.Proj:setType(type)
        self.type=type
    end

    function R.Proj:getM44()
		local viewAngle=75
		local near=0.01
		local far=100

        if self.type==R.Proj.ORTHOGRAPHIC then
            -- width,height,near,far
            return R.NewM44OrthProj(1,1,near,far)
        else
            -- viewAngle,near,far
            return R.NewM44PersProj(viewAngle,near,far)
        end
    end
end

