R=R or {}
require("./3d/model")(R)
require("./3d/scene")(R)

local GLOBAL=require("./global")

local SCENE=nil
local MODEL_GMAN=nil
local ACTOR_GMAN=nil
local MAT_GMAN=nil

local m=math
local s=m.sin
local c=m.cos
local r=m.random
local tau=m.pi*2
local t=0

-- three flow field angles
-- small leaves/squares moving through fields, 2 background behind greenman, 1 in front
-- added move from left to right for main wind direction
local PAL=nil

-- 2d array of angles
local field1 = {} -- foreground
local field2 = {} 
local field3 = {} -- background

-- array of 2d points
local leaves1 = {}
local leaves2 = {}
local leaves3 = {}

function setupWindEffect()
    for i=1,10 do
        leaves1[i]={x=r(240)-1,y=r(136)-1}
    end
    for i=1,20 do
        leaves2[i]={x=r(240)-1,y=r(136)-1}
    end
    for i=1,40 do
        leaves3[i]={x=r(240)-1,y=r(136)-1}
    end

    field1 = makeFlowField(0.05,0.03,10,.8)
    field1.scale = 10
    field1.speed = 2.15
    field2 = makeFlowField(0.1,0.05,5,0.9)
    field2.scale = 5
    field2.speed = 1.75
    field3 = makeFlowField(0.2,0.1,3,1.0)
    field3.scale = 3
    field3.speed = 1.25
end

function makeFlowField(xZoom,yZoom,scale,curve)
  local ff={}
  for x=0,240/scale+1 do
    ff[x]={}
    for y=0,136/scale+1 do
     ff[x][y]=(s(x*xZoom)+c(y*yZoom))*curve
    end
   end
  return ff
end

function windFlow(field, leaves, scale)
    for i=1,#leaves do
      local fx=leaves[i].x//field.scale
      local fy=leaves[i].y//field.scale
    
      if fx < 0 or fx > #field-2 or fy < 0 or fy > #field[fx] then
        local r = r(376)
        local x = 0
        local y = 0
        if r < 136 then
          y = r
        else
          x = r-136
        end
        fx=x//field.scale
        fy=y//field.scale
        leaves[i].x = x
        leaves[i].y = y
      end
      local fa = field[fx][fy]
    
      leaves[i].x = leaves[i].x+field.speed*s(fa+t/10)+2*field.speed
      leaves[i].y = leaves[i].y+field.speed*c(fa)+field.speed
    
      --pix(leaves[i].x,leaves[i].y,2+scale)
      --rect(leaves[i].x,leaves[i].y,scale,scale,2+scale)
      -- Forgive me, mantratronic, for hacking these to go R-to-L!
      local xleaf=240-(leaves[i].x-4*scale)
      --spr(0,xleaf,leaves[i].y-4*scale,0,scale)
      local h = 1+scale/2
      line(xleaf,leaves[i].y-4*scale,xleaf-h,leaves[i].y-4*scale-h,3+scale)
      line(xleaf,leaves[i].y-4*scale,xleaf-h,leaves[i].y-4*scale+h,3+scale)
      line(xleaf,leaves[i].y-4*scale,xleaf+h,leaves[i].y-4*scale-h,3+scale)
      line(xleaf,leaves[i].y-4*scale,xleaf+h,leaves[i].y-4*scale+h,3+scale)
    end
  end
  
  
  return {
    bdr=function(y,t,unitT)
        vbank(0)
        PAL:apply()
        --PAL:apply()
        --R.setRGB(1,GLOBAL.rgbGMan)
        vbank(1)
        PAL:apply()
        --R.setRGB(1,GLOBAL.rgbGMan)
    end,
    musicTic=function(isFirstRun,t,unitT)
        if isFirstRun then
            setupWindEffect()
            PAL=R.Palette:new()
            PAL:setRGB(1,GLOBAL.rgbGMan)
            PAL:setRGB(2,GLOBAL.rgbRMan)
            PAL:setRGB(3,R.RGB:new(1,1,0))
            PAL:setRGB(4,R.RGB:new(.75,.75,0))
            PAL:setRGB(5,R.RGB:new(.5,.5,0))
            PAL:setRGB(6,R.RGB:new(.25,.25,0))
            SCENE=R.Scene:new()

            MODEL_GMAN=R.Model:new()
            MODEL_GMAN:load(require("./data/model/green-man-walking"))

            ACTOR_GMAN=R.Actor:new(MODEL_GMAN)
            ACTOR_GMAN:setDrawFn(R.poly.Draw1Colour(1),0)

            SCENE:registerActor(ACTOR_GMAN)
        end

        vbank(0)
        cls(0)
    
        GLOBAL.walkAnimWrapper(ACTOR_GMAN,unitT)
        windFlow(field3, leaves3,1)
        windFlow(field2, leaves2,2)

        vbank(1)
        cls()
        SCENE:draw()

        -- Windy pixels
        -- Feel free to make better / replace!
        for y=0,136 do
            for x=220,80,-1 do
                local p=pix(x+1,y)
                if p > 0 then
                    if math.random()<.6 then
                        pix(x,y,1)
                    end
                end
            end
        end
        windFlow(field1, leaves1,3)
    end,
}
