R=R or {}
require("./3d/model")(R)
require("./3d/scene")(R)

local GLOBAL=require("./global")

local UNIT_T=0
local SCENE0=nil
local SCENE1=nil
local ACTOR_GMAN=nil
local ACTOR_WATER=nil
local PAL_BASE=nil
local PAL_MAIN=nil

function drawBubbles(unitT,scale)
    for i=0,10 do
        local s=5+3*math.sin(i)*scale
        local x=((4+i*scale*7)^9)%240+math.sin(i+unitT*30)*5
        local y=(((12+i)^3)-unitT*(140+(30*s)))%150-10

        circ(x,y,s,2)
        circb(x,y,s,3)
    end
end

function drawFerns(unitT)
    for i=0,40 do
        for y=0,1,.25 do
            local xBase=((6+i*5)^11)%400-unitT*(i+10)*6
            local yHeight=((3+i*16)^7.2)%67
            line(xBase+math.sin(y*30)*2,136,xBase+math.sin(y*40)*5,146-yHeight,4)
        end
    end
end


return {
    bdr=function(y,t,unitT)
        vbank(0)
        if unitT<.2 then
            PAL_BASE:applyBlend(PAL_MAIN,unitT/.2)
        elseif unitT>=.8 then
           PAL_BASE:applyBlend(PAL_MAIN,1-((unitT-.8)/.2))
        end
    end,
    musicTic=function(isFirstRun,t,unitT)
        local xDivs,yDivs=10,10
        if isFirstRun then
            PAL_BASE=R.Palette:new()
            PAL_BASE:setAllRGB(R.RGB:new(0,0,0))
            PAL_BASE:setRGB(1,GLOBAL.rgbGMan)

            PAL_MAIN=R.Palette:new()
            PAL_MAIN:setRGB(0,R.RGB:new(.2,.5,.8))
            PAL_MAIN:setRGB(1,R.RGB:new(.5,.7,1))
            PAL_MAIN:setRGB(2,R.RGB:new(.3,.6,.9))
            PAL_MAIN:setRGB(3,R.RGB:new(.25,.55,.85))
            PAL_MAIN:setRGB(4,R.RGB:new(.25,.65,.70))
            
            vbank(1)
            cls(0)

            SCENE0=R.Scene:new()
            SCENE1=R.Scene:new()

            local model=R.Model:new()
            model:load(require("./data/model/green-man-walking"))

            ACTOR_GMAN=R.Actor:new(model)
            ACTOR_GMAN:setDrawFn(R.poly.Draw1Colour(1),0)
            local mat=ACTOR_GMAN:getMat()
            mat:mulM44(R.M44:newTrans(0,0,1.5))
            SCENE1:registerActor(ACTOR_GMAN)

            local modelData=require("./data/model/rectangle-tex-subdiv")(240,136,xDivs,yDivs)
            modelData.divide_by=136
            local model=R.Model:new()
            model:load(modelData)
            ACTOR_WATER=R.Actor:new(model)
            ACTOR_WATER:setDrawFn(R.poly.DrawTex(0,0,240,136),0)
            local mat=ACTOR_WATER:getMat()
            mat:mulM44(R.M44:newTrans(0,0,1))
            ACTOR_WATER:setGeomPrePassFn(function(i,v)
                local deform=math.sin(UNIT_T*math.pi)
                local a=i*.1+UNIT_T*10
                local d=.03*deform
                v.e[1]=v.e[1]+math.sin(2*a)*d
                v.e[2]=v.e[2]+math.cos(a+math.pi)*d
                return v
            end)
                
            SCENE0:registerActor(ACTOR_WATER)
        end

        UNIT_T=unitT
        GLOBAL.walkAnimWrapper(ACTOR_GMAN,unitT)

        vbank(1)
        cls(0)
        drawBubbles(unitT,1)

        SCENE1:draw()
        drawFerns(unitT)
        drawBubbles(unitT,2)

        vbank(0)
        cls(0)        
        SCENE0:draw()

        vbank(1)
        cls(0)        
    end,
}
