R=R or {}
require("./3d/model")(R)
require("./3d/scene")(R)

local GLOBAL=require("./global")

local GREET_TEXTS={
    "Greetz to:",
    ". . .",
    "Abyss",
    "Attention Whore",
    "Avena",
    "Bitbendaz",
    "Bitshifters",
    "Cold Climate",
    "Darklite",
    "Defekt",
    "Desire",
    "Exceed",
    "Field-FX",
    "Hex Heroes",
    "Hooy-Program",
    "Lego",
    "Logicoma",
    "LoveByte",
    "Marquee Design",
    "Moods Plateau",
    "Oxygene",
    "Poo-Brain",
    "Quadtrip",
    "SMFX",
    "Singular Crew",
    "Slipstream",
    "TEK",
    "TIC-80 Sceners",
    "TPOLM",
    "TUHB",
    "Torment",
    ". . .",
    "and YOU!",
}

local SCENE=nil
local MODEL_GMAN=nil
local ACTOR_GMANS={}
local MAT_GMAN=nil
local FONT=nil
local GREETS={} -- actor, text
local ROT_GREETZ=0
local ADD_NEXT_GREET=0
local N_GREETS=0

function getNextGreetFreeN()
    for i=1,#GREETS do
        local greet=GREETS[i]    
        if not greet.alive then
            return i
        end
    end
    return #GREETS+1
end

function addGreet(text,tStart,iCol)
    local iGreet=getNextGreetFreeN()

    local greetH=20
    local greetW=FONT:width(text,1,1)
    local modelData=require("./data/model/rectangle-tex-subdiv")(greetW/greetH,1,5,3)
    modelData.divide_by=1

    local model=R.Model:new()
    model:load(modelData)
    
    local actor=R.Actor:new(model)

    local v0=greetH*(iGreet-1)
    actor:setDrawFn(R.poly.DrawTex(0,v0,greetW,greetH),0)
    actor:setGeomPrePassFn(function(i,v,m)
        local unitX=v.e[1]/m.vtxs[#m.vtxs].e[1]
        v.e[2]=v.e[2]*math.sin(math.sin(math.pi*2+unitX+ROT_GREETZ*100))
        return v
    end)

    GREETS[iGreet]={alive=true,actor=actor,text=text,tStart=tStart,iCol=iCol}
    SCENE:registerActor(GREETS[iGreet].actor)
end

function removeGreet(i)
    GREETS[i].alive=false
    SCENE:unregisterActor(GREETS[i].actor)
    GREETS[i].actor.alive=false
end

function drawGreetsTextures()
    for i=1,#GREETS do
        local greet=GREETS[i]
        if greet.alive then
            local y=(i-1)*20
            local iCol1=3+(greet.iCol%12)
            local iCol2=3+((6+greet.iCol)%12)
            FONT:print(greet.text,1,y+1,1,1,iCol2)
            FONT:print(greet.text,0,y,1,1,iCol1)
        end
    end
end

function moveGreetsActors(unitT)
    for i=1,#GREETS do
        local greet=GREETS[i]
        if greet.alive then
            local inT=unitT-greet.tStart
            local x=8-inT*150 -- mt increased speed to 150, was 100
--            local mat=R.M44:newTrans(x,math.sin(unitT*22+greet.iCol*3)*.6,4)
--            mat:mulM44(R.M44:newRotZ(math.sin(unitT*15)*.4))
            local mat=R.M44:newTrans(x,0,4)
            mat:mulM44(R.M44:newRotX(.2))
            mat:mulM44(R.M44:newRotZ(math.pi/6))
            greet.actor:setMat(mat)
            if inT>.1 then -- mt, reduced to .1, was .15
                removeGreet(i)
            end
        else
            -- Not ideal hack-> just move off screen!
            local mat=R.M44:newTrans(-100,0,4)
            greet.actor:setMat(mat)
            removeGreet(i) -- added by mt, seems to work
        end
    end
end

return {
    musicPatterns=4,
    bdr=function(y,t,unitT)
        vbank(0)
        R.setRGB(0,R.RGB:new(0,0,0))

        local r=.5+math.sin(unitT*150+y*0.02)*.5
        local g=.5-math.sin(unitT*100+y*0.027)*.5
        local b=.5-math.sin(unitT*120+y*0.023)*.5
        local lineRgb=R.RGB:new(r,g,b)
        local lineBlended=GLOBAL.rgbGMan:getBlendTo(lineRgb,.5+math.sin(unitT*math.pi)*.5)
        R.setRGB(1,lineBlended)

        for i=2,15 do
            local s=(i-2)/13
            local o=unitT*40+y*.03
            local r1=.5+math.sin(s*math.pi*2+o)*.5
            local g1=.5+math.sin(s*math.pi*2+math.pi*2/3+o)*.5
            local b1=.5+math.sin(s*math.pi*2+math.pi*4/3+o)*.5
            R.setRGB(i,R.RGB:new(r1,g1,b1))
        end
    end,
    musicTic=function(isFirstRun,t,unitT,patternsDone,tWalk)
        if isFirstRun then
            FONT=R.Font:new()
            FONT:load(require("./data/font/nucampi-8x16/nucampi-8x16"))

            vbank(1)
            cls(0)

            SCENE=R.Scene:new()

            local model=R.Model:new()
            model:load(require("./data/model/greenman"))
            for i=1,9 do -- mt reduced to 9, was 14
                ACTOR_GMANS[i]=R.Actor:new(model)
                ACTOR_GMANS[i]:setDrawFn(R.poly.Draw1Colour(i+1),0)            
                SCENE:registerActor(ACTOR_GMANS[i])
            end
            local model=R.Model:new()
            model:load(require("./data/model/green-man-walking"))

            ACTOR_GMAN=R.Actor:new(model)
            ACTOR_GMAN:setDrawFn(R.poly.Draw1Colour(1),0)                
            SCENE:registerActor(ACTOR_GMAN)
        end

        local nextTime=(N_GREETS/(#GREET_TEXTS-1))*.85
        if unitT>=nextTime and N_GREETS<#GREET_TEXTS then
            addGreet(GREET_TEXTS[N_GREETS+1],unitT,N_GREETS*4)
            N_GREETS=N_GREETS+1
        end

        ROT_GREETZ=unitT -- needed for geom pre process
        moveGreetsActors(unitT)

        vbank(1)
        cls()
        drawGreetsTextures()

        GLOBAL.walkAnimWrapper(ACTOR_GMAN,tWalk)
        for i=1,#ACTOR_GMANS do
            local a=(i/#ACTOR_GMANS)*math.pi*2
            local d=math.sin(unitT*math.pi*2)
            local x=math.sin(a)*d*1.2
            local y=-math.cos(a)*d*.6
            local mat=R.M44:newTrans(x,y,2+math.sin(i*d*math.pi*2*.1)*.5)
            local ang=R.lerp(unitT,0,a)
            mat.mulM44(mat,R.M44:newRotZ(-ang*8))
            ACTOR_GMANS[i]:setMat(mat)
        end

        vbank(0)
        cls()
        SCENE:draw()

        vbank(1)
        cls()
    end,
}
