R=R or {}
require("./sys/palette")(R)
require("./3d/model")(R)
require("./3d/scene")(R)

local GLOBAL=require("./global")

local SCENE=nil
local MODEL_GMAN=nil
local ACTOR_GMAN=nil
local MAT_GMAN=nil
local PAL0=nil

function drawTobachGrass(t,xOfs,y,gh,c1,c2)
    local hMultiply=10
    local yl2=y
    for i=0,240 do
        local x=(i+xOfs)%240
        local h=math.sin(i)*hMultiply
        local yl1=(y-gh)+h
        line(x,yl1,x,yl2,c1)
    end
    for i=0,240 do
        local x=(i+xOfs)%240
        local h=math.sin(i)*hMultiply
        local yl1=(y-gh+10)+h
        line(x-3+math.sin(t/500+i*5)*2,yl1,x,yl2,c2)
    end
end

function drawFlowers(xOfs,y,step,t)
    local i=0
    for i=0,(8*step)-1 do
        local x=(i*32/step+xOfs)%512-256
        local xHead=x+math.sin(i+t*.005)*10
        local y=80+math.sin(i)*10/step
        local size=(8+math.sin(i*2.5)*4)*step
        local col=6+i%3
        line(xHead-1,y,x-1,136,4)
        line(xHead,y,x,136,4)
        for i=0,5 do
            local a=i/6*2*math.pi
            local x1=xHead+math.sin(a)*size
            local y1=y+math.cos(a)*size
            circ(x1,y1,size/2,3)
        end
        circ(xHead,y,size,col)
    end
end

return {
    musicPatterns=2,
    bdr=function(y,t,unitT)
        vbank(0)
        local pal=R.Palette:new()
        local blendSunset=R.clamp(unitT*2-.5,0,1)
        local rgbMan=GLOBAL.rgbGMan:getBlendTo(R.RGB:new(0,.1,0),blendSunset)
        pal:setRGB(1,rgbMan)
        local unitY=(y/136)
        local r=.2+.8*(unitT*(.6+unitY*.4))
        local g=.2+.8*(y/136)
        local b=1-unitT*.5
        local rgbSky=R.RGB:new(r,g,b)
        pal:setRGB(2,rgbSky)
        pal:setRGB(3,R.RGB:new(1,1,1):getBlendTo(R.RGB:new(.3,.3,.3),blendSunset))
        pal:setRGB(4,R.RGB:new(0,.7,.1):getBlendTo(R.RGB:new(0,.2,0),blendSunset))
        pal:setRGB(5,R.RGB:new(0,.5,.1):getBlendTo(R.RGB:new(0,.1,0),blendSunset))
        pal:setRGB(6,R.RGB:new(.8,.3,1):getBlendTo(R.RGB:new(.2,.1,0),blendSunset))
        pal:setRGB(7,R.RGB:new(1,1,.4):getBlendTo(R.RGB:new(.2,.2,.1),blendSunset))
        pal:setRGB(8,R.RGB:new(.9,.5,.2):getBlendTo(R.RGB:new(.2,.1,0),blendSunset))
        local rgbSun=R.RGB:new(1,.9,.7)
        pal:setRGB(9,rgbSky:getBlendTo(rgbSun,.9-unitT))

        local fade=1
        if unitT<.2 then
            fade=unitT/.2
        elseif unitT>=.9 then
            fade=1-(unitT-.9)/.1
        end
        PAL0:applyBlend(pal,fade)
    end,
    musicTic=function(isFirstRun,t,unitT)
        if isFirstRun then
            vbank(1)
            cls(0)

            PAL0=R.Palette:new()
            PAL0:setAllRGB(R.RGB:new(0,0,0))

            SCENE=R.Scene:new()

            MODEL_GMAN=R.Model:new()
            MODEL_GMAN:load(require("./data/model/green-man-walking"))

            ACTOR_GMAN=R.Actor:new(MODEL_GMAN)
            ACTOR_GMAN:setDrawFn(R.poly.Draw1Colour(1),0)
            
            SCENE:registerActor(ACTOR_GMAN)
        end

        vbank(0)
        cls(2)
        local sunA=unitT-math.pi*.35
        local sunCX=-115
        local sunCY=160
        local sunD=250
        local sunX=sunCX+math.cos(sunA)*sunD
        local sunY=sunCY+math.sin(sunA)*sunD
        circ(sunX,sunY,40,9)
        
        local grassH=1
        local grassMaxH=25
        local grassWave=t
        local grassX=-unitT*400
        if unitT<.2 then
            grassH=unitT/.2
        end

        MAT_GMAN=ACTOR_GMAN:getMat()
--        MAT_GMAN:mulM44(R.M44:newTrans(0,0,1.5))
        GLOBAL.walkAnimWrapper(ACTOR_GMAN,unitT*2)

        rect(0,100,240,36,4)
        drawTobachGrass(grassWave*.6,grassX*.8,100,.2*grassMaxH*grassH^1.2,4,5)
        drawFlowers(grassX*1.2,90,.25,grassWave)
        drawTobachGrass(grassWave*.7,grassX,110,.4*grassMaxH*grassH,4,5)
        drawTobachGrass(grassWave*.8,grassX*1.3,118,.6*grassMaxH*grassH^.9,4,5)
        SCENE:draw()
        drawFlowers(grassX*1.4,100,.5,grassWave)
        drawTobachGrass(grassWave*.9,grassX*1.6,125,.8*grassMaxH*grassH^.8,4,5)
        drawTobachGrass(grassWave,grassX*2,135,grassMaxH*grassH^.7,4,5)
        drawFlowers(grassX*1.6,120,1,grassWave)
    end,
}
