R=R or {}
require("./sys/sys")(R)
require("./sys/palette")(R)
require("./3d/geom")(R)
require("./3d/model")(R)
require("./3d/actor")(R)
require("./3d/scene")(R)
local GLOBAL=require("./global")

local riftlogo=require("./data/gfx/rift-logo")

local SCENE0=nil
local SCENE1=nil
local MODEL_ROADSIGN=nil
local ACTOR_LOGO=nil
local ACTOR_WALL=nil
local ACTOR_WALL2=nil
local ACTOR_WALL3=nil
local ACTOR_LAMP=nil
local ACTOR_LAMP2=nil
local ACTOR_ROADSIGN=nil
local ACTOR_SIGNAL=nil

local PAL0=nil
local PAL_LOGO=nil

return {
    musicPatterns=2,
    bdr=function(y,t,unitT)
        vbank(0)
        local pal=R.Palette:new()

        s=R.clamp(y<100 and 1-y/80 or 0,0,1)

        pal:setRGB(0,R.RGB:new(0,0,s))
        pal:setRGB(1,R.RGB:new(.2,.13,.5))
        pal:setRGB(2,GLOBAL.rgbSignal)

        PAL0:applyBlend(pal,math.min(1,unitT*3))

        vbank(1)
        PAL_LOGO:apply()
    end,
    musicTic=function(isFirstRun,t,unitT)
        if isFirstRun then
            PAL0=R.Palette:new()
            PAL0:setAllRGB(R.RGB:new(0,0,0))

            riftlogo.setup()
            PAL_LOGO=R.Palette:new()
            PAL_LOGO:readSys() -- steal the palette

            local w,h=riftlogo.getDims()
            local modelRect=require("./data/model/rectangle")(1,h/w)

            SCENE0=R.Scene:new()
            SCENE1=R.Scene:new()

            -- LOGO
            local model=R.Model:new()
            model:load(modelRect)
            
            ACTOR_LOGO=R.Actor:new(model)
            ACTOR_LOGO:setDrawFn(function(tr)
                ttri(
                    tr.v[1].x,tr.v[1].y,
                    tr.v[2].x,tr.v[2].y,
                    tr.v[3].x,tr.v[3].y,
                    tr.ex.u1*w,tr.ex.v1*h,
                    tr.ex.u2*w,tr.ex.v2*h,
                    tr.ex.u3*w,tr.ex.v3*h,
                    2,
                    15
--                    -tr.v[1].z,-tr.v[2].z,-tr.v[3].z
                )
            end,0)

            -- WALL
            local model=R.Model:new()
            model:load(modelRect)
--            MODEL_WALL.origin={0,2,0}

            ACTOR_WALL=R.Actor:new(model)
            ACTOR_WALL:setDrawFn(R.poly.Draw1Colour(1),R.Model.Z_SORT|R.Model.CALC_NORMAL)

            ACTOR_WALL2=R.Actor:new(model)
            ACTOR_WALL2:setDrawFn(R.poly.Draw1Colour(1),R.Model.Z_SORT|R.Model.CALC_NORMAL)

            ACTOR_WALL3=R.Actor:new(model)
            ACTOR_WALL3:setDrawFn(R.poly.Draw1Colour(1),R.Model.Z_SORT|R.Model.CALC_NORMAL)

            -- LAMP
            local model=R.Model:new()
            model:load(require("./data/model/streetlight"))
            ACTOR_LAMP=R.Actor:new(model)
            ACTOR_LAMP:setDrawFn(R.poly.Draw1Colour(1),R.Model.Z_SORT|R.Model.CALC_NORMAL)
            ACTOR_LAMP2=R.Actor:new(model)
            ACTOR_LAMP2:setDrawFn(R.poly.Draw1Colour(1),R.Model.Z_SORT|R.Model.CALC_NORMAL)

            -- ROADSIGN
            local model=R.Model:new()
            model:load(require("./data/model/roadsign"))
            ACTOR_ROADSIGN=R.Actor:new(model)
            ACTOR_ROADSIGN:setDrawFn(R.poly.Draw1Colour(1),R.Model.Z_SORT|R.Model.CALC_NORMAL)

            -- SIGNAL
            local model=R.Model:new()
            model:load(require("./data/model/crossing-signal"))
            ACTOR_SIGNAL=R.Actor:new(model)
            ACTOR_SIGNAL:setDrawFn(R.poly.Draw1Colour(2),R.Model.Z_SORT|R.Model.CALC_NORMAL)
            mat=R.M44:newTrans(1.5,.75,3)
            mat:mulM44(R.M44:newRotX(math.pi))
            mat:mulM44(R.M44:newRotY(math.pi))
            ACTOR_SIGNAL:setMat(mat)
            local mat=R.M44:newTrans(0,0,2.5)
            ACTOR_WALL:setMat(mat)
            ACTOR_LOGO:setMat(mat)    
            mat=R.M44:newTrans(1,0,3.5)
            mat:mulM44(R.M44:newRotY(math.pi/2))
            ACTOR_WALL2:setMat(mat)    
            mat=R.M44:newTrans(-1,0,3.5)
            mat:mulM44(R.M44:newRotY(-math.pi/2))
            ACTOR_WALL3:setMat(mat)    
            mat=R.M44:newTrans(-4,1,3)
            mat:mulM44(R.M44:newRotX(math.pi))
            ACTOR_LAMP:setMat(mat)
            mat=R.M44:newTrans(3,1,6)
            mat:mulM44(R.M44:newRotX(math.pi))
            ACTOR_LAMP2:setMat(mat)
            mat=R.M44:newTrans(-2,0,1)
            mat:mulM44(R.M44:newRotX(-math.pi))
            mat:mulM44(R.M44:newRotY(math.pi))
            ACTOR_ROADSIGN:setMat(mat)
            
            SCENE0:registerActor(ACTOR_WALL)
            SCENE0:registerActor(ACTOR_WALL2)
            SCENE0:registerActor(ACTOR_WALL3)
            SCENE0:registerActor(ACTOR_LAMP)
            SCENE0:registerActor(ACTOR_LAMP2)
--            SCENE0:registerActor(ACTOR_ROADSIGN)
            SCENE0:registerActor(ACTOR_SIGNAL)
            SCENE1:registerActor(ACTOR_LOGO)
        end

        vbank(1)
        cls()
        riftlogo.draw(0,0)

        vbank(0)
        cls()

        local camPosX=unitT+math.sin(math.sin(unitT)*math.pi*3)*1.5
        local camAimY=-math.sin(unitT*math.pi*.75)*1.4
        local camPosZ=-unitT
        local camPos=R.V4:new({camPosX*2,0,camPosZ,1})
        local camAim=R.V4:new({camPosX/2,camAimY,2,1})
        SCENE0:getCam():setPos(camPos)
        SCENE0:getCam():setAim(camAim)
        SCENE1:getCam():setPos(camPos)
        SCENE1:getCam():setAim(camAim)


        SCENE1:draw()
        memcpy(0x8000,0,120*136)
        cls()

        SCENE0:draw()

        vbank(1)
        cls()
        memcpy(0,0x8000,120*136)
    end,
    cleanup=function()
        trace('cleanup!')
        vbank(0)
        cls()
        vbank(1)
        cls()
    end
}
