R=R or {}
require("./font/sysfont")(R)
require("./font/font")(R)
require("./ui/qrint")(R)
require("./sys/palette")(R)
require("./sys/math")(R)
require("./demo/parts")(R)

local GLOBAL=require("./global")

local PART_ID,PART_TIME=0,0
local PARTS=nil
local PAL_WHITE=nil
local PAL_HAND_IN0=nil
local PAL_HAND_IN1=nil
local SCENE0=nil
local SCENE1=nil
local ACTOR_GMAN0=nil
local ACTOR_GMAN1A=nil
local ACTOR_GMAN1B=nil
local MUSIC_STARTED=false
local MAN0X=-1
local MAN0Z=0
local MAN0ROT=0


return {
    duration=20000,
    bdr=function(y,t,unitT)
        vbank(0)
        if PART_ID=="hand-in" then
            if PART_TIME<.5 then
                PAL_WHITE:apply()
            else
                local inT=(PART_TIME-.5)/.5
                PAL_WHITE:applyBlend(PAL_HAND_IN0,inT)
            end
        elseif PART_ID=="first-move" then
            PAL_HAND_IN0:applyBlend(PAL_FIRST_MOVE0,R.clamp((PART_TIME-.25)*2,0,1))
        elseif PART_ID=="two-move" then
            PAL_FIRST_MOVE0:applyBlend(PAL_BLACK,R.clamp((PART_TIME-.3)*2,0,1))
        end

        vbank(1)
        if PART_ID=="hand-in" then
            PAL_WHITE:applyBlend(PAL_HAND_IN1,PART_TIME)
        elseif PART_ID=="two-move" then
            PAL_HAND_IN1:applyBlend(PAL_BLACK,PART_TIME)
        end
    end,
    tic=function(isFirstRun,t,unitT)
        if isFirstRun then
            PARTS=R.Parts:new()
            PARTS:addPart("hand-in",7)
            PARTS:addPart("first-move",18)
            PARTS:addPart("two-move",28)
            
            PAL_BLACK=R.Palette:new()
            PAL_BLACK:setAllRGB(R.RGB:new(0,0,0))
            PAL_WHITE=R.Palette:new()
            PAL_WHITE:setAllRGB(R.RGB:new(1,1,1),1,15)
            PAL_HAND_IN0=R.Palette:new()
            PAL_HAND_IN0:setRGB(1,R.RGB:new(0,.4,0))
            PAL_HAND_IN0:setRGB(2,R.RGB:new(0,.4,0))
            PAL_HAND_IN1=R.Palette:new()
            PAL_HAND_IN1:setRGB(1,R.RGB:new(0,.2,0))
            PAL_FIRST_MOVE0=R.Palette:new()
            PAL_FIRST_MOVE0:setRGB(0,R.RGB:new(0,0,0))
            PAL_FIRST_MOVE0:setRGB(1,R.RGB:new(0,.4,0))
            PAL_FIRST_MOVE0:setRGB(2,R.RGB:new(0,.2,0))

            local pal1=R.Palette:new()
            pal1:setRGB(0,R.RGB:new(0,0,0))
            pal1:setRGB(1,R.RGB:new(1,1,1))
            pal1:setRGB(2,GLOBAL.rgbGMan)
            pal1:setRGB(3,R.RGB:new(.1,.5,.1))
            pal1:setRGB(4,R.RGB:new(.05,.4,.05))
    

            SCENE0=R.Scene:new()
            SCENE1=R.Scene:new()

            local modelGman=R.Model:new()
            modelGman:load(require("./data/model/greenman"))
    
            ACTOR_GMAN0=R.Actor:new(modelGman)
            ACTOR_GMAN0:setDrawFn(R.poly.Draw1Colour(2),0)
            SCENE0:registerActor(ACTOR_GMAN0)

            ACTOR_GMAN1A=R.Actor:new(modelGman)
            ACTOR_GMAN1A:setDrawFn(R.poly.Draw1Colour(0),0)
            SCENE1:registerActor(ACTOR_GMAN1A)

            ACTOR_GMAN1B=R.Actor:new(modelGman)
            ACTOR_GMAN1B:setDrawFn(R.poly.Draw1Colour(0),0)
            SCENE1:registerActor(ACTOR_GMAN1B)
        end

        PART_ID,PART_TIME=PARTS:getPart(unitT)

        local man1AX=0
        local man1AZ=.1
        local man1ARot=0
        local man1BX=0
        local man1BZ=.1
        local man1BRot=0
    
        if PART_ID=="hand-in" then
            man1AZ=man1AZ*PART_TIME
            MAN0Z=MAN0Z+.01
        elseif PART_ID=="first-move" then
            if MUSIC_STARTED==false and PART_TIME>.35 then
                music(0,-1,-1,false)
                MUSIC_STARTED=true
            end
            MAN0X=MAN0X+.0024
            MAN0Z=MAN0Z+.001
            MAN0ROT=MAN0ROT+.02*PART_TIME
        elseif PART_ID=="two-move" then
            local man2t=R.clamp((PART_TIME-.15),0,1)
            MAN0X=MAN0X+.0024
            MAN0ROT=MAN0ROT+.02
            MAN0Z=MAN0Z+.001
            man1AZ=man1AZ+PART_TIME*1.8
            man1BZ=man1BZ+man2t*2.3
            man1ARot=man1ARot+PART_TIME*6
            man1BRot=man1BRot-man2t*6
            man1AX=man1AX
            man1BX=man1BX+.8*PART_TIME
        end

        local mat=R.M44:newTrans(MAN0X,.3,MAN0Z)
        mat:mulM44(R.M44:newRotY(MAN0ROT))
        ACTOR_GMAN0:setMat(mat)

        local mat=R.M44:newTrans(.37+man1AX,.035,man1AZ+0.01)
        mat:mulM44(R.M44:newRotY(man1ARot+math.pi))
        ACTOR_GMAN1A:setMat(mat)
        
        local mat=R.M44:newTrans(-.6+man1BX,.035,man1BZ+0.01)
        mat:mulM44(R.M44:newRotY(man1BRot))
        ACTOR_GMAN1B:setMat(mat)
        
        vbank(0)
        cls(1)
        SCENE0:draw()

        vbank(1)
        cls(1)
        SCENE1:draw()
    end,
}
