R=R or {}
require("./sys/sys")(R)
require("./sys/math")(R)
require("./3d/geom")(R)
require("./3d/actor")(R)
require("./3d/model")(R)
require("./3d/scene")(R)

local GLOBAL=require("./global")

local SCENE=nil
local MODEL_GMAN=nil
local ACTOR_GMAN=nil
local MAT_GMAN=nil
local PAL0=nil
local PAL_MAIN=nil

local m=math
local s=m.sin
local c=m.cos
local r=m.random
local tau=m.pi*2
local t=0


--vorPolys={}
VSCENE=nil
--ACTOR=nil
MODEL_SHARDS={}
ACTOR_SHARDS={}

function setupScreenBreak()
    VSCENE=R.Scene:new()

    local modelsVor1=require("./data/model/vor1")
    for i=1,#modelsVor1 do
        local shard=modelsVor1[i]

        MODEL_SHARDS[i]=R.Model:new()
        shard.origin={
            shard.origin[1]/shard.divide_by,
            shard.origin[2]/shard.divide_by,
            shard.origin[3]/shard.divide_by,
        }
        
        MODEL_SHARDS[i]:load(shard)

        -- set UV values (i hate lua and fking arrays that start from 1)
        for j=1,#MODEL_SHARDS[i].tris do
            local verts=MODEL_SHARDS[i].tris[j].vx
            local sox=shard.origin[1]*shard.divide_by
            local soy=shard.origin[2]*shard.divide_by
            MODEL_SHARDS[i].tris[j].ex.u1 = shard.vertices[1+(verts[1]-1) * 3] - sox + 120
            MODEL_SHARDS[i].tris[j].ex.v1 = shard.vertices[1+(verts[1]-1) * 3 + 1] - soy + 68
            MODEL_SHARDS[i].tris[j].ex.u2 = shard.vertices[1+(verts[2]-1) * 3] - sox + 120
            MODEL_SHARDS[i].tris[j].ex.v2 = shard.vertices[1+(verts[2]-1) * 3 + 1] - soy + 68
            MODEL_SHARDS[i].tris[j].ex.u3 = shard.vertices[1+(verts[3]-1) * 3] - sox + 120
            MODEL_SHARDS[i].tris[j].ex.v3 = shard.vertices[1+(verts[3]-1) * 3 + 1] - soy + 68
        end
         
        ACTOR_SHARDS[i]=R.Actor:new(MODEL_SHARDS[i])
        ACTOR_SHARDS[i]:setDrawFn(DrawVBankTexture,R.Model.CALC_NORMAL)

        VSCENE:registerActor(ACTOR_SHARDS[i])
    end

end


function DrawVBankTexture(tr)
	if tr.ex.u1 then
		ttri(
			tr.v[1].x,tr.v[1].y,
			tr.v[2].x,tr.v[2].y,
			tr.v[3].x,tr.v[3].y,
			tr.ex.u1,tr.ex.v1,
			tr.ex.u2,tr.ex.v2,
			tr.ex.u3,tr.ex.v3,
			2, -1,
            tr.v[1].z,
            tr.v[2].z,
            tr.v[3].z
		)
	end
end


    return {
        bdr=function(y,t,unitT)
            local inT=1
            if(unitT<.3)then
                inT=unitT/.3
            elseif(unitT>.7)then
                inT=1-((unitT-.7)/.3)
            end
            PAL0:applyBlend(PAL_MAIN,inT)
        end,
        musicTic=function(isFirstRun,t,unitT)
            if isFirstRun or VSCENE == nil then
                PAL0=R.Palette:new()
                PAL0:setAllRGB(R.RGB:new(0,0,0))
    
                PAL_MAIN=R.Palette:new()
                for i=0,15 do
                    local s=i/15
                    PAL_MAIN:setRGB(i,R.RGB:new(0,s,0))
                end

                --                vbank(0)
--                memcpy(0x8000,0,120*136)
                setupScreenBreak()
                --firstIn=false
            else
                vbank(0)
                memcpy(0,0x8000,120*136)
            end
            vbank(1)
            cls(1)

            local z={}
            local numshards=#ACTOR_SHARDS
            for i=1,#ACTOR_SHARDS do
                local nt = (R.smoothStep((unitT)%1,0,1) * ((i*.313742)%1))
                z[i] = {i,nt}
            end

            local xt = 0

            if unitT > .75 then
                xt = R.smoothStep(2*(unitT-0.75),0,1)*2
            end

            table.sort(z,function(a,b) return a[2]<b[2] end)
            VSCENE:clearActors()

            for i=1,#ACTOR_SHARDS do
                local actor=ACTOR_SHARDS[z[i][1]]
    
                local mat=R.M44:new(R.M44.ID)
                mat:mulM44(R.M44:newRotZ(unitT/100))
                mat:mulM44(R.M44:newTrans(0,0+xt,0.65-z[i][2]))
                actor:setMat(mat)
    
                VSCENE:registerActor(ACTOR_SHARDS[z[i][1]])

            end
    
            --VSCENE:getCam():setPos(R.V4:new({0,0,-1,1}))
            --VSCENE:getCam():setAim(R.V4:new({0,0,0,1}))
    
            VSCENE:draw()
            vbank(0)
            cls()
        end,
        cleanup=function()
            vbank(0)
            cls()
            vbank(1)
            cls()
        end
    }

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>
