R=R or {}
require("./3d/model")(R)
require("./3d/scene")(R)

local GLOBAL=require("./global")

local FONT=nil
local PAL0=nil
local PAL_MAIN=nil
local PAL_OVERLAY=nil
local SCENE=nil
local SCENE_OVERLAY=nil
local MODEL_GMAN=nil
local ACTOR_GMAN=nil
local MAT_GMAN=nil
local ACTOR_BANNER1=nil
local SMACK_ANGLE=0

lampFilter=require('./screenfilters/lamp')

return {
    musicPatterns=2,
    bdr=function(y,t,unitT)
        local inT=1-(unitT/2)
        vbank(0)

--        PAL_MAIN:apply()
--        PAL0:applyBlend(PAL_MAIN,inT)
        PAL0:applyBlend(PAL_MAIN,inT)

vbank(1)
--[[
        for i=0,15 do
            local s=i/15
            poke(i,0x3FC0+i*3,(s*255)//1)
            poke(i,0x3FC0+i*3+1,0)
            poke(i,0x3FC0+i*3+2,0)
        end

--]]
---        PAL_MAIN:apply()
        PAL0:applyBlend(PAL_MAIN,inT)
    end,
    musicTic=function(isFirstRun,t,unitT)
        local banner1W,banner1H=240,25
        local banner2W,banner2H=80,20
        if isFirstRun then
            PAL0=R.Palette:new()
            PAL0:setAllRGB(R.RGB:new(0,0,0))

            PAL_MAIN=R.Palette:new()
            for i=0,15 do
                local s=i/15
                PAL_MAIN:setRGB(i,R.RGB:new(0,s,0))
            end

            PAL_OVERLAY=R.Palette:new()
            for i=0,15 do
                local s=i/15
                PAL_OVERLAY:setRGB(i,R.RGB:new(s*.2,1-(s^2),s*.2))
            end
--[[            PAL_OVERLAY:setRGB(0,R.RGB:new(0,0,0))
            PAL_OVERLAY:setRGB(1,R.RGB:new(0,0,0))
            PAL_OVERLAY:setRGB(2,R.RGB:new(1,1,0))
            PAL_OVERLAY:setRGB(3,R.RGB:new(1,1,1))
            PAL_OVERLAY:setRGB(4,R.RGB:new(0,.3,.6))
--]]
            FONT=R.Font:new()
            FONT:load(require("./data/font/nucampi-8x16/nucampi-8x16"))

            SCENE=R.Scene:new()
            SCENE_OVERLAY=R.Scene:new()

            MODEL_GMAN=R.Model:new()
            MODEL_GMAN:load(require("./data/model/green-man-walking"))

            ACTOR_GMAN=R.Actor:new(MODEL_GMAN)
            ACTOR_GMAN:setDrawFn(R.poly.Draw1Colour(1),0)

            SCENE:registerActor(ACTOR_GMAN)

            local model=R.Model:new()
            model:load(require("./data/model/rectangle")(10,1))
            ACTOR_BANNER1=R.Actor:new(model)
            ACTOR_BANNER1:setDrawFn(R.poly.DrawTex(0,0,banner1W,banner1H),0)
            local mat=R.M44:newTrans(0,.35,1)
            mat:mulM44(R.M44:newRotZ(-.2))
            ACTOR_BANNER1:setMat(mat)    
            SCENE_OVERLAY:registerActor(ACTOR_BANNER1)

            model=R.Model:new()
            model:load(require("./data/model/rectangle")(1,.25))
            ACTOR_BANNER2=R.Actor:new(model)
            ACTOR_BANNER2:setDrawFn(R.poly.DrawTex(0,30,banner2W,banner2H),0)
            local mat=R.M44:newTrans(1.2,-.40,3)
            mat:mulM44(R.M44:newRotZ(.1))
            ACTOR_BANNER2:setMat(mat)    
            SCENE_OVERLAY:registerActor(ACTOR_BANNER2)
        end

        vbank(1)
        cls()
        for y=0,banner1H do
            for x=0,banner1W do
                pix(x,y,(x+y>>4)%2==0 and 1 or 2)
            end
        end
        FONT:print("Contained",81,6,1,1,2)
        FONT:print("Contained",80,5,1,1,12)
        rect(0,30,banner2W,banner2H,4)
        print("PLEASE STAY",10,33,15)
        print("IN YOUR BOX",10,43,15)

        local pos=R.V4:new({0,0,-unitT,1})
--        local pos=R.V4:new({0,0,0,1})
        local aim=R.V4:new({0,0,1,1})

        vbank(0)
        local cam=SCENE_OVERLAY:getCam()
        cam:setPos(pos)
        cam:setAim(aim)
        SCENE_OVERLAY:draw()
        local pixs={}
        for y=0,136 do
            for x=0,240 do
                pixs[y*240+x]=pix(x,y)
            end
        end
        cls(0)

        local phase,inPhase=math.modf(unitT*16*4,16)
        phase=phase%16
        local z=1
        local a=0
        if phase<=10 then
            z=z+(phase+inPhase)/11
        elseif phase==11 then
            z=z+1
            SMACK_ANGLE=math.sin((5+unitT)^12)*.4
        elseif phase==12 then
            z=z+(1-inPhase)
            a=SMACK_ANGLE
        else
            z=z
            a=SMACK_ANGLE
        end
        local mat=R.M44:newTrans(0,0,1+z)
        mat:mulM44(R.M44:newRotZ(a))
        ACTOR_GMAN:setMat(mat)

        local cam=SCENE:getCam()
        cam:setPos(pos)
        cam:setAim(aim)
        SCENE:draw()
        lampFilter(120,68,10+70*(1-(unitT*.4)))

        vbank(1)
        for y=0,136 do
            for x=0,240 do
                pix(x,y,pixs[y*240+x])
            end
        end
    end,
    cleanup=function()
        vbank(0)
        memcpy(0x8000,0,120*136)
        cls()

        vbank(1)
        cls()
    end
}
