package.path=package.path..";C:\\Users\\micro\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jtruk
package.path=package.path..";C:\\Users\\Ronan\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- Mantratronic
package.path=package.path..";C:\\Users\\Matt\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jynx

R=R or {}
require("./sys/sys")(R)
require("./3d/geom")(R)
require("./3d/model")(R)
require("./3d/scene")(R)
require("./3d/actor")(R)

m=math
s=m.sin
c=m.cos
r=m.random
tau=m.pi*2

SCENE=nil
MODEL_GMAN=nil
ACTOR_GMAN=nil

-- three flow field angles
-- small leaves/squares moving through fields, 2 background behind greenman, 1 in front
-- added move from left to right for main wind direction

-- 2d array of angles
local field1 = {} -- foreground
local field2 = {} 
local field3 = {} -- background

-- array of 2d points
local leaves1 = {}
local leaves2 = {}
local leaves3 = {}

function makeFlowField(xZoom,yZoom,scale,curve)
  local ff={}
  for x=0,240/scale+1 do
    ff[x]={}
    for y=0,136/scale+1 do
     ff[x][y]=(s(x*xZoom)+c(y*yZoom))*curve
    end
   end
  return ff
end

function BOOT()
  SCENE=R.Scene:new()

	MODEL_GMAN=R.Model:new()
	MODEL_GMAN:load(require("./data/model/green-man-walking"))
	
  ACTOR_GMAN=R.Actor:new(MODEL_GMAN)
  ACTOR_GMAN:setDrawFn(R.poly.Draw1Colour(6),R.Model.Z_SORT|R.Model.CALC_NORMAL)
  local mat=ACTOR_GMAN:getMat()

  SCENE:registerActor(ACTOR_GMAN)

  for i=1,5 do
    leaves1[i]={x=r(240)-1,y=r(136)-1}
  end
  for i=1,10 do
    leaves2[i]={x=r(240)-1,y=r(136)-1}
  end
  for i=1,20 do
    leaves3[i]={x=r(240)-1,y=r(136)-1}
  end

  field1 = makeFlowField(0.1,0.05,10,.8)
  field1.scale = 10
  field1.speed = 3
  field2 = makeFlowField(0.3,0.15,5,0.9)
  field2.scale = 5
  field2.speed = 1.75
  field3 = makeFlowField(0.4,0.2,3,1.0)
  field3.scale = 3
  field3.speed = 1.25
  
end
  
t=0

function windFlow(field, leaves, scale)
  for i=1,#leaves do
    local fx=leaves[i].x//field.scale
    local fy=leaves[i].y//field.scale
  
    if fx < 0 or fx > #field-2 or fy < 0 or fy > #field[fx] then
      local r = r(376)
      local x = 0
      local y = 0
      if r < 136 then
        y = r
      else
        x = r-136
      end
      fx=x//field.scale
      fy=y//field.scale
      leaves[i].x = x
      leaves[i].y = y
    end
    local fa = field[fx][fy]
  
    leaves[i].x = leaves[i].x+field.speed*s(fa+t/1000)+field.speed
    leaves[i].y = leaves[i].y+field.speed*c(fa)
  
    --pix(leaves[i].x,leaves[i].y,2+scale)
    --rect(leaves[i].x,leaves[i].y,scale,scale,2+scale)
    spr(0,leaves[i].x-4*scale,leaves[i].y-4*scale,0,scale)
  end
end

function TIC()
  t=t+1
  R.tryBreak()
  R.hideMouse()

  vbank(0)
  cls()
  windFlow(field3, leaves3,1)
  windFlow(field2, leaves2,2)

  local matView=R.M44:new(R.M44.ID)
	local matProj=R.M44:new(R.M44.ID)
	local viewport=R.Viewport:new(240,136)

  mat=R.M44:new(R.M44.ID)
  mat:mulM44(R.M44:newTrans(0,0,2))
  mat:mulM44(R.M44:newRotZ(time()*.0012))
  ACTOR_GMAN:setMat(mat)

  --mat:mulM44(R.M44:newRotZ(time()*.0012))

	SCENE:draw()

  vbank(1)
  cls()
  windFlow(field1, leaves1,3)

end

-- <TILES>
-- 000:0000000000000220000223320322232002322320222332200032220000000000
-- </TILES>

-- <WAVES>
-- 000:00000000ffffffff00000000ffffffff
-- 001:0123456789abcdeffedcba9876543210
-- 002:0123456789abcdef0123456789abcdef
-- </WAVES>

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- 001:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

