package.path=package.path..";C:\\Users\\micro\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jtruk
package.path=package.path..";C:\\Users\\Ronan\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- Mantratronic

R=R or {}
require("./sys/sys")(R)
require("./sys/math")(R)
require("./3d/geom")(R)
require("./3d/actor")(R)
require("./3d/model")(R)
require("./3d/scene")(R)

vorPolys={}
MODEL_BOLLARD=nil
MODEL_ROADSIGN=nil
MODEL_STREETLIGHT=nil
CSCENE=nil
VSCENE=nil
ACTOR=nil
MODEL_SHARDS={}
ACTOR_SHARDS={}

function BOOT()
    MODEL_BOLLARD=R.Model:new()
    MODEL_BOLLARD:load(require("./data/model/bollard"))

    MODEL_ROADSIGN=R.Model:new()
    MODEL_ROADSIGN:load(require("./data/model/roadsign"))

    MODEL_STREETLIGHT=R.Model:new()
    MODEL_STREETLIGHT:load(require("./data/model/streetlight"))

    CSCENE=R.Scene:new()

    for i=1,10 do
        local slActor=R.Actor:new(MODEL_STREETLIGHT)
        slActor:setDrawFn(R.poly.DrawDebug,R.Model.Z_SORT|R.Model.CALC_NORMAL)
        local mat=slActor:getMat()
        local scale=.1
        mat:mulM44(R.M44:newTrans(-1+i*.2,0,2))
        mat:mulM44(R.M44:newScale(scale,scale,scale))
        mat:mulM44(R.M44:newRotX(math.pi))

        CSCENE:registerActor(slActor)
    end

    local rsActor=R.Actor:new(MODEL_ROADSIGN)
    rsActor:setDrawFn(R.poly.Draw1Colour(3),R.Model.Z_SORT|R.Model.CALC_NORMAL)
    local mat=rsActor:getMat()
    local scale=.5
    local matModel=R.M44:new(R.M44.ID)
    mat:mulM44(R.M44:newTrans(0,0,1))
    mat:mulM44(R.M44:newScale(scale,scale,scale))
    mat:mulM44(R.M44:newRotX(math.pi))
	mat:mulM44(R.M44:newRotY(math.pi/1.6))
	mat:mulM44(R.M44:newRotZ(time()*.0001))

    CSCENE:registerActor(rsActor)

    for i=1,10 do
        local actorBollard=R.Actor:new(MODEL_BOLLARD)
        actorBollard:setDrawFn(R.poly.DrawDebug,R.Model.Z_SORT|R.Model.CALC_NORMAL)
        local mat=actorBollard:getMat()
        mat:mulM44(R.M44:newTrans(-2+i*.4,0,2))
        mat:mulM44(R.M44:newRotX(math.pi))

        CSCENE:registerActor(actorBollard)
    end

    VSCENE=R.Scene:new()

    local modelsVor1=require("./data/model/vor1")
    for i=1,#modelsVor1 do
        local shard=modelsVor1[i]

        MODEL_SHARDS[i]=R.Model:new()
        shard.origin={
            shard.origin[1]/shard.divide_by,
            shard.origin[2]/shard.divide_by,
            shard.origin[3]/shard.divide_by,
        }
        
        MODEL_SHARDS[i]:load(shard)

        -- set UV values (i hate lua and fking arrays that start from 1)
        for j=1,#MODEL_SHARDS[i].tris do
            local verts=MODEL_SHARDS[i].tris[j].vx
            local sox=shard.origin[1]*shard.divide_by
            local soy=shard.origin[2]*shard.divide_by
            MODEL_SHARDS[i].tris[j].ex.u1 = shard.vertices[1+(verts[1]-1) * 3] - sox + 120
            MODEL_SHARDS[i].tris[j].ex.v1 = shard.vertices[1+(verts[1]-1) * 3 + 1] - soy + 68
            MODEL_SHARDS[i].tris[j].ex.u2 = shard.vertices[1+(verts[2]-1) * 3] - sox + 120
            MODEL_SHARDS[i].tris[j].ex.v2 = shard.vertices[1+(verts[2]-1) * 3 + 1] - soy + 68
            MODEL_SHARDS[i].tris[j].ex.u3 = shard.vertices[1+(verts[3]-1) * 3] - sox + 120
            MODEL_SHARDS[i].tris[j].ex.v3 = shard.vertices[1+(verts[3]-1) * 3 + 1] - soy + 68
        end
         
        ACTOR_SHARDS[i]=R.Actor:new(MODEL_SHARDS[i])
        ACTOR_SHARDS[i]:setDrawFn(DrawVBankTexture,R.Model.Z_SORT|R.Model.CALC_NORMAL)

        VSCENE:registerActor(ACTOR_SHARDS[i])
    end
end

firstIn = true

function DrawVBankTexture(tr)
	if tr.ex.u1 then
		ttri(
			tr.v[1].x,tr.v[1].y,
			tr.v[2].x,tr.v[2].y,
			tr.v[3].x,tr.v[3].y,
			tr.ex.u1,tr.ex.v1,
			tr.ex.u2,tr.ex.v2,
			tr.ex.u3,tr.ex.v3,
			2, -1,
            tr.v[1].z,
            tr.v[2].z,
            tr.v[3].z
		)
	end
end


function TIC()
	R.tryBreak()

    if time() < 1000 then
        vbank(0)
        cls(1)
        firstIn=true

        CSCENE:getCam():setPos(R.V4:new({0,time()*-0.002,0,1}))
        CSCENE:getCam():setAim(R.V4:new({0,0,-2,1}))
    
        CSCENE:draw()
    
        print("TEST",0,0,12,false,8)
    
    else
        -- for texture later
        if firstIn == true then
            memcpy(0x8000,0,120*136)
            firstIn=false
        else
            vbank(0)
            memcpy(0,0x8000,120*136)
        end

        vbank(1)
        cls(4)

        local time = time()-1000
        for i=1,#ACTOR_SHARDS do
            local actor=ACTOR_SHARDS[i]
            t = (R.smoothStep((time * 0.0001)%1,0,1) * i/60)

            -- attempt at center moves more
--            local o=shModels[i].origin
--            t = 1/(((o[1])^2+(o[2])^2)^.5) *t*100

            local mat=R.M44:new(R.M44.ID)
--            mat:mulM44(R.M44:newRotZ(t))
--            mat:mulM44(R.M44:newTrans(0,0,0.65-t*5))
            mat:mulM44(R.M44:newTrans(0,0,0.65-t/2))
            actor:setMat(mat)

            --matModel:mulM44(R.M44:newTrans(0,0,1))
            --matModel:mulM44(R.M44:newRotZ(t))

            --matModel:mulM44(R.M44:newRotX(3*t))
            --matModel:mulM44(R.M44:newRotY(8*t))
--            VSCENE.actors[i]:setMat(matModel)
        end

        --VSCENE:getCam():setPos(R.V4:new({0,0,-1,1}))
        --VSCENE:getCam():setAim(R.V4:new({0,0,0,1}))

        VSCENE:draw()
        vbank(0)
        cls()
    end
end

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- 001:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

