package.path=package.path..";D:\\Nova2023\\wild\\nova submission\\rift\\?.lua"	-- jtruk
package.path=package.path..";D:\\Nova2023\\wild\\nova submission\\rift-nova-2023\\?.lua"	-- jtruk
package.path=package.path..";D:\\Nova2023\\wild\\nova submission\\rift\\?.lua"	-- Mantratronic
package.path=package.path..";C:\\Users\\Ronan\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\nova2023ticdemo\\?.lua"	-- mt
package.path=package.path..";C:\\Users\\Philipp\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- Decca
package.path=package.path..";C:\\Users\\Philipp\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift-nova-2023\\?.lua"	-- Decca
package.path=package.path..";C:\\Users\\matt\\AppData\\Roaming\\com.nesbox.tic\\TIC-80\\rift\\?.lua"	-- jynx

IS_DEBUG_MODE=false

-- If IS_DEBUG_MODE
-- nil or index of state
DEBUG_SET_STATE=14
DEBUG_SHOW_TIME=true
STATE_CLEANUP=nil

R=R or {}
require("./sys/sys")(R)
require("./sound/music")(R)

STATES={
    require("./state/intro-card"),
    require("./state/spacer")(2000),
    require("./state/state-of-the-art"),
    -- Jazzy logo, some colour shifting?
    require("./state/logo-opener"),
--    require("./state/_logo-opener"),
    -- Logo transforms onto a wall. Pans around to street signal
    require("./state/street-opening"),
    -- Pans up the street signal, showing green and red man
    require("./state/street-signal-pan-up"),
    -- Green man breaks out
    require("./state/greenman-breakout"),
    -- Green man falls
    require("./state/fall"),
    -- Green man gets up
    require("./state/greenman-get-up"),
    -- A number of walk cycles
    require("./state/walk-garden"),
    require("./state/walk-wind"),
    require("./state/walk-underwater"),
    require("./state/walk-prism"),
--    require("./state/walk-splits"),
    require("./state/walk-greetz"),
    -- ...
    -- ...
    -- Redman gets angry
    require("./state/redman-says-stop"),
    require("./state/vehicle-approaches"),
    -- A shattered Greenman
    require("./state/greenman-lying"),
    -- Greenman is back, broken in his prison
    require("./state/greenman-recaptured"),
    -- screen break, dunno where to put it
    require("./state/screen-break"),
    
    --require("./state/spacer")(5000),
    require("./state/outro-card"),
    require("./state/closedown"),
    require("./state/spacer")(5000),
}

I_STATE=0
STATE_START_TIME=0
DO_NEXT_STATE=true
local TIME_PATTERN_STARTED=0
local PATTERNS_DONE=0
local DO_PATTERNS=0
local PREV_MUSIC_PATT=0
local musicStarted=false
local UNIT_T=0

function BOOT()
    setStateNext()
    if IS_DEBUG_MODE and DEBUG_SET_STATE ~= nil then
        I_STATE=DEBUG_SET_STATE-1
    end
end

BDR=function(y)
	state=STATES[I_STATE]
    if state.bdr then
        local t=time()-STATE_START_TIME
        state.bdr(y,t,UNIT_T)        
    end
end

TIC=R.ticWrap(function()
	R.tryBreak()
	R.hideMouse()

    local isFirstRun=false
    if DO_NEXT_STATE then
        I_STATE=I_STATE+1
        STATE_START_TIME=time()
        isFirstRun=true
        DO_NEXT_STATE=false
    end

	local state=STATES[I_STATE]
    local t=time()-STATE_START_TIME

    local endThisState=false
    if state.tic then
        UNIT_T=state.duration and t/state.duration or nil
        endThisState=state.tic(isFirstRun,t,UNIT_T)
        if IS_DEBUG_MODE and keyp(48) then
            setStateNext()
        elseif endThisState or (UNIT_T~=nil and UNIT_T >= 1) then
            setStateNext()
        end

        if IS_DEBUG_MODE and DEBUG_SHOW_TIME then
            vbank(1)
            rect(4,127,111,7,15)
            print(string.format("S: %s T: %.2d UT: %.2f", I_STATE, t, (UNIT_T) and UNIT_T or 0),6,128,14)
        end
    elseif state.musicTic then
        if not musicStarted then
            music(2)
            TIME_PATTERN_STARTED=time()
            PATTERNS_DONE=0
            musicStarted=true
        end

        local mpos=R.music.getPos()
        local musMeta=R.music.getTrackMeta(mpos.track)
    
--        trace(string.format("%d %d %d", mpos.track, mpos.row, mpos.tick))

        -- Might need to do T with 60FPS instead...
        local elapsed=(time()-TIME_PATTERN_STARTED)/1000
        local bpm=(6*musMeta.tempo)/musMeta.speed
        local rowsPerSec=(bpm/(60/4))
        local rowsDone=elapsed*rowsPerSec
        local pattern
        pattern,patternPart=math.modf(rowsDone/musMeta.rows)
        local doPatterns=state.musicPatterns or 1
    
        -- We can also resync on row=0 if we have to?
        if pattern>PREV_MUSIC_PATT then
            PATTERNS_DONE=PATTERNS_DONE+1
            if PATTERNS_DONE>=doPatterns then
                setStateNext()
                PATTERNS_DONE=0
            end
            TIME_PATTERN_STARTED=time()
        end
    
        UNIT_T=(PATTERNS_DONE+patternPart)/doPatterns
        local tWalk=UNIT_T*doPatterns
        state.musicTic(isFirstRun,t,UNIT_T,PATTERNS_DONE,tWalk)
    
        if IS_DEBUG_MODE and DEBUG_SHOW_TIME then
            vbank(1)
            print(musMeta.tempo,0,128,1)
            print(musMeta.rows,60,128,1)
            print(musMeta.speed,120,128,1)
            print(pattern,220,128,1)

            rect(UNIT_T*240,135,4,1,12)
        end
        
        trace(STATE_CLEANUP)
        if STATE_CLEANUP~=nil and STATE_CLEANUP>0 then
            trace("yayt")
            local state=STATES[STATE_CLEANUP]
            if state.cleanup then
                state.cleanup()
            end
            STATE_CLEANUP=nil
        end

        PREV_MUSIC_PATT=pattern
    end
end)

function setStateNext()
    STATE_CLEANUP=I_STATE
    if I_STATE>=#STATES then
        trace("- Natural Exit :)",12)
        exit()
    end
    DO_NEXT_STATE=true
end

-- <TILES>
-- 000:0000000000000220000223320322232002322320222332200032220000000000
-- </TILES>

-- <WAVES>
-- 000:0000000000000000ffffffffffffffff
-- 001:00000000000000000000ffffffffffff
-- 002:0000000000000000000000000fffffff
-- 003:00000000000000000000000000000fff
-- 005:000367bdeffffffffca97666608090bc
-- 006:0003678777899dfffedc76766677899a
-- </WAVES>

-- <SFX>
-- 000:00000130027003c002a00100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000402007000500
-- 001:6400a400d400e400f400f400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400700000410000
-- 002:640074009400c400e400f400040004000400040004000400040004000400040004000400040004000400040004000400040004000400040004000400700000410000
-- 003:0000002000500070009000c000e0010001000100010001000100020002000200020002000200030003000300030003000300030002000200020002005f3000000700
-- 004:000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000300000000000
-- 005:040004000040009000f00400200030005000600070009000a000b000c000c000d000d000e000e000e000e000e000e000e000f000f000f000f000f000384051500000
-- 006:7400a400c400e400f400f400f400f400a400a400b400c400d400e400f400f40004000400040004000400040004000400040004000400040004000400604000710000
-- 007:010c210e33004300610071009100a100c100e1006100710081009100b100c100d100e100f10051006100810091009100a100c100d100d100f100f100b0b005000000
-- 016:040004000040009000f0f000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000380000510000
-- 017:33004400530074008400a400a400c400d400d400f4000400040004000400040004000400040004000400040004000400040004000400040004000400607000910000
-- 018:050005000600060006000600060006000600060006000600060006000600060006000600060006000600060006000600060006000600060006000600309042000000
-- 019:00c000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000400000000000
-- 020:640074009400a400b400c400d400d400e400f400f400f400f400f400f400f40004000400040004000400040004000400040004000400040004000400609000e10000
-- 021:740084009400a400c400e400f400f400a400a400b400c400d400e400f400f40004000400040004000400040004000400040004000400040004000400607000710000
-- </SFX>

-- <PATTERNS>
-- 000:6111080000000000000000000331000000000000000000000551000000000000000000000771000000000000000000000991000000000000000000000bb1000000000000000000000dd1000000000000000000000ff1000000000000000000000dd1000000000000000000000bb100000000000000000000099100000000000000000000077100000000000000000000055100000000000000000000033100000000000000000000011100000000000000000000011100000000000000000000
-- 001:0000006111080000000000000000000311000000000000000000000531000000000000000000000751000000000000000000000971000000000000000000000b91000000000000000000000db1000000000000000000000fd1000000000000000000000df1000000000000000000000bd10000000000000000000009b100000000000000000000079100000000000000000000057100000000000000000000035100000000000000000000013100000000000000000000011100000000000000
-- 002:b0001c000000000000000000b0002a000000000000000000b0001c000000000000000000b0002a000000000000000000b0001c000000000000000000b0002a000000000000000000b0001c000000000000000000b0002a000000000000000000b0001c000000000000000000b0002a000000000000000000b0001c000000000000000000b0002a000000000000000000b0001c000000000000000000b0002a000000000000000000b0001c000000000000000000b0002a000000000000000000
-- 003:6af13a00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060003a00000000000000000000000000000000000000000000000000000000000000000060003c00000000000000000060003a00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060003a00000000000000000000000000000000000000000000000000000000000000000060003c000000000000000000
-- 004:d88107000000000000d66107d88107d22107000000d44107d66107daa107000000000000dcc107000000d88107d66107dff107d00007000000666109dff107000000000000d66107dff107000000000000666109dff107000000d00007000000dff107d00007000000666109dff107000000000000d66107dff107000000000000666109dff107000000d00007000000dff107d00007000000666109dff107000000000000d66107dff107000000000000666109dff107000000d00007000000
-- 005:d22119100000000000d22119d66119d33119100000000000000000d66119100000000000d88119000000100000d88119100000000000d88119000000000000100000d00019000000000000100000d00019000000000000100000d00019000000000000000000d66119100000000000000000d88119000000000000100000d88119000000100000000000d88119000000000000100000d00019000000000000100000d00019000000000000100000d00019000000000000000000b00019000000
-- 006:00000000000000000000000000000000000000000000000000000000000000000000000042214d44415d46615d48815d4aa14d48915d4c415d47815d49c14d4aa15d47614d44c15d4aa14d48915d4c415d47815d49c14d4aa15d47614d44c15d4aa14d48915d4c415d47815d49c14d4aa15d47614d44c15d4aa14d48915d4c415d47815d49c14d4aa15d47614d44c15d4aa14d48915d4c415d47815d49c14d4aa15d47614d44c15d4aa14d48915d4c415d47815d49c14d4aa15d47614d44c15d
-- 007:000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000daf125d00023100000d00033100000d00033b00027d00027000000100000000000000000b00035b00025100000000000d00025d00023100000d00033100000d00033b00027d00027000000100000000000000000e00023e00027e00035e00033
-- 008:dff107d00007000000666109ddd107000000000000d55107dbb107000000000000644109d88107000000d00007000000d33107d00007000000622109d44107000000000000d11107d22107000000000000611109d11107000000d00007000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 009:000000100000dff119000000000000100000ddd119000000000000100000dbb119000000000000000000b88119000000000000100000d66119000000000000100000d44119000000000000100000d22119020000000000000000b11119000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 010:4aa14d48915d4c415d47815d49c14d4aa15d47614d44c15d4aa14d48915d4c415d47815d49c14d4aa15d47614d44c15d46614d46615d45515d45515d44414d44415d43314d43315d42214d42215d42215d42215d41114d41115d41114d41115d100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 011:daf125d00023100000d0003319d100d00033b00027d0002707b100100000000000000000b58135b00025100000000000d46125d00023100000d00033134100d00033b00027d00027022100100000000000000000e11123e00027e00035e00033100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 012:daf138000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d00038000000000000000000000000000000000000000000000000000000000000000000d0003a000000000000000000d00038000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000d00038000000000000000000000000000000000000000000000000000000000000000000d0003a000000000000000000
-- 013:d111080000000000000000000331000000000000000000000551000000000000000000000771000000000000000000000991000000000000000000000bb1000000000000000000000dd1000000000000000000000ff1000000000000000000000dd1000000000000000000000bb100000000000000000000099100000000000000000000077100000000000000000000055100000000000000000000033100000000000000000000011100000000000000000000011100000000000000000000
-- 014:000000d111080000000000000000000311000000000000000000000531000000000000000000000751000000000000000000000971000000000000000000000b91000000000000000000000db1000000000000000000000fd1000000000000000000000df1000000000000000000000bd10000000000000000000009b100000000000000000000079100000000000000000000057100000000000000000000035100000000000000000000013100000000000000000000011100000000000000
-- 015:00000068613a00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060003a00000000000000000000000000000000000000000000000000000000000000000060003c00000000000000000060003a00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060003a00000000000000000000000000000000000000000000000000000000000000000060003c000000000000
-- 016:60004c6ff442000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000
-- 017:600033000000600035100000000000000000600023000000100000000000600027000000400037000000600027000000100000000000600023000000600025000000100000000000600035000000000000000000400025000000100000000000600033000000600035100000000000000000600023000000100000000000600027000000400027000000600037000000100000000000600023000000600025000000100000000000600035000000000000000000400025000000100000000000
-- 018:4ff1094af16c4fa16e4af16cbff1580000004ff1094af16e4fa16c4af16e4ff1094fa16cbff1580000004ff16c4ff16c4ff1094af16c4fa16e4af16cbff1580000004ff1094af16e4fa16c4af16e4ff1094fa16cbff158000000bff1580000004ff1094af16c4fa16e4af16cbff1580000004ff1094af16e4fa16c4af16e4ff1094fa16cbff1580000004ff16c4ff16c4ff1094af16c4fa16e4af16cbff1580000004ff1094af16e4fa16c4af16e4ff1094fa16cbff158000000bff158bff158
-- 019:60000810000060000810000060000810000060000810000060000810000060000810000060000a60000660000810000060000810000060000810000060000810000060000810000060000810000060000810000060000a60000660000810000060000810000060000810000060000810000060000810000060000810000060000810000060000a60000660000810000060000810000060000810000060000810000060000a10000060000a10000050000a10000040000a100000f00008100000
-- 020:626148900048d0004860004a600048900048d0004860004a600048900048d0004860004a600048900048d0004860004a626148900048d0004860004a600048900048d0004860004a600048900048d0004860004a600048900048d0004860004a626148900048d0004860004a600048900048d0004860004a600048900048d0004860004a600048900048d0004860004a626148900048d0004860004a600048900048d0004860004a600048900048d0004860004a600048900048d0004860004a
-- 021:60000a60000868810a6881081ff10000000060002910000060002910000040002910000060002910000090002900000006760000000010000000000090002910000060002910000040002910000090002910000040002910000000000000000060060c60000a60000860000a60003b00000060003b00000040003b10000040003b000000d00039000000d00039100000b00039000000b00039000000900039000000400029000000600029000000900029000000b00029000000d00029000000
-- 022:900033000000900025100000000000000000900033000000100000000000900025000000600025000000900035000000100000000000900033000000900025000000100000000000900025000000000000000000600035000000100000000000400033000000400035100000000000000000400025000000100000000000400027000000d00033000000600025000000100000000000600033000000600035000000100000000000600023000000000000000000600025000000100000000000
-- 023:90003990003b98813998813b1ff100000000900029100000900029100000600029100000900029100000d0002900000006760000000010000000000090002910000090002910000080002910000060002910000090002910000040002900000060060c60000a60000860000a60003b000000000000000000600039100000600039100000900039000000900039100000d00039000000d0003900000060003b10000060003b00000090003b10000090003b000000d0003b000000d0003b100000
-- 024:000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000b11158b22158b33158b44158b55158b66158b77158b88158b99158baa158bbb158bcc158bdd158bee158bff158bff158
-- 025:00000000000090007a00000080007a00000070007a00000060007a00000050007a00000040007a000000f00078000000e00078000000d00078000000c00078000000b00078000000a0007800000090007800000080007800000070007800000000000000000090007a00000080007a00000070007a00000060007a00000050007a00000040007a000000f00078000000e00078000000d00078000000c00078000000b00078000000a00078000000900078000000800078000000700078000000
-- 026:0000000000009ff17898817a8ff17888817a7ff17878817a6ff17868817a5ff17858817a4ff17848817afff176f88178eff176e88178dff176d88178cff176c88178bff176b88178aff176a881789ff1769881788ff1768881787ff1767881780000000000009ff17898817a8ff17888817a7ff17878817a6ff17868817a5ff17858817a4ff17848817afff176f88178eff176e88178dff176d88178cff176c88178bff176b88178aff176a881789ff1769881788ff1768881787ff176788178
-- </PATTERNS>

-- <TRACKS>
-- 000:581702982b030000000000000000000000000000000000000000000000000000000000000000000000000000000000007e0000
-- 001:180000180300180301ec3343180301ec33430043011143010000000000000000000000000000000000000000000000000000ff
-- 002:7500007509102963102963102d63102d63102513102513102513112513113000800000800000000000000000000000000000ff
-- 003:2103102103102153102153102553952553957553167553162500002500000000000000000000000000000000000000000000ff
-- </TRACKS>

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- 001:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

