-- title:  Font Routine - Tecampi 8x16
-- author: Mantratronic / RiFT
-- artist: Decca / RiFT
-- desc:   font writer@demo framework
-- script: lua

-- font data
local rle = "0800020OHPHOHPHP7HOHOHOHOHOHOHOHOHOHOHOHOHOHOHOHOHOPPHAHOP2HHAHOPPOPOHHOP5HOHAHAHOHOHAHAHOHOHAHAHOHOHAHAHOHOPDPDHAP2DPDHP2HAMBHOHAHAMBHOHAHAMBHOHAHAMBHOHAHAMBHOHAHAMBHOHAHAMBPHHAHAMBPDHAP2AHOOHP2BHOPPHOMBHOHOHOMBPOHOHOMBPOHOHOMBPPHOHOMBPPHOHOMBPPHOPPHOHOHOHOHOHOHOHOHOHOHOHOHOHOHOHOHOHOHOHOP5HOPHOHPHA7HAHAHPHOHAHAHOHOHAHAHOHOHAHAHOHOHAHAHOHOPPHAPPHOPPHAOPHOA7HAMBPHHAHAMBHOHAHAMBHOHAHAMBHOHAHAMBHOHAHAPBHOPHHAPAHOOHA7HOMBHPHOHOMBHPHOHOMBHOHOHOMBHOHOHOMBHOHOHOMBHOPPHOMBHOOHA7PHOHPHOHP7HOHOHOHOHOHOHOHOHOHOHOHAHOHOHOPAHOHOHOODPPHOPHMHPPBAHOHOPPBAHOHOIDAAHOHOIDAAHOHOIDAAHOHOIDAAHOHOIDAAHOHOIDAAHOHOHOMBHOH2OMBHOH2OMBHOH2OMBHOH2OMBHOH2OMBHOH2OMBOHPHHOMBMDODPPAAHA2PPAAHA3OAAHA3OOHPHOHAOP5APHOHOHOMHHOHOHOODHOHOHAPHHOPPAPHAHOHOAOHAHOHOHOHAHOHOHOHAHGHOHOHAPPHOPPHAOPHOOHA7IDAAHOHOIDAAHOHOIDAAHOHOIDAAHOHOIDAAHOHHIDAAP2DIDAAOHOBA7HOMBOHMBHOMBHOMBHOMBHOMBHOMBHOMBHOMBHOMBP2BHOMBOPPAHOMBA7PAIPHOHAHAOPHOHAHAHOHOHOHAHOHOHOHAHOHOHOP9OPPHOHA8OAAMDA2OAAODA2OAAOA2OPOHPDOP5DPPHOHOOAHOHOHOOAHOHOPPOAHOHAHAOAHAHAHAOAHAHA4HAPHHAOAHOPPHAOAHOHOHAOAHOHOHAOAHOHOHAOAPHHA6HA6HA6HAP2APHHAP2BPPHAHOMBHOHAHOMBHOHAHOMBHOA23OHPHOPPDP6HHOHOHOH2OHOHOH2OHOHOHAHOPPOAHOHOHAOAHOHOHOOAHOHOHOOAHOHOHOOAHOP3OAPPOPOHOAOPA6OHOHAOAPDHOHAOAPHHOHAOAHOHOHAOAHOHOHAOAHOHOHAOAHOHOHAOAHOA3OA2HAHOMBHOHAHOMBHOHAHOMBHOHAHOMBHOHAHOMBHOHAHOMBHOHAHOMBHOA7HOHOHOHAHOHOHOHAHOHOHOHAHOHOHOHAHOHOHOHAP5HAOHPHOPHA2HAAOA7HOA5PPA5OHA43PA6PA6HA108HAAOA3HAAOA3HAAOA43OA6OA6OA4OHPDHOHOP2DHOHOHOOAHOHOHAOAHOHOPAOAHOHOA23HOMBHOHOHOMBHOHOHOMBHOHOHOMBHOHOHOMBHOHOAAHAOA4HAOA4HAHA2PPHA4PPHA2MAAOHA2MAAOHA2PDAPHA2PDA5OHA5PPA5HOA5HOA6OA6PAAPDAAIHAAPDAAMDODOAHOHOMHOAHOHOAPOAHOHOAOOAHOHOHOOAHOHGPPOBP2HOHMBOPODA7HOMBOHHOHOMBMDHOHOMBOHHOHOMBHOHOHOMBHOP4BHOOPOPPAHOAOA6OMHHA2MAODHA2MAPAHA4HAHA4HA6PPHA4PPHA18OBA5OA6OA8OA2HAOAOA2HAOAHA2HAOA78HOA5PPA5OHA167OHIHOHOHPPMHP3HOOHHOHOHOPHHOHOHOHHAOAOHOAHAPAOHOAHMHIHHOAHODIPHA2PPOHHA2P3HA2HOHOHOAAHOHOHOAAHAHAHOAAHAHAHOAAPHPDPPBAP2HPPOHOHAAP5AAHOHOHOAAHOHOHOA2OHOHOA2PHOHOAAIHOHHOHAMDP3HAIBMPDAAOMDOPHAAOGGHAOAAPAADAMAAHOHDLNAAHPPLPNAIHHOLJNAIDHOLJNAMDHOAHPAAOHOAHHAAOHOAHHAHOHOAHHAHOHOAHHAHOPPAHP3OHAHPPOHA7OPBAAOHOAOA2OHOAOAAHOHOAOAAHOHOAOAAHOHOAOAAP3AOAAOHOHA7OBHOOPHAOAHOAOAAOAHOAOAAOAHOHOAAOAHOHOHAOAP3HAOAOHOHHA8HOLJNAMBHOLPNAMBHODLPAOAHODAHAOAHOHA2PAPPOPBAHAOHMPBAHA1032"
local raw = "0800020e7f7e7f7ffffffff7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7eff707efff7707effefe77effffff7e70707e7e70707e7e70707e7e70707e7ef3f370fff3f37fff70c17e7070c17e7070c17e7070c17e7070c17e7070c17e7070c1f77070c1f370fff07ee7fff17eff7ec17e7e7ec1fe7e7ec1fe7e7ec1ff7e7ec1ff7e7ec1ff7eff7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7effffff7ef7e7f70000000070707f7e70707e7e70707e7e70707e7e70707e7eff70ff7eff70ef7e0000000070c1f77070c17e7070c17e7070c17e7070c17e7070f17ef770f07ee7000000007ec17f7e7ec17f7e7ec17e7e7ec17e7e7ec17e7e7ec17eff7ec17ee700000000f7e7f7e7ffffffff7e7e7e7e7e7e7e7e7e7e7e707e7e7ef07e7e7ee3ff7ef7c7ff107e7eff107e7e83007e7e83007e7e83007e7e83007e7e83007e7e83007e7e7ec17e777ec17e777ec17e777ec17e777ec17e777ec17e777ec1e7f77ec1c3e3ff007000ff0070000e0070000ee7f7e70effffff0f7e7e7ec77e7e7ee37e7e70f77eff0f707e7e0e707e7e7e707e7e7e70767e7e70ff7eff70ef7ee70000000083007e7e83007e7e83007e7e83007e7e83007e778300fff38300e7e1000000007ec1e7c17ec17ec17ec17ec17ec17ec17ec17ec1fff17ec1eff07ec100000000f08f7e7070ef7e70707e7e7e707e7e7e707e7e7effffffffffeff7e7000000000e00c3000e00e3000e00e000efe7f3effffff3ff7e7ee07e7e7ee07e7effe07e7070e0707070e07070000070f770e07eff70e07e7e70e07e7e70e07e7e70e0f770000000700000007000000070fff0f770fff1ff707ec17e707ec17e707ec17e000000000000000000000000e7f7eff3fffffff77e7e7e777e7e7e777e7e7e707effe07e7e70e07e7e7ee07e7e7ee07e7e7ee07effffe0ffefe7e0ef0000000e7e70e0f37e70e0f77e70e07e7e70e07e7e70e07e7e70e07e7e70e07e0000e000707ec17e707ec17e707ec17e707ec17e707ec17e707ec17e707ec17e000000007e7e7e707e7e7e707e7e7e707e7e7e707e7e7e70ffffff70e7f7ef7000700e000000007e000000ff000000e700000000000000000000000000000000000000000000f0000000f000000070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000700e0000700e0000700e00000000000000000000000000000000000000000000e0000000e0000000e00000e7f37e7efff37e7e7ee07e7e70e07e7ef0e07e7e0000000000000000000000007ec17e7e7ec17e7e7ec17e7e7ec17e7e7ec17e7e0070e0000070e00000707000ff700000ff7000c00e7000c00e7000f30f7000f3000000e7000000ff0000007e0000007e0000000e0000000f00f3008700f300c3e3e07e7ec7e07e7e0fe07e7e0ee07e7e7ee07e76ffe1fff7e7c1efe3000000007ec1e77e7ec1c37e7ec1e77e7ec17e7e7ec17efffff17eefeff07e0e0000000ec77000c0e37000c0f07000007070000070000000ff700000ff70000000000000000000e1000000e0000000e000000000e00070e0e00070e0700070e00000000000000000000000000000000000000000000000000000000000000000000000000000007e000000ff000000e7000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000e787e7e7ffc7ffff7ee77e7e7ef77e7e7e770e0e7e070f0e7e07c7877e07e38f7000ffe77000ffff70007e7e7e007e7e7e0070707e0070707e00f7f3ff10fff7ffe7e700ffffff007e7e7e007e7e7e000e7e7e000f7e7e0087e77e70c3ffff7081cf300ec3ef700e6670e00f0030c007e73bd007ffbfd0877eb9d0837eb9d0c37e07f00e7e07700e7e07707e7e07707e7e07707eff07ffffe707ffe700000000ef100e7e0e000e7e0e007e7e0e007e7e0e007e7e0e00ffff0e00e7e700000000e17eef70e07e0e00e07e0e00e07e7e00e07e7e70e0ffff70e0e7e770000000007eb9d0c17ebfd0c17e3bf0e07e3070e07e7000f0ffef1070e7cf1070000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000"

-- font data {"A", sprite number, page?, num sprites x, y, width (px), height}
fontd={	{0,0,1,2,8,16},{1,0,1,2,8,16},{2,0,1,2,8,16},{3,0,1,2,8,16},{4,0,1,2,8,16},{5,0,1,2,8,16},{6,0,1,2,8,16},{7,0,1,2,8,16},{8,0,1,2,3,16},{9,0,1,2,5,16},{10,0,1,2,8,16},{11,0,1,2,7,16},{12,0,2,2,13,16},{14,0,1,2,8,16},{15,0,1,2,8,16},
		{128,0,1,2,8,16},{129,0,1,2,8,16},{130,0,1,2,8,16},{131,0,1,2,8,16},{132,0,2,2,9,16},{134,0,1,2,8,16},{135,0,1,2,8,16},{136,0,2,2,13,16},{138,0,1,2,8,16},{139,0,1,2,7,16},{140,0,1,2,8,16},{141,0,1,2,8,16},{142,0,1,2,8,16},{143,0,1,2,8,16},
		{256,0,1,2,8,16},{257,0,1,2,8,16},{258,0,1,2,6,19},{259,0,1,3,8,16},{260,0,1,2,8,16},{261,0,1,2,3,19},{262,0,1,3,4,16},{263,0,1,2,8,16},{264,0,1,2,3,16},{265,0,2,2,13,16},{267,0,1,2,8,16},{268,0,1,3,8,19},{269,0,1,3,8,19},{270,0,1,3,8,16},{271,0,1,2,7,16},
		{448,0,1,2,8,16},{449,0,1,2,6,16},{450,0,1,2,8,16},{451,0,1,2,8,16},{452,0,2,2,13,16},{454,0,1,2,8,19},{455,0,1,3,8,16},{456,0,1,2,8,16},{457,0,1,2,3,16},{458,0,1,2,4,16},{459,0,1,2,6,16},{460,0,1,2,4,16},{461,0,1,2,6,16},{462,0,1,2,3,16},{463,0,1,2,8,16},
		{640,0,1,2,8,16},{641,0,1,2,7,16},{642,0,1,2,8,16},{643,0,1,2,8,16},{644,0,2,2,9,16},{646,0,1,2,8,16},{647,0,1,2,8,16},{648,0,1,2,8,16},{649,0,1,2,8,16},{650,0,1,2,8,16},{651,0,1,2,3,16},{652,0,1,2,8,16},{653,0,2,2,12,16},{655,0,1,2,8,16},
		{768,0,1,2,8,16}
	}

-- this could be useful for compression later
font = {}
chars="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!'+,-.?0123456789:=@/ "

-- the rle decoder
function tomemrle(str)
  local o=tonumber(str:sub(1,5),16) -- get (o)ffset
  local w=tonumber(str:sub(6,7),16)*8-1 -- get (w)idth
  local e=str:sub(8,str:len()) -- remove header to get (e)ncoded data
  local d = "" -- (d)ecoded data
  for m, c in e:gmatch("(%u+)([^%u]+)") do -- decode rle, (m)atch & (c)ounter
    d = d .. m .. (m:sub(-1):rep(c))  
  end
  local y=0
  for x = 1,#d,1 do -- write to mem
    local c=string.byte(d:sub(x,x))-65 -- get (c)olor value
    poke4(o+y,c) y=y+1
    if y>w then y=0 o=o+1024 end
  end
end

-- the raw decoder
function tomemraw(str)
	local tnb=tonumber
	local o=tnb(str:sub(1,5),16) -- get (o)ffset
	local w=tnb(str:sub(6,7),16)*8-1 -- get (w)idth
	local d=str:sub(8,str:len()) -- remove header to get (d)ata
	local y=0
	for x = 1,#d,1 do -- write to mem
	  local c=tnb(d:sub(x,x),16) -- get (c)olor value
	  poke4(o+y,c) y=y+1
	  if y>w then y=0 o=o+1024 end
	end
  end

function font_init()
	for i=1,#fontd do
		font[string.sub(chars,i,i)] = fontd[i]
	end
end

function flength(txt,kx)
	kx = kx or 1
	pcx = 0
	letter ={}
	for i=1,string.len(txt) do
		letter = font[string.sub(txt,i,i)]
		-- update kerning
		pcx = pcx + letter[5] + kx
	end
	return pcx
end

-- fprint ("text", x, y, [x kerning = 1],[y kerning = 1], [colour = 15])
function fprint(txt,tx,ty,kx,ky,tc)
	kx = kx or 1
	ky = ky or 1
	tc = tc or 10
	pcx = 0
	pcy = 0
	letter ={}
	-- set to blit segment (8 = BG-1)
	poke4(2*0x03ffc,8)
	-- set colour
	poke4(2*0x03FF0 + 1, tc)
	-- print each letter
	for i=1,string.len(txt) do
		letter = font[string.sub(txt,i,i)]
		spr(letter[1],tx+pcx,ty+pcy,0,1,0,0,letter[3],letter[4])

		-- update kerning
		pcx = pcx + letter[5] + kx
	end
end

function TIC()
    -- initialize
    cls(0)
    tomemrle(rle)
    font_init()
    -- some text
    local tl = {"ABCDEFGHIJKLMOPQRSTUVWXYZ","Zabcdefghijklmnopqrstuvwxyz","@0!1'2+3,4-5.6/7:8=9?","Hast Du nicht gesehen!"}
    local tl = {"THE QUICK BROWN","FOX JUMPS OVER", "?THE L@ZY DOG!", "42.AGO / 21:GUNS", "RIFT -IS- BACK"}
    local tl = {"This is the new style!","Nucampi 8x16,","is here to stay.","@ready for the","FUNKY SHIT?"}
    local tlg
	-- draw text
	for i=1,#tl do
		-- get length
		tlg = flength(tl[i])
		-- draw line of text
		fprint(tl[i],120-(tlg/2),50+(20*(i-#tl/2)))
	end
end

-- <PALETTE>
-- 000:1a1c2c5d275db13e53ef7d57ffcd75a7f07038b76425717929366f3b5dc941a6f673eff7f4f4f494b0c2566c86333c57
-- </PALETTE>

-- <TILES>
-- 000:e7f7e7f7ffffffff7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7eff707efff7707e
-- 001:ffefe77effffff7e70707e7e70707e7e70707e7e70707e7ef3f370fff3f37fff
-- 002:70c17e7070c17e7070c17e7070c17e7070c17e7070c17e7070c1f77070c1f370
-- 003:fff07ee7fff17eff7ec17e7e7ec1fe7e7ec1fe7e7ec1ff7e7ec1ff7e7ec1ff7e
-- 016:ff7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7e7effffff7ef7e7f700000000
-- 017:70707f7e70707e7e70707e7e70707e7e70707e7eff70ff7eff70ef7e00000000
-- 018:70c1f77070c17e7070c17e7070c17e7070c17e7070f17ef770f07ee700000000
-- 019:7ec17f7e7ec17f7e7ec17e7e7ec17e7e7ec17e7e7ec17eff7ec17ee700000000
-- 032:f7e7f7e7ffffffff7e7e7e7e7e7e7e7e7e7e7e707e7e7ef07e7e7ee3ff7ef7c7
-- 033:ff107e7eff107e7e83007e7e83007e7e83007e7e83007e7e83007e7e83007e7e
-- 034:7ec17e777ec17e777ec17e777ec17e777ec17e777ec17e777ec1e7f77ec1c3e3
-- 035:ff007000ff0070000e0070000ee7f7e70effffff0f7e7e7ec77e7e7ee37e7e70
-- 048:f77eff0f707e7e0e707e7e7e707e7e7e70767e7e70ff7eff70ef7ee700000000
-- 049:83007e7e83007e7e83007e7e83007e7e83007e778300fff38300e7e100000000
-- 050:7ec1e7c17ec17ec17ec17ec17ec17ec17ec17ec1fff17ec1eff07ec100000000
-- 051:f08f7e7070ef7e70707e7e7e707e7e7e707e7e7effffffffffeff7e700000000
-- 064:0e00c3000e00e3000e00e000efe7f3effffff3ff7e7ee07e7e7ee07e7effe07e
-- 065:7070e0707070e07070000070f770e07eff70e07e7e70e07e7e70e07e7e70e0f7
-- 066:70000000700000007000000070fff0f770fff1ff707ec17e707ec17e707ec17e
-- 067:000000000000000000000000e7f7eff3fffffff77e7e7e777e7e7e777e7e7e70
-- 080:7effe07e7e70e07e7e7ee07e7e7ee07e7e7ee07effffe0ffefe7e0ef0000000e
-- 081:7e70e0f37e70e0f77e70e07e7e70e07e7e70e07e7e70e07e7e70e07e0000e000
-- 082:707ec17e707ec17e707ec17e707ec17e707ec17e707ec17e707ec17e00000000
-- 083:7e7e7e707e7e7e707e7e7e707e7e7e707e7e7e70ffffff70e7f7ef7000700e00
-- 096:0000007e000000ff000000e70000000000000000000000000000000000000000
-- 097:0000f0000000f000000070000000000000000000000000000000000000000000
-- 098:0000000000000000000000000000000000000000000000000000000000000000
-- 099:00700e0000700e0000700e000000000000000000000000000000000000000000
-- 112:00e0000000e0000000e00000e7f37e7efff37e7e7ee07e7e70e07e7ef0e07e7e
-- 113:0000000000000000000000007ec17e7e7ec17e7e7ec17e7e7ec17e7e7ec17e7e
-- 114:0070e0000070e00000707000ff700000ff7000c00e7000c00e7000f30f7000f3
-- 115:000000e7000000ff0000007e0000007e0000000e0000000f00f3008700f300c3
-- 128:e3e07e7ec7e07e7e0fe07e7e0ee07e7e7ee07e76ffe1fff7e7c1efe300000000
-- 129:7ec1e77e7ec1c37e7ec1e77e7ec17e7e7ec17efffff17eefeff07e0e0000000e
-- 130:c77000c0e37000c0f07000007070000070000000ff700000ff70000000000000
-- 131:000000e1000000e0000000e000000000e00070e0e00070e0700070e000000000
-- 144:0000000000000000000000000000000000000000000000000000000000000000
-- 145:0000007e000000ff000000e70000000000000000000000000000000000000000
-- 146:0000000000000000000000000000000000000000000000000000000000000000
-- 147:0000000000000000000000000000000000000000000000000000000000000000
-- 160:e787e7e7ffc7ffff7ee77e7e7ef77e7e7e770e0e7e070f0e7e07c7877e07e38f
-- 161:7000ffe77000ffff70007e7e7e007e7e7e0070707e0070707e00f7f3ff10fff7
-- 162:ffe7e700ffffff007e7e7e007e7e7e000e7e7e000f7e7e0087e77e70c3ffff70
-- 163:00cf300e00ef700e0070e00f0030c007f33bd007f3bfd08700b9d08300b9d0c3
-- 176:7e07f00e7e07700e7e07707e7e07707e7e07707eff07ffffe707ffe700000000
-- 177:ef100e7e0e000e7e0e007e7e0e007e7e0e007e7e0e00ffff0e00e7e700000000
-- 178:e17eef70e07e0e00e07e0e00e07e7e00e07e7e70e0ffff70e0e7e77000000000
-- 179:f3b9d0c1f3bfd0c1003bf0e0003070e0007000f000ef107000cf107000000000
-- </TILES>
