DOUBLE_HEIGHT   equ 0
TEXTYPOSMAX     equ 16

    MAC TWELVECHAR_LOGIC
twelvecharLogic
DoScroller
    ;bouncie!
#if 0
    lda beat
    asl
    and #$1F
    tax
    lda SinTab+32,X
    lsr
    lsr
    adc #4
#else
    lda frame
    and #63
    tax
    lda SinTab64,X
    asl
    eor #$80
    lsr
    lsr
    lsr
    lsr
#endif
    sta textypos

    lda frame
    and #7
    beq LoadNewChar
    rts
LoadNewChar

    lda txtdel
    beq RestartDecoder
    rts

    ;huffman decoder
RestartDecoder
    lda #NSYM
    sta huffnsym
    lda #0
    ;sta REFP0       ;reset due to reflected Harry
    sta huffofs
    sta huffsym
NextBit
    dec nbits
    bpl BitsOK

    ;load next byte from stream, rewind if past TextEnd
    inc huffptr
    bne HuffPtrNoCarry
    inc huffptr+1
HuffPtrNoCarry
    ;check if pointer ran past end
    lda huffptr+1
    cmp #>TextEnd
    bcc HuffPtrOK
    lda huffptr
    cmp #<TextEnd
    bcc HuffPtrOK
HuffPtrInitial
    lda #<(TextStart-1)
    sta huffptr
    lda #>(TextStart-1)
    sta huffptr+1
    bne RestartDecoder  ;resync

HuffPtrOK
    ;seven bits
    lda #6
    sta nbits
    ldy #0
    lda (huffptr),Y
    sta bits
BitsOK
    ldx huffofs
    ldy huffnsym
    lda HuffTab,X
    sta huffnsym    ;if (bit == 1) huffnsym = HuffTab,X
    lsr bits
    bcc BitZero

    ;bit == 1
    inx
    stx huffofs
    bne FinishDecoding

BitZero
    txa
    adc huffnsym    ;HuffTab,X
    sta huffofs
    lda huffsym
    adc huffnsym    ;HuffTab,X
    sta huffsym
    tya
    sec
    sbc huffnsym    ;HuffTab,X
    sta huffnsym    ;if (bit == 0) huffnsym -= HuffTab,X

FinishDecoding
    ;A == huffnsym
    ;if 1 -> done
    cmp #1
    bne NextBit

    echo "Huffman decoder:",(*-LoadNewChar)d
    ;shift charptrs
    ldx #0
ShiftCharPtrs
    lda charptr+2,X
    sta charptr,X
    inx
    cpx #22
    bne ShiftCharPtrs

    ;huffsym = the decoded symbol. convert it to a pointer
#if FONTSZ > 1024
    echo "Font must be < 1 KiB"
    ERR
#endif
#if FONTSZ > 512
    ldx #0
#endif
    lda huffsym
    asl
    asl
#if FONTSZ > 512
    bcc SymOK
    inx
    inx
SymOK
#endif
    asl
    sta charptr+22
#if FONTSZ > 512
    txa
    adc #>Glyph0
#else
    lda #>Glyph0
    adc #0
#endif
    sta charptr+23

    rts
    ENDM

TEXTCLR equ $60
    MAC TWELVECHAR_KERNEL
DrawBar
    ldx #3
TopBar0
    sta WSYNC
    txa
    asl
    eor #TEXTCLR + $0E
    sta COLUBK
    dex
    bpl TopBar0

    ldx #7
TopBar1
    sta WSYNC
    txa
    asl
    ora #TEXTCLR
    sta COLUBK
    dex
    bpl TopBar1
    rts

twelvecharKernel
    jsr DrawBar

    lda #$06
    sta NUSIZ0
    sta NUSIZ1
    lda #TEXTCLR + $0E
    sta COLUP0
    sta COLUP1

    lda textypos
    clc
    adc #4
    tax
    jsr Burn

    ldx #%11111100
#if DOUBLE_HEIGHT
    lda #CHARH*2-1
    sta temp+1
#else
    ldy #CHARH-1
#endif
twelvecharKernelLoop
    lda #$80
    sta HMP0
    sta HMP1
    ;cy 66

#if DOUBLE_HEIGHT
    lda temp+1
#endif

    sta WSYNC
    sta HMOVE           ;right 8 pixels

#if DOUBLE_HEIGHT
    lsr
    tay
#else
    SLEEP 5
#endif

    lda (charptr+2),Y
    sax GRP0
    lda (charptr+6),Y
    sax GRP1
    lda (charptr+10),Y
    sax GRP0
    lda (charptr+14),Y
    sax GRP1
    lda (charptr+18),Y
    sax GRP0
    lda (charptr+22),Y
    sax GRP1
    sax GRP0

#if DOUBLE_HEIGHT
    SLEEP 9
#else
    SLEEP 8
#endif

    sta HMCLR   ;I found a video that explains how this works:
    sta HMOVE   ;http://www.youtube.com/watch?v=x0yQg8kHVcI

    SLEEP 6

    lda (charptr+0),Y
    sax GRP0
    lda (charptr+4),Y
    sax GRP1
    lda (charptr+8),Y
    sax GRP0
    lda (charptr+12),Y
    sax GRP1
    lda (charptr+16),Y
    sax GRP0
    lda (charptr+20),Y
    sax GRP1
    sax GRP0

#if DOUBLE_HEIGHT
    dec temp+1
#else
    dey
#endif
    bpl twelvecharKernelLoop
    CHECK_ALIGN twelvecharKernelLoop

    lda #TEXTYPOSMAX+1
    sec
    sbc textypos
    tax
twelveCharBurn
    sta WSYNC
    lda #0
    sta GRP0
    sta GRP1
    sta GRP0
    dex
    bne twelveCharBurn

    jsr DrawBar

    lda #0
    sta WSYNC
    sta COLUBK
    sta PF1
    sta PF2

    rts
    ENDM
