    processor 6502
    include vcs.h
    include sleep.h
    include macro.h

    ;Checks whether * and {1} reside on the same page
    MAC CHECK_ALIGN
    IF >{1} - >*
        ;I can't figure out how to print the actual label, so have DASM fail here and print it
        ECHO {1} not aligned
        ERR
    ENDIF
    ENDM

;FPS = 50 or 60
;PAL = 0 or 1
#if FPS==50         ;PAL
VBLNK   equ 48
LINES   equ 228
OVERSCN equ 35
#else               ;NTSC
VBLNK   equ 40
LINES   equ 192
OVERSCN equ 30
#endif

BPM     equ 140
TEMPO   equ (128*8*BPM)/(60*FPS)
SONGDBG equ 0

SCREENSPLIT equ 13  ;number of T1024T to wait before switching to text splitty
                    ;must be <= 18

ROTOLINES   equ 10 ;15
HORIZ       equ 24

;Muzak          intro?  loop?   X/10?   kommentar
; Antifocal     J       J       8       rätt mycket fart, mäktig bas, baktakten är lite eljest
; Banane                        0       redan använd i 40years
; BouncyCat     nja     J       4       långsammare, inte jätteintressant
; Crapaud       J       J       8       spoopy
; Dentag        nja     J       6       aggressiv, mycket bas o trummor. inte så lättsam
; DinerDeTom                    0       tom's diner! ej lämplig :»
; Distiranbiek          N       4       gladare, mycket falskt
; DixVeauxMongoles              0       redan använd, i music cart
; Elmer         J       J       3       sisådär
; Floutch       J       J       7       funktionabel
; Github                N       7       rätt enkel, men kan funka
; Olidez J       J       7       helt OK, lite långsam? kan funka med högre tempo
; HellYes               J       5       kort, men lovande
; Madniz        N       J       0/8     redan använd, fast den är rätt bra
; Manchu        J       J       8       rätt bra, har en soft känsla
; Mizirloo      J       J       0/8     är en cover. fast en bra cover! "Misirlou" is a traditional song from the Eastern Mediterranean region
; Olidez        J       J       8       bra bas, bra melodi
; Ovouca                        4       bluh
; PaleAle                       5       maaaybe?
; Sheitan               N       5       underlig melodi
; SmellLikeDNB  J       J       8       nirvana dnb cover :D men lite buzy
; SpaceCake                     4       hmm, 2slow
; Vizirette     N       J       6       inte dålig, men inte så intressant
; WeirdDwarf                    2       weird indeed
; ZommerLiebe                   6       summer loving?
; 
;Ronde zwei, gefighten!!! Alles 5 und über
; 
;Muzak          intro?  loop?   X/10?   kommentar
; Manchu        J       J       8
; Floutch       J       J       7       melodin lite sämre än manchu
; Github                N       5       den tar sig lite när trummorna kommer, menäää. lång dock
; Olidez J       J       7       soft
; SmellLikeDNB  J       J       8       Lead2 volym måste sänkas en smula, till säg 2-3
; Mizirloo      J       J       6       tonläget funkar, men är något för kort
; Olidez        J       J       9       unz unz
; PaleAle                       5       meh
; Vizirette     N       J       6       lång men simpel
; ZommerLiebe                   6       simpel
; Antifocal     J       J       9       is good
; Crapaud       J       J       7       2spooky
; Dentag        nja     J       6       hyffsat rörig
; 
;Die dritte ronde
;
;Muzak          intro?  loop?   X/10?   kommentar
; SmellLikeDNB  J       J       8
; Antifocal     J       J       9       går att lyssna utan att bli trött
; Mizirloo      J       J               skulle funka med ett medelhavstema
; Olidez J       J       9       trevlig, lagom soft, rätt lång
; Crapaud       J       J       7       ze spooky one
; Olidez        J       J       9       det är lite "summer greetings" över den
; Manchu        J       J       6       känns meh nu
; Floutch       J       J       7
;
;Final four!
;
;Muzak          intro?  loop?   X/10?   kommentar
; Olidez        J       J       
; SmellLikeDNB  J       J       7
; Antifocal     J       J       
; Olidez        J       J       8



    ;RAM
    SEG.U VARS
    org $80

frame   ds  1

    ;GlafonkyShit3 or Olidez
    include "Olidez_variables.asm"
temp        equ tt_ptr  ;2 bytes
huffsym     equ temp+0
huffnsym    equ temp+1
huffofs     ds  1
charptr     ds  24
textypos    ds  1
huffptr     ds  2
bits        ds  1
nbits       ds  1

x0      ds  1
dx      ds  1
dx0     ds  1
y0      ds  1
dy      ds  1
dy0     ds  1
xx      ds  1
yy      ds  1
curline ds  1
pf1next ds  1
pf2next ds  1
grp0nxt ds  1
texptr  ds  2

x0s     ds  ROTOLINES
y0s     ds  ROTOLINES

; Weird variants:
;
;  0 - normal rotozoomer
;  1 - wavey
;  2 - rotozoomer with dx opposite sign, squishy
;
weird   ds  1
lastpat ds  1   ;for detecting when patterns change
patcnt  ds  1
txtdel  ds  1   ;delay in patterns before starting scroller

    echo "RAM:", ($100 - *)d, "bytes left"

    include twelvechar.asm
    include build/font.asm

    ;ROM
    SEG CODE
    org $1000
    TEXTURES
    echo "Textures:",(*-Textures)d,"(includes ",(TextEnd-Textures)d,"B text)"

    FONT
FONTSZ  equ *-Glyph0
    echo "Font:",(FONTSZ)d,"bytes"

    include build/sintab.asm

    TWELVECHAR_KERNEL

#if 0
bitMaskArray
    byte #%10000000
    byte #%01000000
    byte #%00100000
    byte #%00010000
    byte #%00001000
    byte #%00000100
    byte #%00000010
    byte #%00000001
#endif

    include utils.asm


    TWELVECHAR_LOGIC

Start
    CLEAN_START

    include "Olidez_init.asm"

    lda #<(TextStart-1)
    sta huffptr
    lda #>(TextStart-1)
    sta huffptr+1

    ldx #22
Initcharptr
    lda #<GlyphSpace
    sta charptr,X
    lda #>GlyphSpace
    sta charptr+1,X
    dex
    dex
    bpl Initcharptr

    lda #14
    sta txtdel

MainLoop
    lda INTIM
    bne MainLoop

    lda #(OVERSCN-2)*19/16
    sta TIM64T
    lda #2
    sta VBLANK

    inc frame

Player
    include "Olidez_player.asm"
    echo "Player:",(*-Player)d

WaitForOverscanEnd
    lda INTIM
    bpl WaitForOverscanEnd

    ;VERTICAL_SYNC
    lda #%1110         ; each '1' bits generate a VSYNC ON line (bits 1..3)
VSLP1
    sta WSYNC           ; 1st '0' bit resets Vsync, 2nd '0' bit exit loop
    sta VSYNC
    lsr
    bne VSLP1           ; branch until VYSNC has been reset

    lda #(VBLNK-2)*19/16-1
    sta TIM64T

    lda tt_cur_pat_index_c0
    cmp lastpat
    beq NoPatChange
    sta lastpat
    inc patcnt
    lda txtdel
    beq NoPatChange
    dec txtdel
NoPatChange

    lda #$07
    sta NUSIZ0      ;quad sized player

    ldx #0
    lda #82
    jsr PositionObject

    lda frame ;angle
    lsr
    lsr
    tax
    lda SinTab64,X
    sta dx
    sta dy0

    txa
    clc
    adc #16
    and #63
    tax
    lda SinTab64,X
    sta dx0
    eor #$FF
    sta dy

    lda #0
    sta PF0
    sta x0
    lda #$40
    sta y0

    ldx #ROTOLINES-1
PrecomputeX0Y0
    lda x0
    clc
    adc dx0
    sta x0
    sta x0s,X
    lda y0
    clc
    adc dy0
    sta y0
    sta y0s,X

    dex
    bpl PrecomputeX0Y0

    lda patcnt
    lsr
    lsr
    lsr
    and #3
    clc
    adc #>Textures
    sta texptr+1

    ;weirdness = {0, 1, 2, 1} and so on
    lda patcnt
    lsr
    and #3
    cmp #3
    bne WeirdOK
    lda #1
WeirdOK
    sta weird
    tay
    ldx #HORIZ-1
    lda #0
ComputeHoriz
    pha
    cpy #2
    beq DoWeird2Tab
    sec
    sbc dx
    jmp DoneWeirdTab
DoWeird2Tab
    clc
    adc dx
DoneWeirdTab
    dex
    bpl ComputeHoriz

    lda #$02
    sta CTRLPF      ;score

    lda #$0E
    sta COLUP0

    lda #0
    sta VDELP0
    sta VDELP1
    sta COLUP1

    jsr twelvecharLogic

WaitForVblankEnd
    sta WSYNC
    lda INTIM
    bpl WaitForVblankEnd

    lda #0
    sta WSYNC
    sta HMOVE
    sta VBLANK
    lda #SCREENSPLIT
    sta T1024T

    ;NOTE: Don't set COLUBK before VBLANK has been turned off (above)
    ;      Otherwise you get ugly colors for the first few lines

#if 0
    sta WSYNC
    lda #$B0
    sta COLUBK
    sta WSYNC
    sta WSYNC
    lda #$B2
    sta COLUBK
    sta WSYNC
    sta WSYNC
    lda #$B4
    sta COLUBK
    sta WSYNC
    lda tt_cur_pat_index_c0
    asl
    adc #$20
    sta COLUBK
    lda tt_cur_pat_index_c1
    asl
    adc #$20
    sta COLUP1
    sta WSYNC
#endif

    lda weird
    and #1
    beq GotoWeird0
    jmp RotoTexWeird1
GotoWeird0
    jmp RotoTexWeird0

RotoTexKernelDone
    ldx #3
    jsr Burn
    lda #0
    sta PF1
    sta PF2
    sta GRP0
    ldx #$FF
    txs

#if 0
    sta WSYNC
    sta WSYNC
    sta WSYNC
    lda #$B2
    sta COLUBK
    sta WSYNC
    sta WSYNC
    lda #$B0
    sta COLUBK
    sta WSYNC
    sta WSYNC
    lda #$00
    sta COLUBK
#endif

MiddleLoop
    lda INTIM
    bne MiddleLoop
    lda #19-SCREENSPLIT
    sta T1024T

    sta WSYNC

    ; reflected playfield
    lda #$01
    sta CTRLPF
    lda #%00110000
    sta PF0

#if 1                   ;set to zero for pixel scrolling - it actually looks worse
TEXTX   equ 35
    lda #TEXTX
    ldx #0
    jsr PositionObject
    lda #TEXTX+16
#else
TEXTX   equ 32
    lda frame
    and #7
    eor #7
    clc
    adc #TEXTX
    ldx #0
    jsr PositionObject
    lda frame
    and #7
    eor #7
    clc
    adc #TEXTX+16
#endif
    inx
    stx VDELP0
    stx VDELP1
    jsr PositionObject

    sta WSYNC
    sta HMOVE

    jsr twelvecharKernel

    jmp MainLoop

Burn
    sta WSYNC
    dex
    bne Burn
    rts

Song
    include "Olidez_trackdata.asm"
    echo "Song:", (*-Song)d

RotoTexWeird0
    lda #ROTOLINES-1
    sta curline
RotoTexKernel
    ldy curline
    lda x0s,Y
    sta xx
    ldx #$FF-HORIZ
    txs
    ldx y0s,Y

    ;must have xx in A before entering
    MAC INNERPF
    pla
    adc xx
    lsr
    lsr
    lsr
    lsr
    tay
    sta COLUP0

    txa
    adc dy
    tax

    and #$F0
    sta texptr
    lda (texptr),Y
    rol

    {1}
    ENDM

    INNERPF rol pf1next
    INNERPF rol pf1next
    INNERPF rol pf1next
    INNERPF rol pf1next
    INNERPF rol pf1next
    INNERPF rol pf1next
    INNERPF rol pf1next
    INNERPF rol pf1next

    INNERPF ror pf2next
    INNERPF ror pf2next
    INNERPF ror pf2next
    INNERPF ror pf2next
    INNERPF ror pf2next
    INNERPF ror pf2next
    INNERPF ror pf2next
    INNERPF ror pf2next

    INNERPF rol grp0nxt
    INNERPF rol grp0nxt
    INNERPF rol grp0nxt
    INNERPF rol grp0nxt
    INNERPF rol grp0nxt
    INNERPF rol grp0nxt
    INNERPF rol grp0nxt
    INNERPF rol grp0nxt

    lda pf1next
    sta PF1
    lda pf2next
    sta PF2
    lda grp0nxt
    sta GRP0

    dec curline
    bmi GotoRotoTexKernelDone
    jmp RotoTexKernel
GotoRotoTexKernelDone
    jmp RotoTexKernelDone


RotoTexWeird1
    lda #ROTOLINES-1
    sta curline
RotoTexKernel1
    ldy curline
    lda x0s,Y
    lsr
    lsr
    lsr
    lsr
    sta xx
    ldx #$FF-HORIZ
    txs
    ldx y0s,Y

    MAC INNERPF1
    ldy xx
    sty COLUP0

    txa
    adc dy
    tax

    and #$F0
    sta COLUP0
    sta texptr
    lda (texptr),Y
    rol

    {1}
    ENDM

    lda #8
    sta temp
InnferPF1Rep
    INNERPF1 rol pf1next
    dec temp
    bne InnferPF1Rep

    lda #8
    sta temp
InnferPF2Rep
    INNERPF1 ror pf2next
    dec temp
    bne InnferPF2Rep

    lda #8
    sta temp
InnferGRP0Rep
    INNERPF1 rol grp0nxt
    dec temp
    bne InnferGRP0Rep

    lda pf1next
    sta PF1
    lda pf2next
    sta PF2
    lda grp0nxt
    sta GRP0

    dec curline
    bmi GotoRotoTexKernelDone1
    jmp RotoTexKernel1
GotoRotoTexKernelDone1
    jmp RotoTexKernelDone

    HUFFTAB

    echo "ROM:", ($1FFC - *)d, "bytes left"

    org $1FFC
    .word Start
Delay14
    nop
Delay12
    rts
