; TIATracker music player
; Copyright 2016 Andre "Kylearan" Wichmann
; Website: https://bitbucket.org/kylearan/tiatracker
; Email: andre.wichmann@gmx.de
;
; Licensed under the Apache License, Version 2.0 (the "License");
; you may not use this file except in compliance with the License.
; You may obtain a copy of the License at
;
;   http://www.apache.org/licenses/LICENSE-2.0
;
; Unless required by applicable law or agreed to in writing, software
; distributed under the License is distributed on an "AS IS" BASIS,
; WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
; See the License for the specific language governing permissions and
; limitations under the License.

; Song author: 
; Song name: 

; @com.wudsn.ide.asm.hardware=ATARI2600

; =====================================================================
; TIATracker melodic and percussion instruments, patterns and sequencer
; data.
; =====================================================================
tt_TrackDataStart:

; =====================================================================
; Melodic instrument definitions (up to 7). tt_envelope_index_c0/1 hold
; the index values into these tables for the current instruments played
; in channel 0 and 1.
; 
; Each instrument is defined by:
; - tt_InsCtrlTable: the AUDC value
; - tt_InsADIndexes: the index of the start of the ADSR envelope as
;       defined in tt_InsFreqVolTable
; - tt_InsSustainIndexes: the index of the start of the Sustain phase
;       of the envelope
; - tt_InsReleaseIndexes: the index of the start of the Release phase
; - tt_InsFreqVolTable: The AUDF frequency and AUDV volume values of
;       the envelope
; =====================================================================

; Instrument master CTRL values
tt_InsCtrlTable:
        dc.b $0c, $0c, $06, $04, $0c


; Instrument Attack/Decay start indexes into ADSR tables.
tt_InsADIndexes:
        dc.b $00, $09, $16, $20, $20


; Instrument Sustain start indexes into ADSR tables
tt_InsSustainIndexes:
        dc.b $05, $12, $1c, $25, $25


; Instrument Release start indexes into ADSR tables
; Caution: Values are stored with an implicit -1 modifier! To get the
; real index, add 1.
tt_InsReleaseIndexes:
        dc.b $06, $13, $1d, $26, $26


; AUDVx and AUDFx ADSR envelope values.
; Each byte encodes the frequency and volume:
; - Bits 7..4: Freqency modifier for the current note ([-8..7]),
;       8 means no change. Bit 7 is the sign bit.
; - Bits 3..0: Volume
; Between sustain and release is one byte that is not used and
; can be any value.
; The end of the release phase is encoded by a 0.
tt_InsFreqVolTable:
; 0: Synth
        dc.b $84, $85, $86, $86, $87, $81, $00, $81
        dc.b $00
; 1: Accord
        dc.b $8f, $5e, $5d, $3c, $8b, $5a, $59, $37
        dc.b $82, $80, $00, $80, $00
; 2: bassline
        dc.b $8f, $8f, $8f, $8e, $8b, $87, $83, $00
        dc.b $8f, $00
; 3+4: Lead
        dc.b $8c, $8b, $89, $86, $83, $81, $00, $80
        dc.b $00



; =====================================================================
; Percussion instrument definitions (up to 15)
;
; Each percussion instrument is defined by:
; - tt_PercIndexes: The index of the first percussion frame as defined
;       in tt_PercFreqTable and tt_PercCtrlVolTable
; - tt_PercFreqTable: The AUDF frequency value
; - tt_PercCtrlVolTable: The AUDV volume and AUDC values
; =====================================================================

; Indexes into percussion definitions signifying the first frame for
; each percussion in tt_PercFreqTable.
; Caution: Values are stored with an implicit +1 modifier! To get the
; real index, subtract 1.
tt_PercIndexes:
        dc.b $01, $10


; The AUDF frequency values for the percussion instruments.
; If the second to last value is negative (>=128), it means it's an
; "overlay" percussion, i.e. the player fetches the next instrument note
; immediately and starts it in the sustain phase next frame. (Needs
; TT_USE_OVERLAY)
tt_PercFreqTable:
; 0: KickRegular
        dc.b $03, $01, $03, $04, $05, $05, $06, $07
        dc.b $07, $07, $08, $0a, $0e, $94, $00
; 1: SnareFat
        dc.b $03, $02, $0b, $05, $05, $04, $03, $03
        dc.b $00


; The AUDCx and AUDVx volume values for the percussion instruments.
; - Bits 7..4: AUDC value
; - Bits 3..0: AUDV value
; 0 means end of percussion data.
tt_PercCtrlVolTable:
; 0: KickRegular
        dc.b $ef, $ee, $ed, $ec, $eb, $ea, $e9, $e8
        dc.b $e7, $e6, $e5, $e4, $e3, $e2, $00
; 1: SnareFat
        dc.b $ef, $ef, $6e, $8c, $8a, $88, $86, $84
        dc.b $00


        
; =====================================================================
; Track definition
; The track is defined by:
; - tt_PatternX (X=0, 1, ...): Pattern definitions
; - tt_PatternPtrLo/Hi: Pointers to the tt_PatternX tables, serving
;       as index values
; - tt_SequenceTable: The order in which the patterns should be played,
;       i.e. indexes into tt_PatternPtrLo/Hi. Contains the sequences
;       for all channels and sub-tracks. The variables
;       tt_cur_pat_index_c0/1 hold an index into tt_SequenceTable for
;       each channel.
;
; So tt_SequenceTable holds indexes into tt_PatternPtrLo/Hi, which
; in turn point to pattern definitions (tt_PatternX) in which the notes
; to play are specified.
; =====================================================================

; ---------------------------------------------------------------------
; Pattern definitions, one table per pattern. tt_cur_note_index_c0/1
; hold the index values into these tables for the current pattern
; played in channel 0 and 1.
;
; A pattern is a sequence of notes (one byte per note) ending with a 0.
; A note can be either:
; - Pause: Put melodic instrument into release. Must only follow a
;       melodic instrument.
; - Hold: Continue to play last note (or silence). Default "empty" note.
; - Slide (needs TT_USE_SLIDE): Adjust frequency of last melodic note
;       by -7..+7 and keep playing it
; - Play new note with melodic instrument
; - Play new note with percussion instrument
; - End of pattern
;
; A note is defined by:
; - Bits 7..5: 1-7 means play melodic instrument 1-7 with a new note
;       and frequency in bits 4..0. If bits 7..5 are 0, bits 4..0 are
;       defined as:
;       - 0: End of pattern
;       - [1..15]: Slide -7..+7 (needs TT_USE_SLIDE)
;       - 8: Hold
;       - 16: Pause
;       - [17..31]: Play percussion instrument 1..15
;
; The tracker must ensure that a pause only follows a melodic
; instrument or a hold/slide.
; ---------------------------------------------------------------------
TT_FREQ_MASK    = %00011111
TT_INS_HOLD     = 8
TT_INS_PAUSE    = 16
TT_FIRST_PERC   = 17

; Ia1
tt_pattern0:
        dc.b $3a, $3a, $08, $3a, $08, $3a, $37, $08
        dc.b $08, $08, $37, $08, $37, $08, $37, $08
        dc.b $37, $37, $08, $37, $08, $37, $34, $08
        dc.b $08, $08, $34, $34, $34, $31, $37, $3b
        dc.b $00

; Ia2
tt_pattern1:
        dc.b $3a, $3a, $08, $3a, $08, $3a, $37, $08
        dc.b $08, $08, $37, $08, $37, $08, $37, $08
        dc.b $3b, $3b, $08, $3b, $08, $3b, $3a, $08
        dc.b $00

; Ia3
tt_pattern2:
        dc.b $08, $08, $3a, $08, $3a, $08, $3a, $08
        dc.b $00

; Ia4
tt_pattern3:
        dc.b $08, $08, $3a, $08, $4b, $08, $08, $08
        dc.b $00

; b+d0a1
tt_pattern4:
        dc.b $11, $74, $08, $74, $12, $08, $72, $08
        dc.b $11, $08, $72, $08, $12, $72, $08, $08
        dc.b $11, $72, $08, $72, $12, $08, $70, $08
        dc.b $11, $08, $70, $70, $12, $6d, $70, $72
        dc.b $00

; b+d0a2
tt_pattern5:
        dc.b $11, $74, $08, $74, $12, $08, $72, $08
        dc.b $11, $08, $72, $08, $12, $72, $08, $08
        dc.b $11, $76, $08, $76, $12, $08, $74, $08
        dc.b $11, $08, $74, $08, $12, $74, $74, $08
        dc.b $00

; d0a1
tt_pattern6:
        dc.b $11, $08, $08, $08, $00

; d0a2
tt_pattern7:
        dc.b $11, $ab, $9f, $9a, $00

; d1a1
tt_pattern8:
        dc.b $11, $94, $08, $97, $11, $08, $9a, $08
        dc.b $11, $9b, $08, $9f, $11, $08, $ab, $08
        dc.b $11, $ad, $08, $08, $11, $08, $08, $08
        dc.b $11, $08, $08, $08, $11, $ab, $9f, $9a
        dc.b $00

; d0a3
tt_pattern9:
        dc.b $11, $94, $08, $97, $11, $08, $9a, $08
        dc.b $11, $9b, $08, $9f, $11, $08, $ab, $08
        dc.b $11, $94, $08, $08, $11, $08, $08, $08
        dc.b $11, $08, $08, $08, $11, $08, $08, $08
        dc.b $00

; mel0a1
tt_pattern10:
        dc.b $3a, $3a, $08, $08, $08, $08, $37, $08
        dc.b $08, $08, $08, $08, $08, $08, $08, $08
        dc.b $37, $37, $08, $08, $08, $08, $34, $08
        dc.b $08, $08, $08, $08, $08, $08, $08, $08
        dc.b $3a, $3a, $08, $08, $08, $08, $37, $08
        dc.b $08, $08, $08, $08, $08, $08, $08, $08
        dc.b $3b, $3b, $08, $08, $08, $08, $3a, $08
        dc.b $08, $08, $08, $08, $4b, $08, $08, $08
        dc.b $00

; mel0a2
tt_pattern11:
        dc.b $91, $8f, $8c, $8b, $37, $08, $8c, $37
        dc.b $08, $08, $08, $08, $08, $08, $91, $37
        dc.b $08, $91, $08, $91, $08, $91, $34, $8f
        dc.b $34, $08, $08, $08, $08, $08, $08, $08
        dc.b $91, $8f, $8c, $8b, $08, $08, $8c, $08
        dc.b $37, $08, $37, $08, $37, $08, $91, $08
        dc.b $91, $3b, $91, $08, $91, $94, $3a, $93
        dc.b $08, $3a, $08, $3a, $4b, $08, $08, $08
        dc.b $00

; mel1a1
tt_pattern12:
        dc.b $ab, $37, $ab, $ab, $37, $08, $9f, $08
        dc.b $08, $08, $08, $08, $08, $08, $08, $08
        dc.b $37, $08, $08, $08, $08, $08, $34, $08
        dc.b $08, $08, $08, $08, $08, $08, $08, $08
        dc.b $ab, $37, $ab, $ab, $37, $08, $9f, $08
        dc.b $08, $08, $08, $08, $08, $08, $08, $08
        dc.b $3b, $08, $08, $08, $08, $08, $3a, $08
        dc.b $08, $08, $08, $08, $4b, $08, $08, $08
        dc.b $00

; mel1a2
tt_pattern13:
        dc.b $ab, $37, $ab, $ab, $37, $08, $9f, $08
        dc.b $08, $08, $08, $08, $08, $08, $08, $08
        dc.b $37, $08, $08, $08, $08, $08, $34, $08
        dc.b $08, $08, $08, $08, $08, $08, $08, $08
        dc.b $ab, $37, $ab, $ab, $37, $08, $9f, $08
        dc.b $08, $08, $08, $08, $08, $08, $08, $08
        dc.b $3b, $08, $08, $08, $08, $08, $3a, $08
        dc.b $08, $08, $08, $08, $4b, $08, $9a, $97
        dc.b $00

; mel2a1
tt_pattern14:
        dc.b $94, $37, $9a, $37, $97, $37, $9a, $97
        dc.b $37, $08, $08, $08, $08, $08, $94, $37
        dc.b $91, $37, $08, $8f, $08, $37, $94, $37
        dc.b $91, $34, $08, $8f, $08, $08, $9a, $97
        dc.b $94, $37, $9a, $37, $97, $37, $9a, $97
        dc.b $37, $08, $08, $08, $91, $37, $91, $37
        dc.b $91, $3b, $08, $08, $8d, $3b, $3a, $08
        dc.b $8f, $3a, $08, $08, $4b, $08, $9a, $97
        dc.b $00

; mel3a1
tt_pattern15:
        dc.b $ab, $37, $91, $37, $95, $97, $9a, $97
        dc.b $37, $08, $97, $95, $97, $9a, $97, $37
        dc.b $97, $37, $97, $9a, $97, $37, $97, $9a
        dc.b $97, $34, $95, $34, $ab, $34, $ab, $ab
        dc.b $ab, $91, $37, $95, $97, $9a, $37, $ab
        dc.b $97, $37, $97, $95, $ab, $37, $97, $37
        dc.b $97, $95, $97, $9a, $97, $9a, $aa, $97
        dc.b $9a, $3a, $08, $08, $4b, $08, $08, $08
        dc.b $00




; Individual pattern speeds (needs TT_GLOBAL_SPEED = 0).
; Each byte encodes the speed of one pattern in the order
; of the tt_PatternPtr tables below.
; If TT_USE_FUNKTEMPO is 1, then the low nibble encodes
; the even speed and the high nibble the odd speed.
    IF TT_GLOBAL_SPEED = 0
tt_PatternSpeeds:
%%PATTERNSPEEDS%%
    ENDIF


; ---------------------------------------------------------------------
; Pattern pointers look-up table.
; ---------------------------------------------------------------------
tt_PatternPtrLo:
        dc.b <tt_pattern0, <tt_pattern1, <tt_pattern2, <tt_pattern3
        dc.b <tt_pattern4, <tt_pattern5, <tt_pattern6, <tt_pattern7
        dc.b <tt_pattern8, <tt_pattern9, <tt_pattern10, <tt_pattern11
        dc.b <tt_pattern12, <tt_pattern13, <tt_pattern14, <tt_pattern15

tt_PatternPtrHi:
        dc.b >tt_pattern0, >tt_pattern1, >tt_pattern2, >tt_pattern3
        dc.b >tt_pattern4, >tt_pattern5, >tt_pattern6, >tt_pattern7
        dc.b >tt_pattern8, >tt_pattern9, >tt_pattern10, >tt_pattern11
        dc.b >tt_pattern12, >tt_pattern13, >tt_pattern14, >tt_pattern15
        


; ---------------------------------------------------------------------
; Pattern sequence table. Each byte is an index into the
; tt_PatternPtrLo/Hi tables where the pointers to the pattern
; definitions can be found. When a pattern has been played completely,
; the next byte from this table is used to get the address of the next
; pattern to play. tt_cur_pat_index_c0/1 hold the current index values
; into this table for channels 0 and 1.
; If TT_USE_GOTO is used, a value >=128 denotes a goto to the pattern
; number encoded in bits 6..0 (i.e. value AND %01111111).
; ---------------------------------------------------------------------
tt_SequenceTable:
        ; ---------- Channel 0 ----------
        dc.b $00, $01, $02, $00, $01, $03, $04, $05
        dc.b $04, $05, $04, $05, $04, $05, $04, $05
        dc.b $04, $05, $04, $05, $04, $05, $04, $05
        dc.b $04, $05, $86

        
        ; ---------- Channel 1 ----------
        dc.b $06, $06, $06, $06, $06, $06, $06, $06
        dc.b $06, $06, $06, $06, $06, $06, $06, $07
        dc.b $08, $09, $0a, $0a, $0b, $0b, $0c, $0d
        dc.b $0e, $0e, $0f, $0f, $ad


        echo "Track size: ", *-tt_TrackDataStart
