#include "entities.h"

#define SCALE 256

const u8  ORIGEN_MAPA_Y = 40;
const u8  fondoX = 0;
const u8  lineaFondo = 6;
const u8  limiteX = 80;
const u8  limiteY = 160;
const u8  posteSuperior = 61;
const u8  posteInferior = 96;

#define posteSup 61 + ORIGEN_MAPA_Y
#define posteInf 96 + ORIGEN_MAPA_Y

i16 frictionCoeff;
i16 bounceCoefficient = 2;
i16 fatConstant;

u8 golPorteria(TEntity* ent) __z88dk_fastcall
{
   if(ent->y > posteSup && ent->y < posteInf) // Si ha habido gol.
   {
      //u8 *pscr = cpct_getScreenPtr(CPCT_VMEM_START, 6, 112);
      //cpct_drawStringM0("GOL", pscr, 2, 0);
      if(ent->x + ent->width < lineaFondo + 1) // Si ha sido en la porteria izquierda.
         return 2;
      else if(ent->x > (limiteX-lineaFondo) - 1) // Si ha sido en la porteria derecha.
         return 1;
   }
   
   return 0;
}

void moveEntityX (TEntity* ent, i8 mx) {
   if(mx < 0) { // Movimiento izquierda.
      if(ent->y > posteSup && ent->y+ent->width < posteInf -7) { // Si estamos en alguna porteria.
         if(ent->x + mx <= fondoX) { // Si toca el fondo de la porteria.
            ent->x += 1;
            ent->vel.vx = -ent->vel.vx;
         }
         else
            ent->x += mx;
      } else { // No estamos en una portería
         if(ent->x + mx <= lineaFondo - 1) { // Si toca la linea de fondo izquierda.
            ent->x += 1;
            ent->vel.vx = -ent->vel.vx;
         }
         else
            ent->x += mx;
      }
   }
   else {
      if(ent->y > posteSup && ent->y+ent->width < posteInf - 1) { // Si estamos en alguna porteria.
         if(ent->x+ent->width + mx >= limiteX-fondoX) { // Si toca el fondo de la porteria.
            ent->x -= 1;
            ent->vel.vx = -ent->vel.vx;
         }
         else
            ent->x += mx;
      } else { // No estamos en una portería
         if(ent->x + ent->width + mx >= limiteX -lineaFondo + 1) { // Si toca la linea fondo derecha.
            ent->x -= 1;
            ent->vel.vx = -ent->vel.vx;
         }
         else
            ent->x += mx;
      }
   }
}


void moveEntityY (TEntity* ent, i8 my) {
   if(my < 0) // Movimiento arriba.
   {
      if(ent->x < lineaFondo || ent->x+ent->width > 80 - lineaFondo + 2) // Si estamos en alguna porteria.
      {
         if(ent->y + my <= posteSup) { // Si toca el palo superior de la porteria. 64 + 3
            ent->y += 1;
            ent->vel.vy = -ent->vel.vy;
         }
         else
            ent->y += my;
      }
      else // Fuera de porteria.
      {
         if(ent->y + my <= ORIGEN_MAPA_Y) { // Si toca la banda superior.
            ent->y += 1;
            ent->vel.vy = -ent->vel.vy;
         }
         else
            ent->y += my;
      }
   }
   else // Moviemiento hacia abajo.
   {
      if(ent->x < lineaFondo || ent->x+ent->width > 80 - lineaFondo + 2) // Si estamos en alguna porteria.
      {
         if(ent->y+ent->height + my >= posteInf - 3) { // Si toca el palo inferior de la porteria. 88 + 1
            ent->y -= 1;
            ent->vel.vy = -ent->vel.vy;
         }
         else
            ent->y += my;
      }
      else
      {
         if(ent->y+ent->height + my >= (limiteY+ORIGEN_MAPA_Y)) { // Si toca la banda inferior.
            ent->y -= 1;
            ent->vel.vy = -ent->vel.vy;
         }
         else
            ent->y += my;
      }
   }
}

void checkUserInput (TEntity  *ent) {
   // Read the keyboard
   cpct_scanKeyboard_f();

   // Check for pressed keys and do correspondant actions
   // Cursor keys = apply acceleration to the entity
   if(cpct_isAnyKeyPressed()) {
      if(ent->id == 0) {
         if      (cpct_isKeyPressed(Key_D) || cpct_isKeyPressed(Joy0_Right))  { ent->vel.ax=  SCALE/2; }
         else if (cpct_isKeyPressed(Key_A) || cpct_isKeyPressed(Joy0_Left))  { ent->vel.ax= -SCALE/2; }
            else { ent->vel.ax=  0; }
         if      (cpct_isKeyPressed(Key_W) || cpct_isKeyPressed(Joy0_Up))  { ent->vel.ay= -SCALE/2; }
         else if (cpct_isKeyPressed(Key_S) || cpct_isKeyPressed(Joy0_Down))  { ent->vel.ay=  SCALE/2; }
            else { ent->vel.ay=  0; }
      }
      else
      {
         if      (cpct_isKeyPressed(Key_F6)) { ent->vel.ax=  SCALE/2; }
         else if (cpct_isKeyPressed(Key_F4)) { ent->vel.ax= -SCALE/2; }
            else                             { ent->vel.ax=  0; }
         if      (cpct_isKeyPressed(Key_F8)) { ent->vel.ay= -SCALE/2; }
         else if (cpct_isKeyPressed(Key_F5)) { ent->vel.ay=  SCALE/2; }
            else                             { ent->vel.ay=  0; }
      }
   }
   else {
      ent->vel.ax = 0;
      ent->vel.ay = 0;
   }
}

void updateEntitySpritePingu(TEntity *ent) __z88dk_fastcall {
   if(ent->vel.ax < 0) {
      if(ent->vel.ay < 0)      { ent->sprite = g_pingu_5; }
      else if(ent->vel.ay > 0) { ent->sprite = g_pingu_7; }
      else                     { ent->sprite = g_pingu_6; }
   } else if(ent->vel.ax > 0) {
      if(ent->vel.ay < 0)      { ent->sprite = g_pingu_3; }
      else if(ent->vel.ay > 0) { ent->sprite = g_pingu_1; }
      else                     { ent->sprite = g_pingu_2; }
   } else {
      if(ent->vel.ay < 0)      { ent->sprite = g_pingu_4; }
      else if(ent->vel.ay > 0) { ent->sprite = g_pingu_0; }
   }
}

void updateEntitySpriteEnemy(TEntity *ent) __z88dk_fastcall
{
   if(ent->vel.ax < 0) {
      if(ent->vel.ay < 0)      { ent->sprite = g_pingu2_5; }
      else if(ent->vel.ay > 0) { ent->sprite = g_pingu2_7; }
      else                     { ent->sprite = g_pingu2_6; }
   } else if(ent->vel.ax > 0) {
      if(ent->vel.ay < 0)      { ent->sprite = g_pingu2_3; }
      else if(ent->vel.ay > 0) { ent->sprite = g_pingu2_1; }
      else                     { ent->sprite = g_pingu2_2; }
   } else {
      if(ent->vel.ay < 0)      { ent->sprite = g_pingu2_4; }
      else if(ent->vel.ay > 0) { ent->sprite = g_pingu2_0; }
   }
}

u8 collisionEntity1X(TEntity *ent1, TEntity *ent2, i8 dx) {
   i8 dist_y = ent1->y - ent2->y;
   u8 check_x = 0;
   i8 ignore = ent1->ignoreSQR + ent2->ignoreSQR;

   if(dist_y < 0) {
      if(-dist_y <= (i8) ent1->height - ignore)
         check_x = 1;
   } else {
      if(dist_y <= (i8) ent2->height - ignore)
         check_x = 1;
   }

   if(check_x) {
      i8 dist_x = ent1->x + dx - ent2->x;

      if(dist_x < 0) {
         if(-dist_x <= (i8) ent1->width - ignore)
            return 1;
      }
      else if(dist_x <= (i8) ent2->width - ignore) {
         return 1;
      }
   }

   return 0;
}

u8 collisionEntity1Y(TEntity *ent1, TEntity *ent2, i8 dy) {
   i8 dist_x = ent1->x - ent2->x;
   u8 check_y = 0;
   i8 ignore = ent1->ignoreSQR + ent2->ignoreSQR;

   if(dist_x < 0) {
      if(-dist_x <= (i8) ent1->width - ignore)
         check_y = 1;
   } else {
      if(dist_x <= (i8) ent2->width - ignore)
         check_y = 1;
   }

   if(check_y) {
      i8 dist_y = ent1->y + dy - ent2->y;

      if(dist_y < 0) {
         if(-dist_y <= (i8) ent1->height - ignore)
            return 1;
      }
      else if(dist_y <= (i8) ent2->height - ignore) {
         return 1;
      }
   }

   return 0;
}

void updateEntityVideopos(TEntity * ent) __z88dk_fastcall {
   ent->videopos = cpct_getScreenPtr(CPCT_VMEM_START, ent->x, ent->y);
}

void updateEntityAcceleration(TEntity *ent) {
   if      (ent->vel.vx >  ent->vel.max_x) ent->vel.vx=  ent->vel.max_x;
   else if (ent->vel.vx < -ent->vel.max_x) ent->vel.vx= -ent->vel.max_x;
   if      (ent->vel.vy >  ent->vel.max_y) ent->vel.vy=  ent->vel.max_y;
   else if (ent->vel.vy < -ent->vel.max_y) ent->vel.vy= -ent->vel.max_y;
}

void doubleCollisionX(TEntity *ent1, TEntity *ent2) { 
   i16 aux_vel = 0;

   aux_vel = ent1->vel.vx;
   ent1->vel.vx = (ent2->kilograms/ent1->kilograms) * ent2->vel.vx;
   ent2->vel.vx = (ent1->kilograms/ent2->kilograms) * aux_vel;
}

void simpleCollisionX(TEntity *ent1, TEntity *ent2) {
   ent2->vel.vy = (ent1->kilograms/ent2->kilograms) * ent1->vel.vy;

   ent2->vel.vx = (ent1->kilograms/ent2->kilograms) * ent1->vel.vx;
   ent1->vel.vx = (ent2->kilograms/ent1->kilograms) * -ent1->vel.vx*0.4;
}

void doubleCollisionY(TEntity *ent1, TEntity *ent2) { 
   i16 aux_vel = 0;
   
   aux_vel = ent1->vel.vy;
   ent1->vel.vy = (ent2->kilograms/ent1->kilograms) * ent2->vel.vy;
   ent2->vel.vy = (ent1->kilograms/ent2->kilograms) * aux_vel;
}

void simpleCollisionY(TEntity *ent1, TEntity *ent2) {
   ent2->vel.vx = (ent1->kilograms/ent2->kilograms) * ent1->vel.vx;

   ent2->vel.vy = (ent1->kilograms/ent2->kilograms) * ent1->vel.vy;
   ent1->vel.vy = (ent2->kilograms/ent1->kilograms) * -ent1->vel.vy*0.4;
}

void pairCheckCollisionX(TEntity *ent1, TEntity *ent2) {
   if(collisionEntity1X(ent1, ent2, ent1->vel.vx/(SCALE*2))){            // EJE X: TODOS LOS CASOS POSIBLES
      if(collisionEntity1X(ent2, ent1, ent2->vel.vx/(SCALE*2))) {        // COLISIÓN DOBLE
         doubleCollisionX(ent1, ent2);
      } else {                                                   // ENT1 CONTRA ENT2
         simpleCollisionX(ent1, ent2);
      }
   } else if(collisionEntity1X(ent2, ent1, ent2->vel.vx/(SCALE*2))) {    // ENT2 CONTRA ENT1
      simpleCollisionX(ent2, ent1);
   }
}

void pairCheckCollisionY(TEntity *ent1, TEntity *ent2) {
   if(collisionEntity1Y(ent1, ent2, ent1->vel.vy/SCALE)){              // EJEY: TODOS LOS CASOS POSIBLES
      if(collisionEntity1Y(ent2, ent1, ent2->vel.vy/SCALE)) {          // COLISIÓN DOBLE
         doubleCollisionY(ent1, ent2);
      } else {                                                   // ENT1 CONTRA ENT2
         simpleCollisionY(ent1, ent2); 
      }
   } else if(collisionEntity1Y(ent2, ent1, ent2->vel.vy/SCALE)) {      // ENT2 CONTRA ENT1
      simpleCollisionY(ent2, ent1);
   }

}

void calculateEntityCollisions(TEntity *pingu, TEntity *pingu_enemy, TEntity *ball) {
   pairCheckCollisionX(pingu, pingu_enemy);
   pairCheckCollisionX(pingu, ball);
   pairCheckCollisionX(pingu_enemy, ball);

   pairCheckCollisionY(pingu, pingu_enemy);
   pairCheckCollisionY(pingu, ball);
   pairCheckCollisionY(pingu_enemy, ball);

   updateEntityAcceleration(ball);

   moveEntityX(pingu, pingu->vel.vx/(SCALE*2));
   moveEntityX(pingu_enemy, pingu_enemy->vel.vx/(SCALE*2));
   moveEntityX(ball, ball->vel.vx/(SCALE*2));

   moveEntityY(pingu, pingu->vel.vy/SCALE);
   moveEntityY(pingu_enemy, pingu_enemy->vel.vy/SCALE);
   moveEntityY(ball, ball->vel.vy/SCALE);
}

void initConstants(i16 scaledFriction) {
   frictionCoeff = scaledFriction/3;
   fatConstant = frictionCoeff * 3;
}

void updateEntityPhysics (TEntity * ent) {
   ent->vel.vx += ent->vel.ax;
   ent->vel.vy += ent->vel.ay;

   if(ent->id == 2) {
      if(ent->vel.vx < 0) { ent->vel.vx += frictionCoeff; }
      else                { ent->vel.vx -= frictionCoeff; }
      if(ent->vel.vy < 0) { ent->vel.vy += frictionCoeff*2; }
      else                { ent->vel.vy -= frictionCoeff*2; }
   } else {
      if(ent->vel.vx < 0) { ent->vel.vx += fatConstant; }
      else                { ent->vel.vx -= fatConstant; }
      if(ent->vel.vy < 0) { ent->vel.vy += fatConstant*2; }
      else                { ent->vel.vy -= fatConstant*2; }
   }

   updateEntityAcceleration(ent);
}

u8 updateEntities(TEntity *pingu, TEntity *pingu_enemy, TEntity *ball, i8 ia) {

   checkUserInput(pingu);
   updateEntityPhysics(pingu);

   if(ia) fuzzificacion(&pingu_enemy->vel.ax, &pingu_enemy->vel.ay, ball->x, ball->y, pingu_enemy->x, pingu_enemy->y);
   else checkUserInput(pingu_enemy);
   
   updateEntityPhysics(pingu_enemy);

   updateEntityPhysics(ball);
   calculateEntityCollisions(pingu, pingu_enemy, ball);

   updateEntityVideopos(pingu);
   updateEntityVideopos(pingu_enemy);
   updateEntityVideopos(ball);

   updateEntitySpritePingu(pingu);
   updateEntitySpriteEnemy(pingu_enemy);

   return golPorteria(ball);
}
void initFuzzy(u8 level)
{
   initAcel(level);
} 
