//-----------------------------LICENSE NOTICE------------------------------------
//  This file is part of Hair Boy
//  Copyright (C) 2016 Carlos Sevila (@CarlosSevila)
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
//------------------------------------------------------------------------------

#include <cpctelera.h>
#include "../globals.h"
#include "../entity/entities.h"
#include "../art/sprites.h"
#include "../map/maps.h"

#ifndef _GAME_H_
#define _GAME_H_

// Extern
extern u8 currentMap;
extern u16 totalDefeats;
extern u8 seconds;
extern u16 minutes;

void InitializeGame(void);
void GameLoop(void);
void ResetPlayer(void);
void CheckInput(u8 *ticks);
void UpdatePlayer(u8 *ticks);
u8 CheckMapCollision(u8 x, u8 y);
void ChangeMap();
void LoadMap(u8 m);
u8* GetTile(u8 i);
void DrawMapProgressBar();
void UpdateMapProgressBar();
u8 CheckDeath();
u8 CheckWin();

void UpdateBlock(u8 *ticks);
void ResetBlock();
u8 CheckMapCollisionBasic(u8 x, u8 y);

void ActivateDeformBlock(u8 x, u8 y);
void UpdateDeformBlocks();
void ResetDeformBlocks();

void DrawHUDBackground();
void DrawTotalDefeats();
void UpdateTotalTime();
void DrawTotalTime(u8 forceDraw);

#endif
