Declare Function Menu() As Integer
Declare Sub Menu_SetPoints(array() As Integer, actmenu As Integer)
Declare Sub Menu_LoadPart(File As String, pX As Integer, pY As Integer)

ChDir ExePath

Screen 19,32,5
WindowTitle "Paddle Battle 2"

#Include "general.bi"
initFMOD

Dim Shared silverfont As UByte Ptr
silverfont = fadefont(255,255,255,12)

Randomize Timer

Print Menu

Sleep 800,1

closeFMOD

Function Menu() As Integer
    LoadSong "menu.it"
    Dim sndClick As Long Ptr = LoadSound("click.wav", 0)
    Dim sndSelect As Long Ptr = LoadSound("select1.wav",0)
    
    Color ,0
    Cls
    
    Menu_LoadPart "logo", 90, 51
    Menu_LoadPart "mboard", 526, 230
    Menu_LoadPart "msel", 146, 292
    
    Draw String (707,6),"Version 1.0",,silverfont,alpha,100
    Draw String (640,25),Chr(130)+" 2006 by Saga-Games",,silverfont,alpha,64
    ScreenCopy 0,1
    
    Dim As Integer actmenu=1,lastup,lastdown,mpoints(1 To 4,1 To 2),mpoints2(1 To 4,1 To 2),p1,p2
    Dim As Integer light(1 To 6),x,y,z,b,oldx,oldy,oldb,c,mb,actcur,fr, selection = 0
    Dim lauftext As String = Chr(45,196,205,205) + " Paddle Battle 2 " + Chr(196,240,196) + " Der coole Paddle Battle 1000 Volt Nachfolger mit LAN-Untersttzung! Saga-Games wnscht viel Spa! " + Chr(205,205,45,45), laufx As Integer = 800
    
    ReDim mballs(1 To 5,1 To 4) As Short
    
    ReDim mstars(1 To 500,1 To 3) As Short
    
    Dim ball As Long Ptr
    ball=ImageCreate(8,8)
    BLoad "gamedata" + slash + "balls" + slash + "ball1.bmp",ball
    
    Dim star As Long Ptr
    star=ImageCreate(3,3)
    Line star,(0,1)-(2,1),RGB(255,255,255)
    Line star,(1,0)-(1,2),RGB(255,255,255)
    
    For mb = 1 To UBound(mballs,1)
        mballs(mb,1)=534 + 100 * Rnd
        mballs(mb,2)=Int(60 * Rnd)
        mballs(mb,3)=CInt(Rnd)
        mballs(mb,4)=CInt(Rnd)
    Next
    
    fr = FreeFile
    Dim points(0 To 99) As Integer
    Open "gamedata" + slash + "bounce.bin" For Binary As #fr
    For x = 0 To 99
        Get #fr,,points(x)
    Next    
    Close #fr
    
    Dim cursor(1 To 4) As Long Ptr
    For c=1 To 4
        cursor(c)=ImageCreate(22,38)
        BLoad "gamedata" + slash + "img" + slash + "cur"+Trim(Str(c))+".bmp",cursor(c)
    Next c
    
    Dim cursorrev(1 To 4) As Long Ptr
    For c=1 To 4
        cursorrev(c)=ImageCreate(22,38)
        For x = 0 To 21
            For y = 0 To 37
                p1 = cursor(c)[1 + x + 22 * y]
                p2 = cursor(c)[1 + (21 - x) + 22 * (37 - y)]
                cursorrev(c)[1 + x + 22 * y] = p2
                cursorrev(c)[1 + (21 - x) + 22 * (37 - y)] = p1
            Next y
        Next x
    Next c
    
    SetMouse ,,0
    GetMouse oldx,oldy,oldb
    
    Menu_SetPoints mpoints(),actmenu
    Menu_SetPoints mpoints2(),actmenu
    Do
        ScreenLock
        ScreenCopy 1,0
        For mb = 1 To UBound(mballs,1)
            
            If mballs(mb,3) = 0 Then mballs(mb,2)+=3 Else mballs(mb,2)-=3
            If mballs(mb,2) > 60 Then mballs(mb,3) = 1:mballs(mb,2)=60
            If mballs(mb,2) < 1 Then mballs(mb,3) = 0:mballs(mb,2)=0
            
            If mballs(mb,4) = 0 Then mballs(mb,1)+=1 Else mballs(mb,1)-=1
            If mballs(mb,1) > 633 Then mballs(mb,4) = 1:mballs(mb,1)=634
            If mballs(mb,1) < 535 Then mballs(mb,4) = 0:mballs(mb,1)=534
            
            
            Put(mballs(mb,1),points(mballs(mb,2))+92),ball,trans
        Next
        
        For p1 = 1 To 4
            For p2 = 1 To 2
                If mpoints(p1,p2) < mpoints2(p1,p2) Then mpoints(p1,p2) +=4
                If mpoints(p1,p2) > mpoints2(p1,p2) Then mpoints(p1,p2) -=4
            Next
        Next
        
        Line(mpoints(1,1),mpoints(1,2))-(mpoints(2,1),mpoints(2,2)),RGB(0,0,64)
        Line(mpoints(1,1),mpoints(1,2))-(mpoints(3,1),mpoints(3,2)),RGB(0,0,64)
        Line(mpoints(2,1),mpoints(2,2))-(mpoints(4,1),mpoints(4,2)),RGB(0,0,64)
        Line(mpoints(3,1),mpoints(3,2))-(mpoints(4,1),mpoints(4,2)),RGB(0,0,64)
        Paint(400,mpoints(1,2)+10),RGB(0,0,64)
        For p1 = 1 To 6
            If p1 = actmenu And light(p1) < 150 Then light(p1)+=25
            If p1 <> actmenu And light(p1) > 0 Then light(p1)-=25
        Next
        Draw String (200,380),"Spiel gegen den Computer",,silverfont,alpha,100+light(1)
        Draw String (200,400),"LAN-Spiel",,silverfont,alpha,100+light(2)
        Draw String (200,420),"Optionen",,silverfont,alpha,100+light(3)
        Draw String (200,440),"Hilfe",,silverfont,alpha,100+light(4)
        Draw String (200,460),"Credits",,silverfont,alpha,100+light(5)
        Draw String (200,480),"Ende",,silverfont,alpha,100+light(6)
        
        laufx -= 2: If laufx < -Len(lauftext)*8 Then laufx = 800
        Draw String(laufx+1,583),lauftext,,silverfont,alpha,100
        Draw String(laufx,582),lauftext,,silverfont,trans
        
        If MultiKey(72) And lastup = 0 Then
            actmenu-=1
            If actmenu < 1 Then actmenu = 1
            Menu_SetPoints mpoints2(),actmenu
            PlaySound sndClick, 128
        End If
        If MultiKey(80) And lastdown = 0 Then
            actmenu+=1
            If actmenu > 6 Then actmenu = 6
            Menu_SetPoints mpoints2(),actmenu
            PlaySound sndClick, 128
        End If
        lastup = MultiKey(72)
        lastdown = MultiKey(80)
        GetMouse x,y,z,b
        'c+=1
        'x = 400 + sin(c*0.1)*200
        'y = 300 + cos(c*0.1)*200
        
        If x = -1 And oldx > -1 Then SetMouse ,,1
        If x > -1 And oldx = -1 Then SetMouse ,,0
        
        
        If y > 380 And y < 499 And x > 160 And x < 620 Then
            p2 = (y - 360) \ 20
            If p2 <> actmenu And y <> oldy Then
                actmenu = p2
                Menu_SetPoints mpoints2(),actmenu
                PlaySound sndClick, 128
            End If
            If b And oldb = 0 Then selection = p2
        End If
        If config.eyecandy Then
            If (x <> oldx Or y <> oldy) And x > -1 And oldx > -1 Then
                p2 = 0
                For p1 = 1 To UBound(mstars,1)
                    If mstars(p1,3) < 1 Then
                        p2+=1
                        mstars(p1,1)= x+5+8*Rnd+(oldx-x)*Rnd
                        mstars(p1,2)= y+21+8*Rnd+(oldy-y)*Rnd
                        mstars(p1,3)= 150+60*Rnd
                    End If
                    If p2 > 10 Then Exit For
                Next
            End If
            For p1 = 1 To UBound(mstars,1)
                If mstars(p1,3) > 0 Then
                    mstars(p1,3) -= 8
                    If mstars(p1,3) > 0 Then
                        Put(799-mstars(p1,1),599-mstars(p1,2)),star,alpha,mstars(p1,3)\4
                    		Put(mstars(p1,1),mstars(p1,2)),star,alpha,mstars(p1,3)
                    Else
                    		mstars(p1,3) = 0
                    End If
                End If
            Next
        End If
        actcur +=1: If actcur > 15 Then actcur = 0
        If x >= 0 And config.eyecandy Then Put(799-x-21,599-y-37),cursorrev(actcur \ 4 + 1), alpha,64
        If x >= 0 Then Put(x,y),cursor(actcur \ 4 + 1), trans
        
        If MultiKey(28) Then selection = actcur
        
        oldx=x
        oldy=y
        oldb=b
        
        ScreenUnLock
        Sleep 1
    Loop Until MultiKey(1) Or selection
    PlaySound sndSelect
    
    ImageDestroy star
    ImageDestroy ball
    ReDim mstars(0,0),mballs(0,0)
    Function = selection
End Function

Sub Menu_SetPoints(array() As Integer, actmenu As Integer)
    Dim vari As Integer = 8
    array(1,1) = 180+vari*Rnd
    array(1,2) = 350+actmenu*20+vari*Rnd
    
    array(2,1) = 180+vari*Rnd
    array(2,2) = 380+actmenu*20+vari*Rnd
    
    array(3,1) = 600+vari*Rnd
    array(3,2) = 350+actmenu*20+vari*Rnd
    
    array(4,1) = 600+vari*Rnd
    array(4,2) = 380+actmenu*20+vari*Rnd
End Sub

Sub Menu_LoadPart(File As String, pX As Integer, pY As Integer)
    Dim tempptr As Any Ptr, fr As Integer, sx As Integer, sy As Integer
    Dim As String NewFile = "gamedata" + slash + "img" + slash + File + ".bmp"
    fr = FreeFile
    Open NewFile For Binary As #fr
    Get #fr,19,sx
    Get #fr,23,sy
    Close #fr
    tempptr = ImageCreate(sx,sy)
    BLoad NewFile, tempptr
    Put(pX, pY), tempptr, trans
    ImageDestroy tempptr
End Sub
