import controlP5.*;
import processing.net.*;

final int PORT = 2015;

Scene currentScene = null;
PFont smallFont = null;
PFont bigFont = null;

void setup() {
  size(640, 360);
  noFill();
  stroke(255);
  strokeWeight(1);
  background(0);
  frameRate(120);
  
  smallFont = loadFont("Hack-Bold-16.vlw");
  bigFont = loadFont("Hack-Bold-48.vlw");
  
  currentScene = new GameModeScene(this);
  currentScene.setup();
}

void draw() {
  currentScene.draw();
}

void controlEvent(ControlEvent cevent) {
  currentScene.controlEvent(cevent);
}

void serverEvent(Server server, Client client) {
  currentScene.serverEvent(server, client);
}

void disconnectEvent(Client client) {
  currentScene.disconnectEvent(client);
}

void mousePressed() {
  currentScene.mousePressed();
}

void keyReleased() {
  currentScene.keyReleased();
}

void keyPressed() {
  currentScene.keyPressed();
}