class Universe {
  
  final int MAX_SHIP = 4;
  
  Ship[] ships = new Ship[MAX_SHIP];
  Bullet[] bullets = new Bullet[MAX_SHIP * 4];
  Explosion[] explosions = new Explosion[MAX_SHIP * 4];
  Asteroid[] asteroids = new Asteroid[10];

  public Universe() {
    for( int b = 0; b < bullets.length; ++b) {
      bullets[b] = new Bullet();
      bullets[b].id = b;
    }
    for( int a = 0; a < asteroids.length; ++a) {
      asteroids[a] = new Asteroid();
      asteroids[a].id = a;
    }
    for( int e = 0; e < explosions.length; ++e) {
      explosions[e] = new Explosion();
      explosions[e].id = e;
    }
    for( int s = 0; s < ships.length; ++s) {
      ships[s] = new Ship();
      ships[s].id = s;
    }
  }
  
  public void update(float elapsed) {
    for( int b = 0; b < bullets.length; ++b) {
      if (bullets[b].visible) bullets[b].update(elapsed);
    }
    for( int a = 0; a < asteroids.length; ++a) {
      if (asteroids[a].visible) asteroids[a].update(elapsed);
    }
    for( int s = 0; s < ships.length; ++s) {
      if (ships[s].visible) ships[s].update(elapsed);
    }
    for( int e = 0; e < explosions.length; ++e) {
      if (explosions[e].visible) explosions[e].update(elapsed);
    }
  }
  
  public void draw() {
    background(0);  
    for( int b = 0; b < bullets.length; ++b) {
      if (bullets[b].visible) bullets[b].draw();
    }
    for( int a = 0; a < asteroids.length; ++a) {
      if (asteroids[a].visible) asteroids[a].draw();
    }
    for( int s = 0; s < ships.length; ++s) {
      if (ships[s].visible) ships[s].draw();
    }
    for( int e = 0; e < explosions.length; ++e) {
      if (explosions[e].visible) explosions[e].draw();
    }
  }
  
  public void destroy(int type, int id) {
    if (type == GameObject.TYPE_BULLET) {
      bullets[id].visible = false;
    }
    
    if (type == GameObject.TYPE_EXPLOSION) {
      explosions[id].visible = false;
    }
    
    if (type == GameObject.TYPE_ASTEROID) {
      asteroids[id].visible = false;
    }
    
    if (type == GameObject.TYPE_SHIP) {
      ships[id].visible = false;
    }
  }
  
  public Bullet bullet(int id, float px, float py, float fx, float fy, float life, int ec, int sid) {
    bullets[id].sync(px, py, fx, fy, life, ec, sid);
    bullets[id].visible = true;
    return bullets[id];
  }
  
  public Bullet bullet(float px, float py, float fx, float fy, float life, int ec, int sid) {
    for( int b = 0; b < bullets.length; ++b) {
      if (!bullets[b].visible) {
        bullets[b].sync(px, py, fx, fy, life, ec, sid);
        bullets[b].visible = true;
        return bullets[b];
      }
    }
    
    return null;
  }
  
  public Explosion explosion(int id, float px, float py, float f) {
    explosions[id].sync(px, py, f);
    explosions[id].visible = true;
    return explosions[id];
  }
  
  public Explosion explosion(float px, float py, float f) {
    for( int e = 0; e < explosions.length; ++e) {
      if (!explosions[e].visible) {
        explosions[e].sync(px, py, f);
        explosions[e].visible = true;
        return explosions[e];
      }
    }
    
    return null;
  }
  
  public Ship ship(int id, float px, float py, float fx, float fy, float size, float d, float r, boolean acc, boolean tl, boolean tr, color ec) {
    ships[id].sync(px, py, fx, fy, size, d, r, acc, tl, tr, ec);
    ships[id].visible = true;
    return ships[id]; 
  }
  
  public Ship ship(float px, float py, float fx, float fy, float size, float d, float r, boolean a, boolean tl, boolean tr, color ec) {
    for( int s = 0; s < ships.length; ++s) {
      if (!ships[s].visible) {
        ships[s].sync(px, py, fx, fy, size, d, r, a, tl, tr, ec);
        ships[s].visible = true;
        return ships[s];
      }
    }
    
    return null;
  }
  
  public Asteroid asteroid(int id, float px, float py, float fx, float fy, float size, float d, float r, boolean acc, boolean tl, boolean tr, color ec) {
    asteroids[id].sync(px, py, fx, fy, size, d, r, acc, tl, tr, ec);
    asteroids[id].visible = true;
    return asteroids[id]; 
  }
  
  public Asteroid asteroid(float px, float py, float fx, float fy, float size, float d, float r, boolean acc, boolean tl, boolean tr, color ec) {
    for( int a = 0; a < asteroids.length; ++a) {
      if (!asteroids[a].visible) {
        asteroids[a].sync(px, py, fx, fy, size, d, r, acc, tl, tr, ec);
        asteroids[a].visible = true;
        return asteroids[a];
      }
    }
    
    return null;
  }
  
  public void updateObject(GameObject go) {
  }
}