/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.BufferedReader;
import java.io.File;
import java.util.ArrayList;
import java.util.Hashtable;
import processing.core.PApplet;
import processing.core.PImage;
import processing.core.PShape;
import processing.core.PVector;

public class PShapeOBJ
extends PShape {
    public PShapeOBJ(PApplet parent, String filename) {
        this(parent, parent.createReader(filename), PShapeOBJ.getBasePath(parent, filename));
    }

    public PShapeOBJ(PApplet parent, BufferedReader reader) {
        this(parent, reader, "");
    }

    public PShapeOBJ(PApplet parent, BufferedReader reader, String basePath) {
        ArrayList<OBJFace> faces = new ArrayList<OBJFace>();
        ArrayList<OBJMaterial> materials = new ArrayList<OBJMaterial>();
        ArrayList<PVector> coords = new ArrayList<PVector>();
        ArrayList<PVector> normals = new ArrayList<PVector>();
        ArrayList<PVector> texcoords = new ArrayList<PVector>();
        PShapeOBJ.parseOBJ(parent, basePath, reader, faces, materials, coords, normals, texcoords);
        parent = null;
        this.family = 0;
        this.addChildren(faces, materials, coords, normals, texcoords);
    }

    protected PShapeOBJ(OBJFace face, OBJMaterial mtl, ArrayList<PVector> coords, ArrayList<PVector> normals, ArrayList<PVector> texcoords) {
        this.family = 3;
        this.kind = face.vertIdx.size() == 3 ? 9 : (face.vertIdx.size() == 4 ? 17 : 20);
        this.stroke = false;
        this.fill = true;
        this.fillColor = PShapeOBJ.rgbaValue(mtl.kd);
        this.ambientColor = PShapeOBJ.rgbaValue(mtl.ka);
        this.specularColor = PShapeOBJ.rgbaValue(mtl.ks);
        this.shininess = mtl.ns;
        if (mtl.kdMap != null) {
            this.tintColor = PShapeOBJ.rgbaValue(mtl.kd, mtl.d);
        }
        this.vertexCount = face.vertIdx.size();
        this.vertices = new float[this.vertexCount][12];
        int j = 0;
        while (j < face.vertIdx.size()) {
            int normIdx;
            PVector norms = null;
            PVector vert = null;
            int vertIdx = face.vertIdx.get(j) - 1;
            vert = coords.get(vertIdx);
            if (j < face.normIdx.size() && -1 < (normIdx = face.normIdx.get(j) - 1)) {
                norms = normals.get(normIdx);
            }
            this.vertices[j][0] = vert.x;
            this.vertices[j][1] = vert.y;
            this.vertices[j][2] = vert.z;
            this.vertices[j][3] = mtl.kd.x;
            this.vertices[j][4] = mtl.kd.y;
            this.vertices[j][5] = mtl.kd.z;
            this.vertices[j][6] = 1.0f;
            if (norms != null) {
                this.vertices[j][9] = norms.x;
                this.vertices[j][10] = norms.y;
                this.vertices[j][11] = norms.z;
            }
            if (mtl != null && mtl.kdMap != null) {
                int texIdx;
                PVector tex = null;
                if (j < face.texIdx.size() && -1 < (texIdx = face.texIdx.get(j) - 1)) {
                    tex = texcoords.get(texIdx);
                }
                this.image = mtl.kdMap;
                if (tex != null) {
                    this.vertices[j][7] = tex.x;
                    this.vertices[j][8] = tex.y;
                }
            }
            ++j;
        }
    }

    protected void addChildren(ArrayList<OBJFace> faces, ArrayList<OBJMaterial> materials, ArrayList<PVector> coords, ArrayList<PVector> normals, ArrayList<PVector> texcoords) {
        int mtlIdxCur = -1;
        OBJMaterial mtl = null;
        int i = 0;
        while (i < faces.size()) {
            OBJFace face = faces.get(i);
            if (mtlIdxCur != face.matIdx || face.matIdx == -1) {
                mtlIdxCur = PApplet.max(0, face.matIdx);
                mtl = materials.get(mtlIdxCur);
            }
            PShapeOBJ child = new PShapeOBJ(face, mtl, coords, normals, texcoords);
            this.addChild(child);
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static void parseOBJ(PApplet parent, String path, BufferedReader reader, ArrayList<OBJFace> faces, ArrayList<OBJMaterial> materials, ArrayList<PVector> coords, ArrayList<PVector> normals, ArrayList<PVector> texcoords) {
        Hashtable<String, Integer> mtlTable = new Hashtable<String, Integer>();
        int mtlIdxCur = -1;
        try {
            boolean readvt = false;
            boolean readvn = false;
            boolean readv = false;
            String gname = "object";
            block2: while (true) {
                PVector tempv;
                String[] parts;
                String line;
                if ((line = reader.readLine()) == null) {
                    if (materials.size() != 0) return;
                    OBJMaterial defMtl = new OBJMaterial();
                    materials.add(defMtl);
                    return;
                }
                if ((line = line.trim()).equals("") || line.indexOf(35) == 0) continue;
                while (true) {
                    if (!line.contains("\\")) {
                        parts = line.split("\\s+");
                        if (parts.length <= 0) continue block2;
                        if (!parts[0].equals("v")) break;
                        tempv = new PVector(Float.valueOf(parts[1]).floatValue(), Float.valueOf(parts[2]).floatValue(), Float.valueOf(parts[3]).floatValue());
                        coords.add(tempv);
                        readv = true;
                        continue block2;
                    }
                    line = line.split("\\\\")[0];
                    String s = reader.readLine();
                    if (s == null) continue;
                    line = String.valueOf(line) + s;
                }
                if (parts[0].equals("vn")) {
                    PVector tempn = new PVector(Float.valueOf(parts[1]).floatValue(), Float.valueOf(parts[2]).floatValue(), Float.valueOf(parts[3]).floatValue());
                    normals.add(tempn);
                    readvn = true;
                    continue;
                }
                if (parts[0].equals("vt")) {
                    tempv = new PVector(Float.valueOf(parts[1]).floatValue(), 1.0f - Float.valueOf(parts[2]).floatValue());
                    texcoords.add(tempv);
                    readvt = true;
                    continue;
                }
                if (parts[0].equals("o")) continue;
                if (parts[0].equals("mtllib")) {
                    BufferedReader mreader;
                    if (parts[1] == null) continue;
                    String fn = parts[1];
                    if (fn.indexOf(File.separator) == -1 && !path.equals("")) {
                        fn = String.valueOf(path) + File.separator + fn;
                    }
                    if ((mreader = parent.createReader(fn)) == null) continue;
                    PShapeOBJ.parseMTL(parent, path, mreader, materials, mtlTable);
                    continue;
                }
                if (parts[0].equals("g")) {
                    gname = 1 < parts.length ? parts[1] : "";
                    continue;
                }
                if (parts[0].equals("usemtl")) {
                    if (parts[1] == null) continue;
                    String mtlname = parts[1];
                    if (mtlTable.containsKey(mtlname)) {
                        Integer tempInt = mtlTable.get(mtlname);
                        mtlIdxCur = tempInt;
                        continue;
                    }
                    mtlIdxCur = -1;
                    continue;
                }
                if (!parts[0].equals("f")) continue;
                OBJFace face = new OBJFace();
                face.matIdx = mtlIdxCur;
                face.name = gname;
                int i = 1;
                while (true) {
                    block27: {
                        String seg;
                        block25: {
                            String[] forder;
                            block28: {
                                block26: {
                                    if (i >= parts.length) {
                                        faces.add(face);
                                        continue block2;
                                    }
                                    seg = parts[i];
                                    if (seg.indexOf("/") <= 0) break block25;
                                    forder = seg.split("/");
                                    if (forder.length <= 2) break block26;
                                    if (forder[0].length() > 0 && readv) {
                                        face.vertIdx.add(Integer.valueOf(forder[0]));
                                    }
                                    if (forder[1].length() > 0 && readvt) {
                                        face.texIdx.add(Integer.valueOf(forder[1]));
                                    }
                                    if (forder[2].length() > 0 && readvn) {
                                        face.normIdx.add(Integer.valueOf(forder[2]));
                                    }
                                    break block27;
                                }
                                if (forder.length <= 1) break block28;
                                if (forder[0].length() > 0 && readv) {
                                    face.vertIdx.add(Integer.valueOf(forder[0]));
                                }
                                if (forder[1].length() > 0) {
                                    if (readvt) {
                                        face.texIdx.add(Integer.valueOf(forder[1]));
                                        break block27;
                                    } else if (readvn) {
                                        face.normIdx.add(Integer.valueOf(forder[1]));
                                    }
                                }
                                break block27;
                            }
                            if (forder.length > 0 && forder[0].length() > 0 && readv) {
                                face.vertIdx.add(Integer.valueOf(forder[0]));
                            }
                            break block27;
                        }
                        if (seg.length() > 0 && readv) {
                            face.vertIdx.add(Integer.valueOf(seg));
                        }
                    }
                    ++i;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static void parseMTL(PApplet parent, String path, BufferedReader reader, ArrayList<OBJMaterial> materials, Hashtable<String, Integer> materialsHash) {
        try {
            String line;
            OBJMaterial currentMtl = null;
            while ((line = reader.readLine()) != null) {
                String[] parts = (line = line.trim()).split("\\s+");
                if (parts.length <= 0) continue;
                if (parts[0].equals("newmtl")) {
                    String mtlname = parts[1];
                    currentMtl = new OBJMaterial(mtlname);
                    materialsHash.put(mtlname, new Integer(materials.size()));
                    materials.add(currentMtl);
                    continue;
                }
                if (parts[0].equals("map_Kd") && parts.length > 1) {
                    String texname = parts[1];
                    if (texname.indexOf(File.separator) == -1 && !path.equals("")) {
                        texname = String.valueOf(path) + File.separator + texname;
                    }
                    currentMtl.kdMap = parent.loadImage(texname);
                    continue;
                }
                if (parts[0].equals("Ka") && parts.length > 3) {
                    currentMtl.ka.x = Float.valueOf(parts[1]).floatValue();
                    currentMtl.ka.y = Float.valueOf(parts[2]).floatValue();
                    currentMtl.ka.z = Float.valueOf(parts[3]).floatValue();
                    continue;
                }
                if (parts[0].equals("Kd") && parts.length > 3) {
                    currentMtl.kd.x = Float.valueOf(parts[1]).floatValue();
                    currentMtl.kd.y = Float.valueOf(parts[2]).floatValue();
                    currentMtl.kd.z = Float.valueOf(parts[3]).floatValue();
                    continue;
                }
                if (parts[0].equals("Ks") && parts.length > 3) {
                    currentMtl.ks.x = Float.valueOf(parts[1]).floatValue();
                    currentMtl.ks.y = Float.valueOf(parts[2]).floatValue();
                    currentMtl.ks.z = Float.valueOf(parts[3]).floatValue();
                    continue;
                }
                if ((parts[0].equals("d") || parts[0].equals("Tr")) && parts.length > 1) {
                    currentMtl.d = Float.valueOf(parts[1]).floatValue();
                    continue;
                }
                if (!parts[0].equals("Ns") || parts.length <= 1) continue;
                currentMtl.ns = Float.valueOf(parts[1]).floatValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected static int rgbaValue(PVector color) {
        return 0xFF000000 | (int)(color.x * 255.0f) << 16 | (int)(color.y * 255.0f) << 8 | (int)(color.z * 255.0f);
    }

    protected static int rgbaValue(PVector color, float alpha) {
        return (int)(alpha * 255.0f) << 24 | (int)(color.x * 255.0f) << 16 | (int)(color.y * 255.0f) << 8 | (int)(color.z * 255.0f);
    }

    protected static String getBasePath(PApplet parent, String filename) {
        File file = new File(parent.dataPath(filename));
        if (!file.exists()) {
            file = parent.sketchFile(filename);
        }
        String absolutePath = file.getAbsolutePath();
        return absolutePath.substring(0, absolutePath.lastIndexOf(File.separator));
    }

    protected static class OBJFace {
        ArrayList<Integer> vertIdx = new ArrayList();
        ArrayList<Integer> texIdx = new ArrayList();
        ArrayList<Integer> normIdx = new ArrayList();
        int matIdx = -1;
        String name = "";

        OBJFace() {
        }
    }

    protected static class OBJMaterial {
        String name;
        PVector ka;
        PVector kd;
        PVector ks;
        float d;
        float ns;
        PImage kdMap;

        OBJMaterial() {
            this("default");
        }

        OBJMaterial(String name) {
            this.name = name;
            this.ka = new PVector(0.5f, 0.5f, 0.5f);
            this.kd = new PVector(0.5f, 0.5f, 0.5f);
            this.ks = new PVector(0.5f, 0.5f, 0.5f);
            this.d = 1.0f;
            this.ns = 0.0f;
            this.kdMap = null;
        }
    }
}

