/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.opengl.shaders;

import org.lwjgl.opengl.ARBProgram;
import org.lwjgl.opengl.GL11;
import org.lwjgl.test.opengl.shaders.Shader;
import org.lwjgl.test.opengl.shaders.ShadersTest;

final class ShaderFP
extends Shader {
    final String vpFile;
    final String vpSource;
    final int vpID;
    final String fpFile;
    final String fpSource;
    final int fpID;

    ShaderFP(String vpShaderFile, String fpShaderFile) {
        this.vpFile = vpShaderFile;
        this.vpSource = ShaderFP.getShaderText(vpShaderFile);
        this.vpID = ARBProgram.glGenProgramsARB();
        ARBProgram.glBindProgramARB(34336, this.vpID);
        ARBProgram.glProgramStringARB(34336, 34933, this.vpSource);
        ShaderFP.checkProgramError(this.vpFile, this.vpSource);
        this.fpFile = fpShaderFile;
        this.fpSource = ShaderFP.getShaderText(fpShaderFile);
        this.fpID = ARBProgram.glGenProgramsARB();
        ARBProgram.glBindProgramARB(34820, this.fpID);
        ARBProgram.glProgramStringARB(34820, 34933, this.fpSource);
        ShaderFP.checkProgramError(this.fpFile, this.fpSource);
    }

    void render() {
        GL11.glEnable(34336);
        ARBProgram.glBindProgramARB(34336, this.vpID);
        GL11.glEnable(34820);
        ARBProgram.glBindProgramARB(34820, this.fpID);
        ARBProgram.glProgramLocalParameter4fARB(34336, 0, ShadersTest.getSin(), (float)ShadersTest.getSpecularity() * 8.0f, 0.0f, 0.0f);
        ARBProgram.glProgramLocalParameter4fARB(34820, 0, ShadersTest.getSin(), (float)ShadersTest.getSpecularity() * 8.0f, (float)(-ShadersTest.getDisplayWidth()) * 0.5f, (float)(-ShadersTest.getDisplayHeight()) * 0.5f);
        ShadersTest.renderObject();
        GL11.glDisable(34336);
        GL11.glDisable(34820);
    }

    void cleanup() {
        ARBProgram.glDeleteProgramsARB(this.vpID);
        ARBProgram.glDeleteProgramsARB(this.fpID);
    }
}

