/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.input;

import org.lwjgl.Sys;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.DisplayMode;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.vector.Vector2f;

public class MouseCreationTest {
    private Vector2f position = new Vector2f(320.0f, 240.0f);

    private void initialize(boolean fullscreen) {
        try {
            this.setDisplayMode();
            Display.setFullscreen(fullscreen);
            Display.create();
            Mouse.setGrabbed(true);
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(-1);
        }
        this.initializeOpenGL();
    }

    protected boolean setDisplayMode() {
        try {
            DisplayMode[] dm = org.lwjgl.util.Display.getAvailableDisplayModes(640, 480, -1, -1, -1, -1, 60, 60);
            org.lwjgl.util.Display.setDisplayMode(dm, new String[]{"width=640", "height=480", "freq=60", "bpp=" + Display.getDisplayMode().getBitsPerPixel()});
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private void initializeOpenGL() {
        GL11.glClearColor(0.0f, 0.0f, 0.0f, 0.0f);
        GL11.glMatrixMode(5889);
        GL11.glLoadIdentity();
        GL11.glOrtho(0.0, Display.getDisplayMode().getWidth(), 0.0, Display.getDisplayMode().getHeight(), -1.0, 1.0);
        GL11.glMatrixMode(5888);
        GL11.glLoadIdentity();
        GL11.glViewport(0, 0, Display.getDisplayMode().getWidth(), Display.getDisplayMode().getHeight());
    }

    public void executeTest() {
        this.initialize(false);
        System.out.println("Test ready:\n");
        System.out.println("=========== WINDOWED MODE ==============");
        for (int i = 0; i < 2; ++i) {
            System.out.println("Test " + (i + 1) + ":");
            this.wiggleMouse();
            System.out.println("");
        }
        System.out.print("Destroying display...");
        System.out.println("success");
        System.out.print("Entering fullscreen mode...");
        try {
            Display.destroy();
            this.initialize(true);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("success");
        System.out.println("=========== FULLSCREEN MODE ==============");
        for (int i = 0; i < 2; ++i) {
            System.out.println("Test " + (i + 3) + ":");
            this.wiggleMouse();
            System.out.println("");
        }
        System.out.println("Test completed successfully!");
        System.out.print("Shutting down...");
        Display.destroy();
        System.out.println("shutdown complete");
    }

    private void wiggleMouse() {
        System.out.print("Please move the mouse around");
        long statustime = Sys.getTime();
        long endtime = Sys.getTime() + Sys.getTimerResolution() * 5L;
        while (Sys.getTime() < endtime) {
            Display.update();
            while (Mouse.next()) {
            }
            this.position.x += (float)Mouse.getDX();
            this.position.y += (float)Mouse.getDY();
            if (this.position.x < 0.0f) {
                this.position.x = 0.0f;
            } else if (this.position.x > 580.0f) {
                this.position.x = 580.0f;
            }
            if (this.position.y < 0.0f) {
                this.position.y = 0.0f;
            } else if (this.position.y > 450.0f) {
                this.position.y = 450.0f;
            }
            this.render();
            if (Sys.getTime() - statustime <= Sys.getTimerResolution()) continue;
            System.out.print(".");
            statustime = Sys.getTime();
        }
        System.out.println("thank you");
    }

    private void render() {
        GL11.glClear(16384);
        GL11.glBegin(9);
        float color = 1.0f;
        boolean buttonDown = false;
        for (int i = 0; i < Mouse.getButtonCount(); ++i) {
            if (!Mouse.isButtonDown(i)) continue;
            color = 1.0f / (float)Mouse.getButtonCount() * (float)(i + 1);
            break;
        }
        GL11.glColor3f(color, color, color);
        GL11.glVertex2f(this.position.x + 0.0f, this.position.y + 0.0f);
        GL11.glVertex2f(this.position.x + 0.0f, this.position.y + 30.0f);
        GL11.glVertex2f(this.position.x + 40.0f, this.position.y + 30.0f);
        GL11.glVertex2f(this.position.x + 60.0f, this.position.y + 15.0f);
        GL11.glVertex2f(this.position.x + 40.0f, this.position.y + 0.0f);
        GL11.glEnd();
    }

    public static void main(String[] args) {
        MouseCreationTest mt = new MouseCreationTest();
        mt.executeTest();
        System.exit(0);
    }
}

