/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.applet;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.nio.FloatBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.ARBTransposeMatrix;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GLContext;

public class GearsApplet
extends Applet {
    Canvas display_parent;
    Thread gameThread;
    boolean running;
    private float view_rotx = 20.0f;
    private float view_roty = 30.0f;
    private float view_rotz;
    private int gear1;
    private int gear2;
    private int gear3;
    private float angle;
    boolean keyDown;
    private int prevMouseX;
    private int prevMouseY;
    private boolean mouseButtonDown;

    public void startLWJGL() {
        this.gameThread = new Thread(){

            public void run() {
                GearsApplet.this.running = true;
                try {
                    Display.setParent(GearsApplet.this.display_parent);
                    Display.create();
                    GearsApplet.this.initGL();
                }
                catch (LWJGLException e) {
                    e.printStackTrace();
                }
                GearsApplet.this.gameLoop();
            }
        };
        this.gameThread.start();
    }

    private void stopLWJGL() {
        this.running = false;
        try {
            this.gameThread.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public void start() {
    }

    public void stop() {
    }

    public void destroy() {
        this.remove(this.display_parent);
        super.destroy();
        System.out.println("Clear up");
    }

    public void init() {
        this.setLayout(new BorderLayout());
        try {
            this.display_parent = new Canvas(){

                public void addNotify() {
                    super.addNotify();
                    GearsApplet.this.startLWJGL();
                }

                public void removeNotify() {
                    GearsApplet.this.stopLWJGL();
                    super.removeNotify();
                }
            };
            this.display_parent.setSize(this.getWidth(), this.getHeight());
            this.add(this.display_parent);
            this.display_parent.setFocusable(true);
            this.display_parent.requestFocus();
            this.display_parent.setIgnoreRepaint(true);
            this.setVisible(true);
        }
        catch (Exception e) {
            System.err.println(e);
            throw new RuntimeException("Unable to create display");
        }
    }

    public void gameLoop() {
        long startTime = System.currentTimeMillis() + 5000L;
        long fps = 0L;
        while (this.running) {
            this.angle += 2.0f;
            this.drawLoop();
            Display.update();
            if (startTime > System.currentTimeMillis()) {
                ++fps;
            } else {
                long timeUsed = 5000L + (startTime - System.currentTimeMillis());
                startTime = System.currentTimeMillis() + 5000L;
                System.out.println(fps + " frames 2 in " + (float)timeUsed / 1000.0f + " seconds = " + (float)fps / ((float)timeUsed / 1000.0f));
                fps = 0L;
            }
            if (Mouse.isButtonDown(0)) {
                if (!this.mouseButtonDown) {
                    this.prevMouseX = Mouse.getX();
                    this.prevMouseY = Mouse.getY();
                }
                this.mouseButtonDown = true;
            } else {
                this.mouseButtonDown = false;
            }
            if (this.mouseButtonDown) {
                int x = Mouse.getX();
                int y = Mouse.getY();
                float thetaY = 360.0f * ((float)(x - this.prevMouseX) / (float)this.display_parent.getWidth());
                float thetaX = 360.0f * ((float)(this.prevMouseY - y) / (float)this.display_parent.getHeight());
                this.prevMouseX = x;
                this.prevMouseY = y;
                this.view_rotx += thetaX;
                this.view_roty += thetaY;
            }
            if (!this.keyDown || Keyboard.isKeyDown(33)) continue;
            this.keyDown = false;
            try {
                if (Display.isFullscreen()) {
                    Display.setFullscreen(false);
                    continue;
                }
                Display.setFullscreen(true);
            }
            catch (LWJGLException e) {
                e.printStackTrace();
            }
        }
        Display.destroy();
    }

    public void drawLoop() {
        GL11.glClear(16640);
        GL11.glPushMatrix();
        GL11.glRotatef(this.view_rotx, 1.0f, 0.0f, 0.0f);
        GL11.glRotatef(this.view_roty, 0.0f, 1.0f, 0.0f);
        GL11.glRotatef(this.view_rotz, 0.0f, 0.0f, 1.0f);
        GL11.glPushMatrix();
        GL11.glTranslatef(-3.0f, -2.0f, 0.0f);
        GL11.glRotatef(this.angle, 0.0f, 0.0f, 1.0f);
        GL11.glCallList(this.gear1);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(3.1f, -2.0f, 0.0f);
        GL11.glRotatef(-2.0f * this.angle - 9.0f, 0.0f, 0.0f, 1.0f);
        GL11.glCallList(this.gear2);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef(-3.1f, 4.2f, 0.0f);
        GL11.glRotatef(-2.0f * this.angle - 25.0f, 0.0f, 0.0f, 1.0f);
        GL11.glCallList(this.gear3);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    protected void initGL() {
        try {
            FloatBuffer pos = BufferUtils.createFloatBuffer(4).put(new float[]{5.0f, 5.0f, 10.0f, 0.0f});
            FloatBuffer red = BufferUtils.createFloatBuffer(4).put(new float[]{0.8f, 0.1f, 0.0f, 1.0f});
            FloatBuffer green = BufferUtils.createFloatBuffer(4).put(new float[]{0.0f, 0.8f, 0.2f, 1.0f});
            FloatBuffer blue = BufferUtils.createFloatBuffer(4).put(new float[]{0.2f, 0.2f, 1.0f, 1.0f});
            pos.flip();
            red.flip();
            green.flip();
            blue.flip();
            GL11.glLight(16384, 4611, pos);
            GL11.glEnable(2884);
            GL11.glEnable(2896);
            GL11.glEnable(16384);
            GL11.glEnable(2929);
            this.gear1 = GL11.glGenLists(1);
            GL11.glNewList(this.gear1, 4864);
            GL11.glMaterial(1028, 5634, red);
            this.gear(1.0f, 4.0f, 1.0f, 20, 0.7f);
            GL11.glEndList();
            this.gear2 = GL11.glGenLists(1);
            GL11.glNewList(this.gear2, 4864);
            GL11.glMaterial(1028, 5634, green);
            this.gear(0.5f, 2.0f, 2.0f, 10, 0.7f);
            GL11.glEndList();
            this.gear3 = GL11.glGenLists(1);
            GL11.glNewList(this.gear3, 4864);
            GL11.glMaterial(1028, 5634, blue);
            this.gear(1.3f, 2.0f, 0.5f, 10, 0.7f);
            GL11.glEndList();
            GL11.glEnable(2977);
            GL11.glMatrixMode(5889);
            System.err.println("LWJGL: " + Sys.getVersion() + " / " + LWJGLUtil.getPlatformName());
            System.err.println("GL_VENDOR: " + GL11.glGetString(7936));
            System.err.println("GL_RENDERER: " + GL11.glGetString(7937));
            System.err.println("GL_VERSION: " + GL11.glGetString(7938));
            System.err.println();
            System.err.println("glLoadTransposeMatrixfARB() supported: " + GLContext.getCapabilities().GL_ARB_transpose_matrix);
            if (!GLContext.getCapabilities().GL_ARB_transpose_matrix) {
                GL11.glLoadIdentity();
            } else {
                FloatBuffer identityTranspose = BufferUtils.createFloatBuffer(16).put(new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f});
                identityTranspose.flip();
                ARBTransposeMatrix.glLoadTransposeMatrixARB(identityTranspose);
            }
            float h = (float)this.display_parent.getHeight() / (float)this.display_parent.getWidth();
            GL11.glFrustum(-1.0, 1.0, -h, h, 5.0, 60.0);
            GL11.glMatrixMode(5888);
            GL11.glLoadIdentity();
            GL11.glTranslatef(0.0f, 0.0f, -40.0f);
        }
        catch (Exception e) {
            System.err.println(e);
            this.running = false;
        }
    }

    private void gear(float inner_radius, float outer_radius, float width, int teeth, float tooth_depth) {
        float angle;
        int i;
        float r0 = inner_radius;
        float r1 = outer_radius - tooth_depth / 2.0f;
        float r2 = outer_radius + tooth_depth / 2.0f;
        float da = (float)Math.PI * 2 / (float)teeth / 4.0f;
        GL11.glShadeModel(7424);
        GL11.glNormal3f(0.0f, 0.0f, 1.0f);
        GL11.glBegin(8);
        for (i = 0; i <= teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), width * 0.5f);
            GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), width * 0.5f);
            if (i >= teeth) continue;
            GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), width * 0.5f);
            GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), width * 0.5f);
        }
        GL11.glEnd();
        GL11.glBegin(7);
        for (i = 0; i < teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), width * 0.5f);
            GL11.glVertex3f(r2 * (float)Math.cos(angle + da), r2 * (float)Math.sin(angle + da), width * 0.5f);
            GL11.glVertex3f(r2 * (float)Math.cos(angle + 2.0f * da), r2 * (float)Math.sin(angle + 2.0f * da), width * 0.5f);
            GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), width * 0.5f);
        }
        GL11.glEnd();
        GL11.glBegin(8);
        for (i = 0; i <= teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), -width * 0.5f);
            GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), -width * 0.5f);
            GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), -width * 0.5f);
            GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), -width * 0.5f);
        }
        GL11.glEnd();
        GL11.glBegin(7);
        for (i = 0; i < teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), -width * 0.5f);
            GL11.glVertex3f(r2 * (float)Math.cos(angle + 2.0f * da), r2 * (float)Math.sin(angle + 2.0f * da), -width * 0.5f);
            GL11.glVertex3f(r2 * (float)Math.cos(angle + da), r2 * (float)Math.sin(angle + da), -width * 0.5f);
            GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), -width * 0.5f);
        }
        GL11.glEnd();
        GL11.glBegin(8);
        for (i = 0; i < teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), width * 0.5f);
            GL11.glVertex3f(r1 * (float)Math.cos(angle), r1 * (float)Math.sin(angle), -width * 0.5f);
            float u = r2 * (float)Math.cos(angle + da) - r1 * (float)Math.cos(angle);
            float v = r2 * (float)Math.sin(angle + da) - r1 * (float)Math.sin(angle);
            float len = (float)Math.sqrt(u * u + v * v);
            GL11.glNormal3f(v /= len, -(u /= len), 0.0f);
            GL11.glVertex3f(r2 * (float)Math.cos(angle + da), r2 * (float)Math.sin(angle + da), width * 0.5f);
            GL11.glVertex3f(r2 * (float)Math.cos(angle + da), r2 * (float)Math.sin(angle + da), -width * 0.5f);
            GL11.glNormal3f((float)Math.cos(angle), (float)Math.sin(angle), 0.0f);
            GL11.glVertex3f(r2 * (float)Math.cos(angle + 2.0f * da), r2 * (float)Math.sin(angle + 2.0f * da), width * 0.5f);
            GL11.glVertex3f(r2 * (float)Math.cos(angle + 2.0f * da), r2 * (float)Math.sin(angle + 2.0f * da), -width * 0.5f);
            u = r1 * (float)Math.cos(angle + 3.0f * da) - r2 * (float)Math.cos(angle + 2.0f * da);
            v = r1 * (float)Math.sin(angle + 3.0f * da) - r2 * (float)Math.sin(angle + 2.0f * da);
            GL11.glNormal3f(v, -u, 0.0f);
            GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), width * 0.5f);
            GL11.glVertex3f(r1 * (float)Math.cos(angle + 3.0f * da), r1 * (float)Math.sin(angle + 3.0f * da), -width * 0.5f);
            GL11.glNormal3f((float)Math.cos(angle), (float)Math.sin(angle), 0.0f);
        }
        GL11.glVertex3f(r1 * (float)Math.cos(0.0), r1 * (float)Math.sin(0.0), width * 0.5f);
        GL11.glVertex3f(r1 * (float)Math.cos(0.0), r1 * (float)Math.sin(0.0), -width * 0.5f);
        GL11.glEnd();
        GL11.glShadeModel(7425);
        GL11.glBegin(8);
        for (i = 0; i <= teeth; ++i) {
            angle = (float)i * 2.0f * (float)Math.PI / (float)teeth;
            GL11.glNormal3f(-((float)Math.cos(angle)), -((float)Math.sin(angle)), 0.0f);
            GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), -width * 0.5f);
            GL11.glVertex3f(r0 * (float)Math.cos(angle), r0 * (float)Math.sin(angle), width * 0.5f);
        }
        GL11.glEnd();
    }
}

