/*
 * Decompiled with CFR 0.152.
 */
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class Input {
    private boolean[] keys = new boolean[1337];
    private boolean[] previousKeys = new boolean[1337];
    private boolean[] mouse = new boolean[1337];
    private boolean[] previousMouse = new boolean[1337];
    private int mouseOffset = 100;

    public void poll() {
        this.previousKeys = (boolean[])this.keys.clone();
        while (Keyboard.next()) {
            this.keys[Keyboard.getEventKey()] = Keyboard.getEventKeyState();
        }
        this.previousMouse = (boolean[])this.mouse.clone();
        while (Mouse.next()) {
            this.mouse[this.mouseOffset + Mouse.getEventButton()] = Mouse.getEventButtonState();
        }
    }

    public boolean isKeyReleased(int k) {
        return !this.keys[k] && this.previousKeys[k];
    }

    public boolean isKeyPressed(int k) {
        return this.keys[k] && !this.previousKeys[k];
    }

    public boolean isKeyDown(int k) {
        return this.keys[k];
    }

    public boolean isKeyUp(int k) {
        return !this.keys[k];
    }

    public boolean isAnyKeyDown() {
        boolean[] blArray = this.keys;
        int n = this.keys.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b = blArray[n2];
            if (b) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isAnyKeyPressed() {
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i] && !this.previousKeys[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int getMouseX() {
        return Mouse.getX();
    }

    public int getMouseY() {
        return Mouse.getY();
    }

    public float getNormalY() {
        return (float)(Mouse.getY() - 300) / 300.0f;
    }

    public float getNormalX() {
        return (float)(Mouse.getX() - 400) / 400.0f;
    }

    public boolean isMouseDown(int button) {
        return this.mouse[this.mouseOffset + button];
    }

    public boolean isMousePressed(int button) {
        return this.mouse[this.mouseOffset + button] && !this.previousMouse[this.mouseOffset + button];
    }
}

