uniform extern float4x4 g_WVP 	     : XDL2SM_WORLD_VIEW_PROJECTION;
uniform extern float4x4 g_World	     : XDL2SM_WORLD;
uniform extern float4x4 g_WorldIT    : XDL2SM_WORLD_INVERSE_TRANSPOSE;
uniform extern float4x4 g_View       : XDL2SM_VIEW;

uniform extern float4 g_Ambient  : XDL2SV_MATERIAL_AMBIENT = { 0.0f, 0.0f, 0.0f, 1.0f };
uniform extern float4 g_Diffuse  : XDL2SV_MATERIAL_DIFFUSE = { 0.9f, 0.9f, 0.9f, 1.0f };

uniform extern float4 g_EyePos : XDL2SV_EYE_POSITION;

uniform extern texture g_Texture : XDL2ST_TEXTURE_1;
uniform extern texture g_Texture2 : XDL2ST_TEXTURE_2;
uniform extern texture g_Texture3 : XDL2ST_TEXTURE_3;

uniform extern float4 g_Light : XDL2SV_LIGHT_POSITION;

float gTime : XDL2SF_CUSTOM_0;

#include "Base/light.fxh"

sampler texSample = sampler_state
{
	Texture = <g_Texture>;

    	MinFilter = Anisotropic;
    	MagFilter = Anisotropic;
    
    	MaxAnisotropy = 8;
};

sampler texSample2 = sampler_state
{
	Texture = <g_Texture2>;

    	MinFilter = Anisotropic;
    	MagFilter = Anisotropic;
    
    	MaxAnisotropy = 8;
};

sampler texSample3 = sampler_state
{
	Texture = <g_Texture3>;

    	MinFilter = Anisotropic;
    	MagFilter = Anisotropic;
    
	AddressU = WRAP;
	AddressV = CLAMP;
    	MaxAnisotropy = 8;
};
struct VertexShaderOut
{
	float4 pos  : POSITION0;
	float3 normal  : TEXCOORD0;
	float3 posW : TEXCOORD1;
	float2 tex : TEXCOORD2;
	float4 oz : TEXCOORD3;
};

VertexShaderOut VertexShader(float3 posa : POSITION0, float3 normal : NORMAL0, float2 tex : TEXCOORD0)
{
	VertexShaderOut vso = (VertexShaderOut)0;
		
	float f = (sin(2*gTime+posa.y*14) + cos(3*gTime+posa.x*13))/2;
	posa.z +=  f*0.0025;
	posa*=50;
	vso.normal = normal;

	vso.pos = mul( float4(posa,1.0f), g_WVP );
	vso.posW = mul( float4(posa,1.0f), g_World );
	vso.normal = mul( float4(normal,0.0f), g_WorldIT );
	vso.tex = tex;

	return vso;
}

float4 PixelShader(float3 normal : TEXCOORD0, float3 pos : TEXCOORD1, float2 tex : TEXCOORD2, float4 oz : TEXCOORD3) : COLOR
{
	float2 ntex = tex*2.5;

	tex.x += gTime*1.25f;
	tex.y += sin(tex.x)*0.1;

	ntex.x += gTime*1.25f;
	ntex.y += sin(tex.x)*0.1;

	float3 normal1 = 2*tex2D(texSample,ntex)-1;
	ntex.x -= gTime*0.03;
	ntex.y -= gTime*0.01;
	float3 normal2 = (2*tex2D(texSample2,ntex)-1);

	normal = ((normal1+normal2) + (normal1*normal2))/2;	

	float temp = normal.y;
	normal.y = normal.z;
	normal.z = temp;

	normal = normalize(normal);
			
	float3 toEye = normalize(g_EyePos-pos);

	float3 lightVec = normalize(g_Light.xyz-pos);
	float4 pdiff = LightDiffuse(normal,lightVec);
	float4 pspec = LightSpec(normal,lightVec,toEye,16);

	float3 refrac = normalize(-(normal*0.5f + toEye));
	float2 lookup = tex;
	
	refrac = (1.0f+refrac)/2;
	lookup.x += normal.x*0.06;
	lookup.y += normal.z*0.06;

	float4 reflec = tex2D(texSample3,lookup);
	float4 col =(g_Diffuse*pdiff*reflec)+pspec;

	float darken = 1.0f/distance(pos,g_EyePos);
	darken *= 16.0;
	darken *= darken*darken;
	darken = min(darken,1.0);
	col.w *= darken;
	float4 fin = col;//*darken;

	return	fin;
}

technique Shader
{
	pass P0
	{
		vertexShader = compile vs_2_0 VertexShader();
		pixelShader = compile ps_2_0 PixelShader();
		SrcBlend = SrcAlpha;
		DestBlend = InvSrcAlpha;
		AlphaBlendEnable = TRUE;
		ZEnable = FALSE;
	}
}

