uniform extern float4x4 gWVP 		: XDL2SM_WORLD_VIEW_PROJECTION;

uniform extern float4x4 gWorld		: XDL2SM_WORLD;
uniform extern float4x4 gWorldIT	: XDL2SM_WORLD_INVERSE_TRANSPOSE;
uniform extern float4x4 gView		: XDL2SM_VIEW;

uniform extern float4 gAmbient 	: XDL2SV_MATERIAL_AMBIENT;
uniform extern float4 gDiffuse 	: XDL2SV_MATERIAL_DIFFUSE;
uniform extern float4 gSpecular : XDL2SV_MATERIAL_SPECULAR;

uniform extern texture gTexture_1 : XDL2ST_TEXTURE_1;
uniform extern texture gTexture_1_Transform : XDL2ST_TEXTURE_1_TRANSFORM;

uniform extern texture gTexture_2 : XDL2ST_TEXTURE_2;
uniform extern texture gTexture_2_Transform : XDL2ST_TEXTURE_2_TRANSFORM;


sampler sTex_1 = sampler_state
{
	Texture = <gTexture_1>;

   	MinFilter = Anisotropic;
    	MagFilter = Anisotropic;
    
    	MaxAnisotropy = 8;
};

struct VertexShaderIn
{
	float3 pos : POSITION0;
	float3 normal : NORMAL0;
	float2 texcoord : TEXCOORD0;
};

struct VertexShaderOut
{
	float4 pos : POSITION0;
	float2 texcoord : TEXCOORD0;
};

VertexShaderOut VertexShader(VertexShaderIn vsi)
{
	VertexShaderOut vso = (VertexShaderOut)0;
	
	vso.pos = mul( float4(vsi.pos,1.0f), gWVP );
	vso.texcoord = vsi.texcoord;
	
	return vso;
}

struct PixelShaderIn
{
	float2 texcoord : TEXCOORD0;
};

float4 PixelShader(PixelShaderIn psi) : COLOR
{
	float4 col = gAmbient + tex2D(sTex_1,psi.texcoord);
	return col;
}

technique Fx
{
	pass P0
	{
		vertexShader = compile vs_2_0 VertexShader();
		pixelShader = compile ps_2_0 PixelShader();
	}
}